/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatchPlatformValidator {
    private static final String OH_PROPERTIES_XML = "inventory" + File.separator + "ContentsXML" + File.separator + "oraclehomeproperties.xml";
    private Logger _logger = Logger.getLogger(PatchPlatformValidator.class.getName());
    private File invFile;

    public boolean validatePatch(String patchLocation) throws OPatchAutoException {
        ArrayList<String> genericPlatformIDList = new ArrayList<String>();
        genericPlatformIDList.add("0");
        genericPlatformIDList.add("289");
        genericPlatformIDList.add("2000");
        List<Object> patchARUIDlist = new ArrayList();
        patchARUIDlist = this.findPatchARUID(patchLocation);
        String platformARUID = this.findPlatformARUID();
        if (patchARUIDlist != null) {
            for (int i = 0; i < patchARUIDlist.size(); ++i) {
                if (!genericPlatformIDList.contains(((String)patchARUIDlist.get(i)).trim())) continue;
                this._logger.info("Generic patch.");
                return true;
            }
            return platformARUID != null && patchARUIDlist.contains(platformARUID.trim());
        }
        return false;
    }

    private List<String> findPatchARUID(String patchLocation) throws OPatchAutoException {
        NodeList nodeList;
        File patchLoc = new File(patchLocation);
        this.searchFile(patchLoc);
        String aruID = null;
        ArrayList<String> aruIDlist = new ArrayList<String>();
        if (this.invFile != null && (nodeList = this.getNodeList(this.invFile, "platform")) != null && nodeList.getLength() > 0) {
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element el = (Element)nodeList.item(j);
                if (!el.hasAttribute("id")) continue;
                aruID = el.getAttribute("id");
                aruIDlist.add(aruID);
            }
        }
        this._logger.info("Patch Aru ids are:" + aruIDlist);
        return aruIDlist;
    }

    private void searchFile(File patchLoc) throws OPatchAutoException {
        File[] tmpFiles = patchLoc.listFiles();
        if (tmpFiles == null || tmpFiles.length == 0) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72156), (Object[])new Object[0]), new Object[0]);
        }
        for (File file : tmpFiles) {
            if (!file.isDirectory()) {
                if (file.getName().equals("inventory.xml")) {
                    this.invFile = file;
                    break;
                }
            } else {
                this.searchFile(new File(file.getAbsolutePath()));
            }
            if (this.invFile != null) break;
        }
    }

    private String findPlatformARUID() {
        String platformID = null;
        String homePath = System.getProperty("OPatch.ORACLE_HOME");
        File ohPropertyFile = new File(homePath + File.separator + OH_PROPERTIES_XML);
        NodeList nodeList = this.getNodeList(ohPropertyFile, "ARU_ID");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element el = (Element)nodeList.item(j);
                platformID = el.getTextContent();
            }
        }
        this._logger.info("Platform Aru id:" + platformID);
        return platformID;
    }

    private NodeList getNodeList(File xmlFile, String elementname) {
        NodeList nodeList = null;
        if (xmlFile.exists() && !xmlFile.isDirectory()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
                Document doc = db.parse(xmlFile);
                doc.getDocumentElement().normalize();
                nodeList = doc.getElementsByTagName(elementname);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                this._logger.warning(e.getMessage());
            }
        }
        return nodeList;
    }
}

