/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.core.oplan.IOUtils;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.driver.crs.CrsProductDriver;
import dbmodel.SystemInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class RemoteHostReader {
    private static final String OPATCHAUTO_HOME = "OPatchAuto.HOME";

    public static void main(String[] args) {
        RemoteHostReader remoteHostReader = new RemoteHostReader();
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String ohLocation = null;
        String walletLoc = null;
        String hostname = null;
        for (int i = 0; i < argsList.size(); ++i) {
            if (((String)argsList.get(i)).equalsIgnoreCase("-oh")) {
                ohLocation = (String)argsList.get(++i);
                continue;
            }
            if (((String)argsList.get(i)).equalsIgnoreCase("-walletloc")) {
                walletLoc = (String)argsList.get(++i);
                continue;
            }
            if (!((String)argsList.get(i)).equalsIgnoreCase("-hostname")) continue;
            hostname = (String)argsList.get(++i);
        }
        try {
            remoteHostReader.buildSystemInstance(ohLocation, walletLoc, hostname);
        }
        catch (OPatchAutoException e) {
            Reporting.report((String)e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    private File createSystemInstanceXML(String hostname) throws OPatchAutoException {
        String crsOwner = OUIDriver.checkFileOwner((File)new File(System.getProperty(OPATCHAUTO_HOME), DBCommonPatchingConstants.OPATCHAUTO_DB_SCRIPT));
        String crsFilePath = System.getProperty(OPATCHAUTO_HOME) + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP_SDB_INSTANCE;
        String crsFileName = crsFilePath + "opatch_remote_" + hostname + "_config.xml";
        File configXML = new File(crsFileName);
        boolean ok = DBPatchingUtil.mkdirs((String)crsFilePath, (String)crsOwner, null);
        if (!ok) {
            throw new OPatchAutoException("Unable to create the dir : " + crsFilePath, new Object[0]);
        }
        DBPatchingUtil.createNewFile((String)crsFileName, (String)crsOwner, null);
        return configXML;
    }

    private void buildSystemInstance(String ohValue, String walletLoc, String hostname) throws OPatchAutoException {
        DBPatchingHelper.setupEnvironment((String)System.getProperty("ORACLE_HOME"), (String)(System.getProperty("ORACLE_HOME") + "oraInst.loc"));
        char[] walletPwd = null;
        CrsProductDriver crspd = CrsProductDriver.getCrsProductDriverForNonRootAccess((String)walletLoc, walletPwd);
        SystemInstance sysInst = crspd.buildSystemInstance();
        File configFile = null;
        try {
            configFile = this.createSystemInstanceXML(hostname);
            sysInst.writeFile(configFile);
            IOUtils.chmodTo775((File)configFile, null);
        }
        catch (FileNotFoundException e) {
            throw new OPatchAutoException("File not found " + configFile + " :\n" + e.getMessage(), new Object[0]);
        }
    }

    static {
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautodb/opatchauto-db");
        ResourceBundleManager.setPrefix((String)"opatchauto", (String)"OPATCHAUTO");
    }
}

