/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.patch;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import oracle.oplan.sdk.patch.PatchBundlexml;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchCompositeXML {
    private Logger logger = Logger.getLogger(PatchCompositeXML.class.getName());
    private final String compositexml;
    private List<String> subPatches;

    public PatchCompositeXML(String compositexml) throws BundleValidationException, IOException, BundleXmlException {
        this.compositexml = compositexml;
        this.fillInfoFromCompositeXml();
    }

    private void fillInfoFromCompositeXml() throws BundleValidationException, IOException, BundleXmlException {
        this.logger.entering(PatchBundlexml.class.getName(), "fillInfoFromBundleXml");
        CompositeHandler eh = new CompositeHandler(this);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(new InputSource(new StringReader(this.compositexml)), (DefaultHandler)eh);
            if (this.subPatches == null || this.subPatches.isEmpty()) {
                this.logger.log(Level.WARNING, "Couldn't get the list of patches from the composite.xml");
                throw new SAXException("Couldn't get the list of patches from the composite.xml");
            }
            this.logger.exiting(PatchCompositeXML.class.getName(), "fillInfoFromCompositeXml");
        }
        catch (SAXException e) {
            throw new BundleValidationException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BundleXmlException((Throwable)e);
        }
    }

    public String getCompositexml() {
        return this.compositexml;
    }

    public List<String> getSubPatches() {
        return this.subPatches;
    }

    static class CompositeHandler
    extends DefaultHandler {
        private Logger logger = Logger.getLogger(CompositeHandler.class.getName());
        private PatchCompositeXML pb;
        List<String> subPatches = new ArrayList<String>();
        private String patchID = null;

        CompositeHandler(PatchCompositeXML pb) {
            this.pb = pb;
            pb.subPatches = this.subPatches;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("patch")) {
                this.patchID = attributes.getValue("id");
                if (this.patchID == null) {
                    throw new SAXException("Encountered \"patch\" element with no id attribute in composite.xml");
                }
                if (!this.subPatches.contains(this.patchID)) {
                    this.subPatches.add(this.patchID);
                }
            }
        }
    }
}

