/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.SqlCommand;
import oracle.oplan.core.readme.HtmlReadmeGenerator;
import oracle.oplan.core.readme.ReadmeDecorator;
import oracle.oplan.core.readme.ReadmeGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.VariableResolver;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadmeGeneratorBase
implements ReadmeGenerator {
    private Logger logger = Logger.getLogger(HtmlReadmeGenerator.class.getName());
    protected ReadmeFactory rf;
    protected final String STEP = OPlanBundle.getReadmeMessage("STEP", new Object[0]) + " ";
    protected final String TROUBLE = OPlanBundle.getReadmeMessage("TROUBLESHOOT", new Object[0]);
    protected List<ExecutionPlan> allPlans;
    private ReadmeDecorator decor;
    private Set<String> currentFilterHosts;

    public ReadmeGeneratorBase(ReadmeFactory rf) {
        this.rf = rf;
    }

    @Override
    public abstract List<File> generateReadme() throws IOException;

    protected OPlanEnv getOplanEnv() {
        return OPlan.getInstance().getOPlanEnv();
    }

    protected String getTargetName(ExecutionPlan plan) {
        return plan.getApplyTarget().get(0).getValue();
    }

    protected abstract File getReadmeFile();

    protected void arrangePlansOrder() {
        this.allPlans = new ArrayList<ExecutionPlan>();
        this.arrangeApplyPlansOrder(this.rf.getPlans(), this.allPlans);
        this.arrangeRollbackPlansOrder(this.rf.getPlans(), this.allPlans);
    }

    protected void arrangeApplyPlansOrder(List<ExecutionPlan> plans, List<ExecutionPlan> arrangedPlans) {
        ExecutionPlan plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.applys(ExeuctionPlanUtil.outofplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.manuals(plans)))));
        if (plan != null) {
            arrangedPlans.add(plan);
            plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.switchbacks(ExeuctionPlanUtil.outofplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.manuals(plans)))));
            if (plan != null) {
                arrangedPlans.add(plan);
            }
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.applys(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.autos(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.applys(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.manuals(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.applys(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.dclis(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.applys(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.manuals(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
    }

    protected void arrangeRollbackPlansOrder(List<ExecutionPlan> plans, List<ExecutionPlan> arrangedPlans) {
        ExecutionPlan plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.rollbacks(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.autos(plans)))));
        if (plan != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.rollbacks(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.manuals(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.rollbacks(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.dclis(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.rollbacks(ExeuctionPlanUtil.inplaces(ExeuctionPlanUtil.nonrollings(ExeuctionPlanUtil.manuals(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
        if ((plan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.rollbacks(ExeuctionPlanUtil.outofplaces(ExeuctionPlanUtil.rollings(ExeuctionPlanUtil.manuals(plans)))))) != null) {
            arrangedPlans.add(plan);
        }
    }

    protected List<String> getPlanDescriptions(ExecutionPlan plan) {
        String str;
        ArrayList<String> res = new ArrayList<String>();
        if (plan.getAutomation().getDeploymentType().equals((Object)DeploymentType.IN_PLACE)) {
            str = OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "INPLACE_TITLE", new Object[0]);
            str = str + " - " + OPlanBundle.getPrefixedMessage(ReadmeGeneratorBase.class, ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "INPLACE_MESSAGE", new Object[0]);
            res.add(str);
        }
        if (plan.getAutomation().getDeploymentType().equals((Object)DeploymentType.OUT_OF_PLACE)) {
            str = OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "OPLACE_TITLE", new Object[0]);
            str = str + " - " + OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "OPLACE_MESSAGE", new Object[0]);
            res.add(str);
        }
        if (plan.getAutomation().getDeploymentSubType().equals((Object)DeploymentSubType.ROLLING_UPGRADE)) {
            str = OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "INPLACE_ROLLING_TITLE", new Object[0]);
            str = str + " - " + OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "INPLACE_ROLLING_MESSAGE", new Object[0]);
            res.add(str);
        }
        if (plan.getAutomation().getDeploymentSubType().equals((Object)DeploymentSubType.NON_ROLLING_UPGRADE)) {
            str = OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "INPLACE_NONROLLING_TITLE", new Object[0]);
            str = str + " - " + OPlanBundle.getPrefixedReadmeMessage(ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "INPLACE_NONROLLING_MESSAGE", new Object[0]);
            res.add(str);
        }
        return res;
    }

    protected void setDecoratorContext(ReadmeDecorator decor) {
        this.decor = decor;
    }

    protected String getTitle(ExecutionStep step) {
        return this.resolveVariables(OPlanBundle.getATitle(step.getReadme()), step);
    }

    protected String getMessage(ExecutionStep step) {
        return this.resolveVariables(OPlanBundle.getStepMessage(step.getReadme()), step);
    }

    protected String getTroubleshoot(ExecutionStep step) {
        return this.resolveVariables(OPlanBundle.getStepTroubleshoot(step.getReadme()), step);
    }

    protected String getTitle(ExecutionPhase phase) {
        return OPlanBundle.getATitle(phase.getAutomationPatchingPhase().getReadme());
    }

    protected String getPhaseTitle(ExecutionPhase phase) {
        String ret = this.getTitle(phase);
        if (ret == null || ret.trim().length() == 0) {
            ret = phase.getAutomationPatchingPhase().getName();
        }
        if (ret == null || ret.trim().length() == 0) {
            ret = ReadmeFactory.getPhaseTitle(phase.getExecutionPlan(), phase);
        }
        return ret;
    }

    protected String resolveVariables(String str, ExecutionStep step) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        String ret = VariableResolver.replaceContextProperties(str, step.getStepProperties());
        if (ret == null) {
            return null;
        }
        return MessageFormat.format(ret, this.decor.startHighlight(), this.decor.endHighlight());
    }

    protected String getCommandErrorMessage(ExecutionStep.Command cmd, ExecutionStep step) {
        SqlCommand.ErrorHandling.FatalError ferror = cmd.getErrorMessage();
        String error = OPlanBundle.getErrorMessage(ferror);
        if (error != null) {
            String resolved = this.resolveVariables(error, step);
            return resolved;
        }
        return null;
    }

    public void setCurrentFilterHosts(Set<String> currentFilterHosts) {
        this.currentFilterHosts = currentFilterHosts;
    }

    public Set<String> getCurrentFilterHosts() {
        return this.currentFilterHosts;
    }
}

