/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.ui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import oracle.oplan.sdk.oplan.OPlan;

public class ConfigTreeImageGenerator {
    public static void main(String[] args) throws IOException {
        ConfigTreeImageGenerator.createImage(ConfigTreeImageGenerator.processHierarchy(), new File("/tmp/grt.png"));
    }

    public static void createImage(DefaultMutableTreeNode root, File imageFile) throws IOException {
        System.setProperty("java.awt.headless", "true");
        JPanel container = new JPanel();
        JTree tree = new JTree(root);
        tree.setCellRenderer(new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                AbstractBaseTarget abt;
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
                AbstractBaseTarget abstractBaseTarget = abt = tn.getUserObject() instanceof AbstractBaseTarget ? (AbstractBaseTarget)tn.getUserObject() : null;
                if (abt == null) {
                    return new JLabel("unknown entity");
                }
                Icon icon = OPlan.getInstance().getOPlanIntgFactory().getSystemInstance2UI().getIcon(abt);
                String prefix = OPlan.getInstance().getOPlanIntgFactory().getSystemInstance2UI().getDisplayString(abt);
                prefix = prefix == null ? abt.getClass().getSimpleName() : prefix;
                String str = abt instanceof OracleHome ? ((OracleHome)abt).getDescription() + ": " + ((OracleHome)abt).getPath() : abt.getDisplayName();
                str = "<html><font size='3'>" + str + "</font>  " + "<font size='2' color='gray'>(" + prefix + ")</font></html>";
                if (icon != null) {
                    return new JLabel(str, icon, 2);
                }
                return new JLabel(str);
            }
        });
        for (int i = 1; i <= tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        JScrollPane sp = new JScrollPane(tree);
        container.add((Component)sp, "Center");
        JTree comp = tree;
        container.setSize(comp.getWidth(), comp.getHeight());
        comp.setBackground(new Color(249, 251, 252));
        int h = comp.getPreferredSize().height;
        int w = comp.getPreferredSize().width;
        comp.setSize(w, h);
        sp.setSize(w, h);
        container.setSize(w, h);
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics g = image.getGraphics();
        comp.paint(g);
        g.dispose();
        imageFile.delete();
        ImageIO.write((RenderedImage)image, "PNG", imageFile);
    }

    private static DefaultMutableTreeNode processHierarchy() {
        Object[] hierarchy = new Object[]{"javax.swing", "javax.swing.border", "javax.swing.colorchooser", "javax.swing.event", "javax.swing.filechooser", new Object[]{"javax.swing.plaf", "javax.swing.plaf.basic", "javax.swing.plaf.metal", "javax.swing.plaf.multi"}, "javax.swing.table", new Object[]{"javax.swing.text", new Object[]{"javax.swing.text.html", new Object[]{"javax.swing.text.html", new Object[]{"javax.swing.text.html", new Object[]{"javax.swing.text.html", "javax.swing.text.html.parser"}, "javax.swing.text.html.parser"}, "javax.swing.text.html.parser"}, "javax.swing.text.html.parser"}, "javax.swing.text.rtf"}, "javax.swing.tree", "javax.swing.undo"};
        return ConfigTreeImageGenerator.processHierarchy(hierarchy);
    }

    private static DefaultMutableTreeNode processHierarchy(Object[] hierarchy) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(hierarchy[0]);
        for (int i = 1; i < hierarchy.length; ++i) {
            Object nodeSpecifier = hierarchy[i];
            DefaultMutableTreeNode child = nodeSpecifier instanceof Object[] ? ConfigTreeImageGenerator.processHierarchy((Object[])nodeSpecifier) : new DefaultMutableTreeNode(nodeSpecifier);
            node.add(child);
        }
        return node;
    }
}

