/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.artifact;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.system.automation.jaxb.ArtifactType;
import oracle.oplan.sdk.artifact.ArtifactException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artifact {
    Logger logger = Logger.getLogger(Artifact.class.getName());
    protected Map<String, String> parameterList = new HashMap<String, String>();
    protected ArtifactType artifactType;
    protected String artifactTag;
    protected String name;
    protected static final Pattern PATTERN = Pattern.compile("%(\\w+)%");

    protected Artifact() {
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public String getArtifactTag() {
        return this.artifactTag;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParameters() {
        return this.parameterList;
    }

    public String getValueFromKey(String key) {
        return this.parameterList.get(key);
    }

    public void getVars(Map<String, String> varMaps) {
        for (String var : this.parameterList.keySet()) {
            StringBuffer sb = new StringBuffer();
            Matcher m = PATTERN.matcher(this.parameterList.get(var));
            if (!m.find()) continue;
            m.reset();
            while (m.find()) {
                if (!varMaps.containsKey(m.group(1))) {
                    this.logger.severe("the artifact variable " + m.group(1) + " doesn't define in the automation xml");
                    throw new ArtifactException("the artifact variable " + m.group(1) + " doesn't define in the automation xml");
                }
                m.appendReplacement(sb, varMaps.get(m.group(1)));
            }
            m.appendTail(sb);
            this.parameterList.put(var, sb.toString());
        }
    }
}

