/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.Command;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleDosCommand;
import oracle.oplan.sdk.oplan.VariableResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDosCommand
extends SimpleDosCommand {
    private Logger logger = Logger.getLogger(GenericDosCommand.class.getName());
    List<Command> automationCommands;

    public GenericDosCommand(CommandAction commandAction) {
        super((ActionType)commandAction);
        this.automationCommands = commandAction.getCommand();
    }

    public GenericDosCommand(ActionType automationAction, List<Command> automationCommands) {
        super(automationAction);
        this.automationCommands = automationCommands;
    }

    @Override
    public List<String> getDosCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        for (Command c : this.automationCommands) {
            String cmd = this.getCmdString(c);
            cmds.add(this.replaceParams(cmd, context));
        }
        return cmds;
    }

    String replaceParams(String cmd, CommandContext context) {
        cmd = VariableResolver.replaceContextProperties(cmd, context);
        return cmd;
    }

    String getCmdString(Command c) {
        StringBuilder str = new StringBuilder();
        for (Command.EnvVar e : c.getEnvVar()) {
            str.append("set " + e.getName() + "=" + e.getValue() + "\n ");
        }
        if (c.getCurrentWorkingDir() != null) {
            str.append("cd " + c.getCurrentWorkingDir() + "; ");
        }
        str.append(this.getSource(c));
        for (String arg : c.getParameter()) {
            str.append(" ").append(arg.trim());
        }
        return str.toString();
    }

    protected String getSource(Command c) {
        return c.getSource().getValue().trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<GenericDosCommand> {
        @Override
        public GenericDosCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || a.getType() == null || !a.getType().equals("dos")) {
                return null;
            }
            GenericDosCommand gsc = new GenericDosCommand((CommandAction)a);
            return gsc;
        }
    }
}

