/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.oplan;

import java.util.logging.Level;
import java.util.logging.Logger;
import model.BaseClass;
import model.common.AbstractBaseTarget;
import oracle.oplan.sdk.oplan.OPlanInternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemModelUtils {
    static Logger logger = Logger.getLogger(SystemModelUtils.class.getName());

    public static Object getTargetProperty(BaseClass b, String propName) {
        logger.log(Level.INFO, "Base Class: " + b.getClass() + " PropertyName: " + propName + " Value: " + b.getAttributes().get(propName));
        return b.getAttributes().get(propName);
    }

    public static Class<? extends AbstractBaseTarget> getClassForType(String type) {
        String[] packages;
        for (String pack : packages = new String[]{"model.common", "model.sample", "model.db_crs", "model.idm", "model.exadata", "model.exalogic", "model.exalytics", "model.siebel"}) {
            try {
                return Class.forName(pack + "." + type).asSubclass(AbstractBaseTarget.class);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new OPlanInternalException("Could not find target model class of type " + type);
    }
}

