/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.patch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.patchmodel.EngineeredSystemPatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.PatchBundle;
import model.patchmodel.PatchPackage;
import oracle.osysmodel.patchsdk.PatchPackageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatchPackagesBag {
    private final Logger logger = Logger.getLogger(PatchPackagesBag.class.getName());
    Map<String, Map<String, String>> userPatchLocationMapForPatchID = new HashMap<String, Map<String, String>>();
    private final List<PatchPackage> bag = new ArrayList<PatchPackage>();
    private PatchPackage primaryPatchPackage;

    public void setPrimaryPatchPackage(PatchPackage primaryPatchPackage) {
        this.primaryPatchPackage = primaryPatchPackage;
    }

    public PatchPackage getPrimaryPatchPackage() {
        if (this.primaryPatchPackage != null) {
            return this.primaryPatchPackage;
        }
        List<EngineeredSystemPatch> esysPatches = this.getEngineeredSystemPatches();
        if (esysPatches != null && esysPatches.size() > 0) {
            return (PatchPackage)esysPatches.get(0);
        }
        List<PatchBundle> patchBundles = this.getBundlePatches();
        if (patchBundles != null && patchBundles.size() > 0) {
            return (PatchPackage)patchBundles.get(0);
        }
        List<GenericPatch> patches = this.getAllPatches();
        if (patches != null && patches.size() > 0) {
            return (PatchPackage)patches.get(0);
        }
        return null;
    }

    public List<PatchPackage> getBagContents() {
        return Collections.unmodifiableList(this.bag);
    }

    public final void add(PatchPackage p) throws PatchPackageException {
        try {
            this.logger.fine("Checking to add patch package: " + p + " to the bag.");
            if (this.shouldAddToBag(p)) {
                this.logger.fine("Check passes to add patch package: " + p + " to the bag. Adding...");
                this.bag.add(p);
            } else {
                this.logger.fine("Check did not pass hence not adding patch package: " + p + " to the bag. No exceptions where thrown.");
            }
        }
        catch (PatchPackageException e) {
            this.logger.log(Level.SEVERE, "Check did not pass hence not adding patch package: " + p + " to the bag. Exceptions is being thrown.", e);
            throw e;
        }
    }

    protected abstract boolean shouldAddToBag(PatchPackage var1) throws PatchPackageException;

    public List<GenericPatch> getPatchesForTargetType(String targetType) {
        assert (targetType != null);
        ArrayList<String> targetTypes = new ArrayList<String>();
        targetTypes.add(targetType);
        return this.getPatchesForTargetTypes(targetTypes);
    }

    public List<GenericPatch> getPatchesForTargetTypes(List<String> targetTypes) {
        assert (targetTypes.size() > 0);
        ArrayList<GenericPatch> res = new ArrayList<GenericPatch>();
        for (GenericPatch p : this.getAllPatches()) {
            for (String at : p.getApplicableTargets()) {
                if (!targetTypes.contains(at) || res.contains(p)) continue;
                res.add(p);
            }
        }
        return Collections.unmodifiableList(res);
    }

    public List<GenericPatch> getAllPatches() {
        ArrayList<GenericPatch> res = new ArrayList<GenericPatch>();
        for (PatchPackage pp : this.bag) {
            if (pp instanceof EngineeredSystemPatch) {
                this.logger.log(Level.FINE, "Found patch at location " + pp.getPatchLocation() + " which is instance of EngineeredSystemPatch");
                EngineeredSystemPatch esys = (EngineeredSystemPatch)pp;
                for (GenericPatch p : esys.getSubPatches()) {
                    res.add(p);
                }
                continue;
            }
            if (pp instanceof PatchBundle) {
                this.logger.log(Level.FINE, "Found patch at location " + pp.getPatchLocation() + " which is instance of PatchBundle");
                for (GenericPatch p : ((PatchBundle)pp).getSubPatches()) {
                    res.add(p);
                }
                continue;
            }
            this.logger.log(Level.FINE, "Found patch at location " + pp.getPatchLocation() + " which is instance of GenericSingletonPatch");
            GenericPatch p = (GenericPatch)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public List<GenericPatch> getGenericPatches() {
        ArrayList<GenericPatch> res = new ArrayList<GenericPatch>();
        for (PatchPackage pp : this.bag) {
            if (!(pp instanceof GenericPatch)) continue;
            GenericPatch p = (GenericPatch)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public List<PatchBundle> getBundlePatches() {
        ArrayList<PatchBundle> res = new ArrayList<PatchBundle>();
        for (PatchPackage pp : this.bag) {
            if (!(pp instanceof PatchBundle)) continue;
            PatchBundle p = (PatchBundle)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public List<EngineeredSystemPatch> getEngineeredSystemPatches() {
        ArrayList<EngineeredSystemPatch> res = new ArrayList<EngineeredSystemPatch>();
        for (PatchPackage pp : this.bag) {
            if (!(pp instanceof EngineeredSystemPatch)) continue;
            EngineeredSystemPatch p = (EngineeredSystemPatch)pp;
            res.add(p);
        }
        return Collections.unmodifiableList(res);
    }

    public String getPatchesListAsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PatchPackage patchPackage : this.getEngineeredSystemPatches()) {
            if (first) {
                first = false;
                sb.append(patchPackage.getPatchID());
                continue;
            }
            sb.append(", ");
            sb.append(patchPackage.getPatchID());
        }
        for (PatchPackage patchPackage : this.getBundlePatches()) {
            if (first) {
                first = false;
                sb.append(patchPackage.getPatchID());
                continue;
            }
            sb.append(", ");
            sb.append(patchPackage.getPatchID());
        }
        for (PatchPackage patchPackage : this.getGenericPatches()) {
            if (first) {
                first = false;
                sb.append(patchPackage.getPatchID());
                continue;
            }
            sb.append(", ");
            sb.append(patchPackage.getPatchID());
        }
        return sb.toString();
    }

    public void setUserPatchLocationMapForPatchID(Map<String, Map<String, String>> userPatchLocationMapForPatchID) {
        this.userPatchLocationMapForPatchID = userPatchLocationMapForPatchID;
    }

    public Map<String, Map<String, String>> getUserPatchLocationMapForPatchID() {
        return this.userPatchLocationMapForPatchID;
    }
}

