/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.oplan.PlatformUtils;

public class OPlanUtils {
    public static String getAutomationInfo(Automation auto) {
        return "Automation Properties: " + auto.getDeploymentType() + ", " + auto.getDeploymentSubType() + ", " + auto.getOperation() + ", " + auto.getStrategy();
    }

    public static String getExecutionPlanInfo(ExecutionPlan plan) {
        return OPlanUtils.getAutomationInfo(plan.getAutomation());
    }

    public static String getPlatformDependentPath(String s) {
        String tmp = "";
        if (s == null || s.equals("")) {
            return "";
        }
        s = s.replace('\\', '/');
        String[] splittedStr = s.split("/");
        String separator = File.separator;
        if (splittedStr == null) {
            throw new RuntimeException("Internal Error: OPlanUtils::getPlatformDependentPath(): Input String is invalid");
        }
        for (int i = 0; i < splittedStr.length; ++i) {
            if (splittedStr[i].equals(".")) continue;
            if (i == splittedStr.length - 1) {
                separator = "";
            }
            tmp = tmp + splittedStr[i] + separator;
        }
        return tmp;
    }

    @Deprecated
    public static void chmodTo777(File file) {
        Logger logger = Logger.getLogger(IOUtils.class.getName());
        try {
            if (!PlatformUtils.isWindows()) {
                logger.config("Change the permission of the file " + file.getAbsolutePath() + "to 777");
                ProcessBuilder chmod = new ProcessBuilder(new String[0]);
                chmod.command("chmod", "777", file.getAbsolutePath());
                Process ch = chmod.start();
                int chmod_failed = ch.waitFor();
                if (chmod_failed != 0) {
                    throw new OPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
                }
            }
        }
        catch (InterruptedException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }

    public static void chmodTo775(File file) {
        Logger logger = Logger.getLogger(IOUtils.class.getName());
        try {
            if (!PlatformUtils.isWindows()) {
                logger.config("Change the permission of the file " + file.getAbsolutePath() + "to 775");
                ProcessBuilder chmod = new ProcessBuilder(new String[0]);
                chmod.command("chmod", "775", file.getAbsolutePath());
                Process ch = chmod.start();
                int chmod_failed = ch.waitFor();
                if (chmod_failed != 0) {
                    throw new OPlanUserException("UNABLE_TO_CHANGE_FILE_PERMISSION", file.getAbsolutePath());
                }
            }
        }
        catch (InterruptedException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }
}

