/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.dsig.Referable;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSManifest;
import oracle.security.xmlsec.dsig.XSObject;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSigProperties;
import oracle.security.xmlsec.dsig.XSSigProperty;
import oracle.security.xmlsec.dsig.XSSignatureValue;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSSignature
extends XMLElement
implements Referable {
    private StringBuilder validationErrorMessage = new StringBuilder();
    private StringBuilder signatureDetails = new StringBuilder();
    private ArrayList<byte[]> preDigestedData;
    private byte[] siBytes;
    private static Method jsr105sign;
    private static Method jsr105verify;

    public static XSSignature newInstance(String id) throws ParserConfigurationException {
        XSSignature sig = new XSSignature(XMLUtils.createDocument(), id);
        sig.getOwnerDocument().appendChild(sig.node);
        return sig;
    }

    public static XSSignature newInstance(Document owner, String id) {
        return new XSSignature(owner, id);
    }

    public XSSignature(Element element) {
        super(element);
    }

    public XSSignature(Element element, String systemId) {
        super(element, systemId);
    }

    XSSignature(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        this.addNSPrefixAttrDefault("http://www.w3.org/2000/09/xmldsig#");
    }

    XSSignature(Document owner, String id) {
        this(owner);
        if (id != null) {
            this.setId(id);
        }
    }

    public XSSignedInfo createSignedInfo() throws DOMException {
        XSSignedInfo si = new XSSignedInfo(this.getOwnerDocument());
        si.setSystemId(this.systemId);
        return si;
    }

    public XSSignedInfo createSignedInfo(String c14nMethod, String signatureMethod, String id) throws DOMException {
        XSSignedInfo si = new XSSignedInfo(this.getOwnerDocument(), c14nMethod, signatureMethod, id);
        si.setSystemId(this.systemId);
        return si;
    }

    public XSSignatureValue createSignatureValue() throws DOMException {
        XSSignatureValue sv = new XSSignatureValue(this.getOwnerDocument());
        sv.setSystemId(this.systemId);
        return sv;
    }

    public XSSignatureValue createSignatureValue(byte[] sigBytes, String id) throws DOMException {
        XSSignatureValue sv = new XSSignatureValue(this.getOwnerDocument(), sigBytes, id);
        sv.setSystemId(this.systemId);
        return sv;
    }

    public XSKeyInfo createKeyInfo() throws DOMException {
        XSKeyInfo ki = new XSKeyInfo(this.getOwnerDocument());
        ki.setSystemId(this.systemId);
        return ki;
    }

    public XSKeyInfo createKeyInfo(String id) throws DOMException {
        XSKeyInfo ki = new XSKeyInfo(this.getOwnerDocument(), id);
        ki.setSystemId(this.systemId);
        return ki;
    }

    public XSObject createObject() throws DOMException {
        XSObject obj = new XSObject(this.getOwnerDocument());
        obj.setSystemId(this.systemId);
        return obj;
    }

    public XSObject createObject(String id, String mimeType, String encoding) throws DOMException {
        XSObject obj = new XSObject(this.getOwnerDocument(), id, mimeType, encoding);
        obj.setSystemId(this.systemId);
        return obj;
    }

    public XSManifest createManifest() throws DOMException {
        XSManifest m = new XSManifest(this.getOwnerDocument());
        m.setSystemId(this.systemId);
        return m;
    }

    public XSManifest createManifest(String id) throws DOMException {
        XSManifest m = new XSManifest(this.getOwnerDocument(), id);
        m.setSystemId(this.systemId);
        return m;
    }

    public XSSigProperties createSigProperties() throws DOMException {
        XSSigProperties sp = new XSSigProperties(this.getOwnerDocument());
        sp.setSystemId(this.systemId);
        return sp;
    }

    public XSSigProperties createSigProperties(String id) throws DOMException {
        XSSigProperties sp = new XSSigProperties(this.getOwnerDocument(), id);
        sp.setSystemId(this.systemId);
        return sp;
    }

    public XSSigProperty createSigProperty() throws DOMException {
        XSSigProperty sp = new XSSigProperty(this.getOwnerDocument());
        sp.setSystemId(this.systemId);
        return sp;
    }

    public XSSigProperty createSigProperty(String target, String id) throws DOMException {
        XSSigProperty sp = new XSSigProperty(this.getOwnerDocument(), target, id);
        sp.setSystemId(this.systemId);
        return sp;
    }

    public XSReference createReference() throws DOMException {
        XSReference r = new XSReference(this.getOwnerDocument());
        r.setSystemId(this.systemId);
        return r;
    }

    public XSReference createReference(String id, String uri, String type, String digestMethod) throws DOMException {
        XSReference r = new XSReference(this.getOwnerDocument(), id, uri, type);
        r.setDigestMethod(digestMethod);
        r.setSystemId(this.systemId);
        return r;
    }

    public XSAlgorithmIdentifier createAlgorithmIdentifier(String tagName, String algorithm) throws DOMException {
        XSAlgorithmIdentifier ai = new XSAlgorithmIdentifier(this.getOwnerDocument(), tagName, algorithm);
        ai.setSystemId(this.systemId);
        return ai;
    }

    public XSAlgorithmIdentifier createTransform(String algorithm) throws DOMException {
        return this.createAlgorithmIdentifier("Transform", algorithm);
    }

    public XSAlgorithmIdentifier createXPathTransform(String nsPrefix, String nsURI, String xPath) throws DOMException {
        XSAlgorithmIdentifier xp = this.createAlgorithmIdentifier("Transform", "http://www.w3.org/TR/1999/REC-xpath-19991116");
        xp.addParameter("http://www.w3.org/2000/09/xmldsig#", "XPath", xPath);
        Element param = (Element)xp.getParameters().item(0);
        XMLUtils.copyNSPrefix((Element)this.node, param);
        if (nsPrefix != null && nsURI != null) {
            XMLElement.addNSPrefixAttr(param, nsPrefix, nsURI);
        }
        return xp;
    }

    public XSAlgorithmIdentifier createXPathTransform(String xPath) throws DOMException {
        return this.createXPathTransform(XMLElement.getDefaultNSPrefix("http://www.w3.org/2000/09/xmldsig#"), "http://www.w3.org/2000/09/xmldsig#", xPath);
    }

    public void setSignedInfo(XSSignedInfo signedInfo) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        nList = this.getChildNodes();
        if (nList.getLength() != 0) {
            this.insertBefore(signedInfo, nList.item(0));
        } else {
            this.appendChild(signedInfo);
        }
    }

    public XSSignedInfo getSignedInfo() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        if (nList.getLength() != 0) {
            return new XSSignedInfo((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public void setSignatureValue(XSSignatureValue sigValue) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (nList.getLength() == 0) {
            nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object");
        }
        if (nList.getLength() != 0) {
            this.insertBefore(sigValue, nList.item(0));
        } else {
            this.appendChild(sigValue);
        }
    }

    public XSSignatureValue getSignatureValue() throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        if (nList.getLength() != 0) {
            return new XSSignatureValue((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public void setKeyInfo(XSKeyInfo keyInfo) throws DOMException {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object");
        if (nList.getLength() != 0) {
            this.insertBefore(keyInfo, nList.item(0));
        } else {
            this.appendChild(keyInfo);
        }
    }

    public XSKeyInfo getKeyInfo() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (nList.getLength() != 0) {
            return new XSKeyInfo((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public void addObject(XSObject obj) throws DOMException {
        this.appendChild(obj);
    }

    public Vector getObjects() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object");
        Vector<XSObject> list = new Vector<XSObject>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new XSObject((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    public byte[] canonicalizeSignedInfo() throws CanonicalizationException {
        boolean xmlDebugDigest = System.getProperty("xml.debug.digest") != null;
        XSSignedInfo si = this.getSignedInfo();
        if (si == null) {
            throw new CanonicalizationException("Missing SignedInfo element");
        }
        Canonicalizer can = null;
        try {
            XSAlgorithmIdentifier cm = si.getC14NMethod();
            if (cm == null) {
                throw new CanonicalizationException("Missing SignedInfo.CanonicalizationMethod element");
            }
            String c14nAlg = cm.getAlgorithm();
            if (c14nAlg == null) {
                throw new CanonicalizationException("Missing SignedInfo.CanonicalizationMethod.Algorithm attribute");
            }
            can = Canonicalizer.getInstance(cm);
        }
        catch (AlgorithmIdentifierException ex) {
            throw new CanonicalizationException(ex);
        }
        this.siBytes = can.canonicalize(si.getNode());
        if (xmlDebugDigest) {
            StringBuilder sigDetails = new StringBuilder();
            sigDetails.append("\n osdt_xmlsec: Canonicalized SignedInfo: length=" + this.siBytes.length + " bytes. Data:");
            if (XSReference.isAscii(this.siBytes)) {
                sigDetails.append("\n" + new String(this.siBytes));
            } else {
                sigDetails.append("\n" + Base64.toBase64(this.siBytes, true));
            }
            this.signatureDetails.append((CharSequence)sigDetails);
            System.err.println(sigDetails);
        }
        return this.siBytes;
    }

    public XSSignatureValue computeSignature(String sigValueId) throws TransformationException, SigningException {
        XSKeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            throw new SigningException("No dsig:KeyInfo found");
        }
        PrivateKey key = null;
        try {
            key = KeyRetriever.getPrivateKey(ki);
        }
        catch (KeyRetrievalException ex) {
            throw new SigningException(ex);
        }
        if (key == null) {
            throw new SigningException("Could not retrieve signing key");
        }
        return this.computeSignature(key, sigValueId);
    }

    public XSSignatureValue computeSignature(PrivateKey key, String sigValueId) throws TransformationException, SigningException {
        byte[] sigBytes;
        XSSignedInfo si = this.getSignedInfo();
        if (si == null) {
            throw new SigningException("Missing SignedInfo element");
        }
        byte[] siBytes = this.canonicalizeSignedInfo();
        String sigAlg = null;
        Signature sig = null;
        try {
            XSAlgorithmIdentifier sm = si.getSignatureMethod();
            if (sm == null) {
                throw new SigningException("Missing SignedInfo.SignatureMethod element");
            }
            sigAlg = sm.getAlgorithm();
            if (sigAlg == null) {
                throw new SigningException("Missing SignedInfo.SignatureMethod.Algorithm attribute");
            }
            String alg = URIManager.getURIManager().getJCEAlgorithm(sigAlg);
            if (alg == null) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm " + sigAlg);
            }
            sig = CryptoUtils.getSignatureInstance((String)alg, (Key)key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SigningException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new SigningException(ex);
        }
        try {
            sig.initSign(key);
            sig.update(siBytes);
            sigBytes = sig.sign();
        }
        catch (SignatureException ex) {
            throw new SigningException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SigningException(ex);
        }
        if (sigAlg.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            sigBytes = XSSignatureValue.fromDSA(sigBytes);
        } else if (sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
            ECPrivateKey ecKey = (ECPrivateKey)key;
            int fieldSize = ecKey.getParams().getCurve().getField().getFieldSize();
            sigBytes = XSSignatureValue.fromDSA(sigBytes, (fieldSize + 7) / 8);
        }
        XSSignatureValue sv = this.createSignatureValue(sigBytes, sigValueId);
        this.setSignatureValue(sv);
        return sv;
    }

    public XSSignatureValue computeSignature(byte[] secret, String sigValueId) throws TransformationException, SigningException {
        XSSignedInfo si = this.getSignedInfo();
        if (si == null) {
            throw new SigningException("Missing SignedInfo element");
        }
        byte[] siBytes = this.canonicalizeSignedInfo();
        Mac mac = null;
        XSAlgorithmIdentifier sm = this.getSignedInfo().getSignatureMethod();
        if (sm == null) {
            throw new SigningException("Missing SignedInfo.SignatureMethod element");
        }
        try {
            String macAlg = sm.getAlgorithm();
            if (macAlg == null) {
                throw new SigningException("Missing SignedInfo.SignatureMethod.Algorithm attribute");
            }
            String alg = URIManager.getURIManager().getJCEAlgorithm(macAlg);
            if (alg == null) {
                throw new NoSuchAlgorithmException("Unknown MAC algorithm " + macAlg);
            }
            mac = Mac.getInstance(alg);
            mac.init(new SecretKeySpec(secret, alg));
        }
        catch (InvalidKeyException ex) {
            throw new SigningException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SigningException(ex);
        }
        mac.update(siBytes);
        byte[] macBytes = mac.doFinal();
        NodeList nList = sm.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
        if (nList.getLength() != 0) {
            int len = -1;
            String lenString = XMLUtils.collectText(nList.item(0)).trim();
            if (lenString.length() != 0) {
                try {
                    len = Integer.parseInt(lenString);
                }
                catch (NumberFormatException ex) {
                    throw new SigningException("Invalid HMACOutputLength " + lenString);
                }
            }
            if (len != macBytes.length * 8) {
                throw new SigningException("Invalid HMACOutputLength " + lenString);
            }
        }
        XSSignatureValue sv = this.createSignatureValue(macBytes, sigValueId);
        this.setSignatureValue(sv);
        return sv;
    }

    public XSSignatureValue sign(String sigValueId) throws TransformationException, SigningException {
        XSKeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            throw new SigningException("No dsig:KeyInfo found");
        }
        PrivateKey key = null;
        try {
            key = KeyRetriever.getPrivateKey(ki);
        }
        catch (KeyRetrievalException ex) {
            throw new SigningException(ex);
        }
        if (key == null) {
            throw new SigningException("Could not retrieve signing key");
        }
        return this.sign(key, sigValueId);
    }

    public XSSignatureValue sign(PrivateKey key, String sigValueId) throws TransformationException, SigningException {
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            return this.signUsingJSR105(key, null, sigValueId);
        }
        XSSignedInfo si = this.getSignedInfo();
        if (si == null) {
            throw new SigningException("Missing SignedInfo element");
        }
        try {
            si.computeRefDigests();
            this.signatureDetails.append((CharSequence)si.getSignatureDetails());
            this.preDigestedData = si.getPreDigestedData();
        }
        catch (ReferenceException ex) {
            throw new SigningException(ex);
        }
        return this.computeSignature(key, sigValueId);
    }

    public XSSignatureValue sign(byte[] secret, String sigValueId) throws TransformationException, SigningException {
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            return this.signUsingJSR105(null, secret, sigValueId);
        }
        XSSignedInfo si = this.getSignedInfo();
        if (si == null) {
            throw new SigningException("Missing SignedInfo element");
        }
        try {
            si.computeRefDigests();
            this.signatureDetails.append((CharSequence)si.getSignatureDetails());
            this.preDigestedData = si.getPreDigestedData();
        }
        catch (ReferenceException ex) {
            throw new SigningException(ex);
        }
        return this.computeSignature(secret, sigValueId);
    }

    public boolean verifySignature() throws VerifyException {
        XSKeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            throw new VerifyException("No dsig:KeyInfo found");
        }
        try {
            PublicKey pubKey = KeyRetriever.getPublicKey(ki);
            if (pubKey != null) {
                return this.verifySignature(pubKey);
            }
            SecretKey symKey = KeyRetriever.getSymmetricKey(ki);
            if (symKey != null) {
                return this.verifySignature(symKey.getEncoded());
            }
        }
        catch (KeyRetrievalException ex) {
            throw new VerifyException(ex);
        }
        throw new VerifyException("Could not retrieve verification key");
    }

    public boolean verifySignature(PublicKey key) throws VerifyException {
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            return this.verifyUsingJSR105(key, null, false);
        }
        boolean xmlDebugVerify = System.getProperty("xml.debug.verify") != null;
        byte[] siBytes = null;
        try {
            siBytes = this.canonicalizeSignedInfo();
        }
        catch (CanonicalizationException ex) {
            throw new VerifyException(ex);
        }
        XSSignedInfo si = this.getSignedInfo();
        String sigAlg = null;
        Signature sig = null;
        try {
            XSAlgorithmIdentifier sm = si.getSignatureMethod();
            if (sm == null) {
                throw new VerifyException("Missing SignedInfo.SignatureMethod element");
            }
            sigAlg = sm.getAlgorithm();
            if (sigAlg == null) {
                throw new VerifyException("Missing SignedInfo.SignatureMethod.Algorithm attribute");
            }
            String alg = URIManager.getURIManager().getJCEAlgorithm(sigAlg);
            if (alg == null) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm " + sigAlg);
            }
            sig = CryptoUtils.getSignatureInstance((String)alg, (Key)key);
            sig.initVerify(key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new VerifyException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new VerifyException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new VerifyException(ex);
        }
        byte[] sigBytes = this.getSignatureValue().getSignatureBytes();
        if (sigAlg.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || sigAlg.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
            sigBytes = XSSignatureValue.toDSA(sigBytes);
        }
        try {
            sig.update(siBytes);
            boolean verifyResult = sig.verify(sigBytes);
            if (!verifyResult && xmlDebugVerify) {
                StringBuilder validationError = new StringBuilder();
                validationError.append("\n osdt_xmlsec: Signature validation failed.");
                validationError.append("\n osdt_xmlsec: Canonicalized Signature: length=" + (siBytes == null ? 0 : siBytes.length) + " bytes. Data:");
                validationError.append("\n " + new String(siBytes));
                validationError.append("\n osdt_xmlsec: Signature value in the signature = " + (sigBytes == null ? null : Base64.toBase64(sigBytes, false)));
                this.validationErrorMessage.append((CharSequence)validationError);
                System.err.println(validationError);
            }
            return verifyResult;
        }
        catch (SignatureException ex) {
            throw new VerifyException(ex);
        }
    }

    public boolean verify() throws VerifyException {
        return this.verify(false);
    }

    public boolean verify(boolean validateManifests) throws VerifyException {
        XSKeyInfo ki = this.getKeyInfo();
        if (ki == null) {
            throw new VerifyException("No dsig:KeyInfo found");
        }
        try {
            PublicKey pubKey = KeyRetriever.getPublicKey(ki);
            if (pubKey != null) {
                return this.verify(pubKey, validateManifests);
            }
            SecretKey symKey = KeyRetriever.getSymmetricKey(ki);
            if (symKey != null) {
                return this.verify(symKey.getEncoded(), validateManifests);
            }
        }
        catch (KeyRetrievalException ex) {
            throw new VerifyException(ex);
        }
        throw new VerifyException("Could not retrieve verification key");
    }

    public boolean verify(PublicKey key) throws VerifyException {
        return this.verify(key, false);
    }

    public boolean verify(PublicKey key, boolean validateManifests) throws VerifyException {
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            return this.verifyUsingJSR105(key, null, validateManifests);
        }
        XSSignedInfo signedInfo = this.getSignedInfo();
        if (signedInfo == null) {
            throw new VerifyException("Missing SignedInfo in XML-DSIG Signature");
        }
        boolean res = false;
        res = this.verifySignature(key);
        if (res) {
            try {
                boolean result = signedInfo.validateRefDigests(validateManifests);
                this.signatureDetails.append((CharSequence)signedInfo.getSignatureDetails());
                this.preDigestedData = signedInfo.getPreDigestedData();
                if (!result) {
                    this.validationErrorMessage.append((CharSequence)signedInfo.getValidationErrorMessage());
                    return false;
                }
            }
            catch (ReferenceException ex) {
                throw new VerifyException(ex);
            }
        }
        return res;
    }

    public boolean verifySignature(byte[] secret) throws VerifyException {
        boolean verifyResult;
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            return this.verifyUsingJSR105(null, secret, false);
        }
        boolean xmlDebugVerify = System.getProperty("xml.debug.verify") != null;
        byte[] siBytes = null;
        try {
            siBytes = this.canonicalizeSignedInfo();
        }
        catch (CanonicalizationException ex) {
            throw new VerifyException(ex);
        }
        XSSignedInfo si = this.getSignedInfo();
        Mac mac = null;
        XSAlgorithmIdentifier sm = null;
        try {
            sm = si.getSignatureMethod();
            if (sm == null) {
                throw new VerifyException("Missing SignedInfo.SignatureMethod element");
            }
            String macAlg = sm.getAlgorithm();
            if (macAlg == null) {
                throw new VerifyException("Missing SignedInfo.SignatureMethod.Algorithm attribute");
            }
            String alg = URIManager.getURIManager().getJCEAlgorithm(macAlg);
            if (alg == null) {
                throw new NoSuchAlgorithmException("Unknown MAC algorithm " + macAlg);
            }
            mac = Mac.getInstance(alg);
            mac.init(new SecretKeySpec(secret, alg));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new VerifyException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new VerifyException(ex);
        }
        mac.update(siBytes);
        byte[] macBytes = mac.doFinal();
        NodeList nList = sm.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
        if (nList.getLength() != 0) {
            int len = -1;
            String lenString = XMLUtils.collectText(nList.item(0)).trim();
            if (lenString.length() != 0) {
                try {
                    len = Integer.parseInt(lenString);
                }
                catch (NumberFormatException ex) {
                    throw new VerifyException("Invalid HMACOutputLength " + lenString);
                }
            }
            if (len != macBytes.length * 8) {
                throw new VerifyException("Invalid HMACOutputLength " + lenString);
            }
        }
        if (!(verifyResult = Utils.areEqual((byte[])macBytes, (byte[])this.getSignatureValue().getSignatureBytes())) && xmlDebugVerify) {
            StringBuilder validationError = new StringBuilder();
            validationError.append("\n osdt_xmlsec: Signature validation failed.");
            validationError.append("\n osdt_xmlsec: Canonicalized Signature: length=" + (siBytes == null ? 0 : siBytes.length) + " bytes. Data:");
            validationError.append("\n" + new String(siBytes));
            String macBytesBase64 = macBytes == null ? null : Base64.toBase64(macBytes, false);
            validationError.append("\n osdt_xmlsec: Computed HMAC value = " + macBytesBase64);
            String sigValueBase64 = this.getSignatureValue() == null || this.getSignatureValue().getSignatureBytes() == null ? null : Base64.toBase64(this.getSignatureValue().getSignatureBytes(), false);
            validationError.append("\n osdt_xmlsec: HMAC value in the signature = " + sigValueBase64);
            this.validationErrorMessage.append((CharSequence)validationError);
            System.err.println(validationError);
        }
        return verifyResult;
    }

    public boolean verify(byte[] secret) throws VerifyException {
        return this.verify(secret, false);
    }

    public boolean verify(byte[] secret, boolean validateManifests) throws VerifyException {
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            return this.verifyUsingJSR105(null, secret, validateManifests);
        }
        XSSignedInfo signedInfo = this.getSignedInfo();
        if (signedInfo == null) {
            throw new VerifyException("Missing SignedInfo in XML-DSIG Signature");
        }
        boolean res = this.verifySignature(secret);
        if (res) {
            try {
                boolean result = signedInfo.validateRefDigests(validateManifests);
                this.signatureDetails.append((CharSequence)signedInfo.getSignatureDetails());
                this.preDigestedData = signedInfo.getPreDigestedData();
                if (!result) {
                    this.validationErrorMessage.append((CharSequence)signedInfo.getValidationErrorMessage());
                    return false;
                }
            }
            catch (ReferenceException ex) {
                throw new VerifyException(ex);
            }
        }
        return res;
    }

    @Override
    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    @Override
    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    public ArrayList<byte[]> getPreDigestedData() {
        return this.preDigestedData;
    }

    public byte[] getSignedInfoData() {
        return this.siBytes;
    }

    public final XSSignatureValue signUsingJSR105(PrivateKey key, byte[] secret, String sigValueId) throws SigningException {
        try {
            Element newSig = (Element)jsr105sign.invoke(null, this, key, secret);
            this.node = newSig;
            XSSignatureValue sigValue = this.getSignatureValue();
            if (sigValueId != null) {
                sigValue.setId(sigValueId);
            }
            return sigValue;
        }
        catch (InvocationTargetException ex) {
            throw new SigningException(ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new SigningException(ex);
        }
    }

    public final boolean verifyUsingJSR105(PublicKey key, byte[] secret, boolean validateManifests) throws VerifyException {
        try {
            Boolean result = (Boolean)jsr105verify.invoke(null, this, key, secret, new Boolean(validateManifests));
            return result;
        }
        catch (InvocationTargetException ex) {
            throw new VerifyException(ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new VerifyException(ex);
        }
    }

    public StringBuilder getValidationErrorMessage() {
        return this.validationErrorMessage;
    }

    public StringBuilder getSignatureDetails() {
        return this.signatureDetails;
    }

    static {
        boolean USE_JSR105;
        boolean bl = USE_JSR105 = System.getProperty("osdt.useJSR105") != null;
        if (USE_JSR105) {
            try {
                Class<?> jsr105Util = Class.forName("oracle.security.xmlsec.dsig.JSR105Util");
                jsr105sign = jsr105Util.getMethod("signUsingJSR105", XSSignature.class, PrivateKey.class, byte[].class);
                jsr105verify = jsr105Util.getMethod("verifyUsingJSR105", XSSignature.class, PublicKey.class, byte[].class, Boolean.TYPE);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

