/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.pii;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.xmlsec.keys.KeyUtils;
import oracle.security.xmlsec.util.Base64;

public class PIISecurity {
    private static Pattern p = Pattern.compile("[^a-zA-Z0-9+/=]");

    public static String encrypt(String plaintext, char[] password, String pbkdfAlgo, String pbkdfSalt, int pbkdfIteration, int keySize, String encAlg) {
        if (!"PBKDF2".equals(pbkdfAlgo)) {
            throw new IllegalArgumentException("Unsupported key derivation function : " + pbkdfAlgo);
        }
        SecretKey key = KeyUtils.generatePBKDF2BasedKey(password, pbkdfSalt, pbkdfIteration, keySize);
        return PIISecurity.encrypt(plaintext, key, encAlg);
    }

    public static String encrypt(String plaintext, SecretKey key, String encAlg) {
        if (plaintext == null || plaintext.isEmpty()) {
            throw new IllegalArgumentException("text to encrypt can not be null or empty");
        }
        if (encAlg == null || encAlg.isEmpty()) {
            throw new IllegalArgumentException("Encryption algorithm can not be null or empty");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key can not be null");
        }
        try {
            String alg = encAlg;
            int i = encAlg.indexOf(47);
            if (i > -1) {
                alg = encAlg.substring(0, i);
            }
            byte[] plainData = plaintext.getBytes("UTF-8");
            byte[] iv = new byte[16];
            SecureRandom scr = new SecureRandom();
            scr.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(encAlg);
            cipher.init(1, (Key)new SecretKeySpec(key.getEncoded(), alg), new IvParameterSpec(iv));
            byte[] ciphertext = cipher.doFinal(plainData);
            byte[] cipherData2 = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, cipherData2, 0, iv.length);
            System.arraycopy(ciphertext, 0, cipherData2, iv.length, ciphertext.length);
            return Base64.toBase64(cipherData2, false);
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (NoSuchAlgorithmException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (NoSuchPaddingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (InvalidKeyException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (InvalidAlgorithmParameterException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (IllegalBlockSizeException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (BadPaddingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
    }

    public static String decrypt(String ciphertext, char[] password, String pbkdfAlgo, String pbkdfSalt, int pbkdfIteration, int keySize, String encAlg) {
        if (!"PBKDF2".equals(pbkdfAlgo)) {
            throw new IllegalArgumentException("Unsupported key derivation function : " + pbkdfAlgo);
        }
        SecretKey key = KeyUtils.generatePBKDF2BasedKey(password, pbkdfSalt, pbkdfIteration, keySize);
        return PIISecurity.decrypt(ciphertext, key, encAlg);
    }

    public static String decrypt(String ciphertext, SecretKey key, String encAlg) {
        if (ciphertext == null || ciphertext.isEmpty()) {
            throw new IllegalArgumentException("text to decrypt can not be null or empty");
        }
        if (key == null) {
            throw new IllegalArgumentException("key can not be null.");
        }
        if (encAlg == null || encAlg.isEmpty()) {
            throw new IllegalArgumentException("Encryption algorithm can not be null or empty");
        }
        try {
            String alg = encAlg;
            int i = encAlg.indexOf(47);
            if (i > -1) {
                alg = encAlg.substring(0, i);
            }
            Matcher m = p.matcher(ciphertext);
            int start = -1;
            int end = -1;
            boolean found = m.find();
            if (found) {
                start = m.start();
                found = m.find();
                if (found) {
                    end = m.start();
                }
            }
            if (start != -1 && end != -1) {
                ciphertext = ciphertext.substring(start + 1, end);
            }
            byte[] cipherData = Base64.fromBase64(ciphertext);
            Cipher cipher = Cipher.getInstance(encAlg);
            cipher.init(2, (Key)new SecretKeySpec(key.getEncoded(), alg), new IvParameterSpec(cipherData, 0, 16));
            byte[] clearBytes = cipher.doFinal(cipherData, 16, cipherData.length - 16);
            return new String(clearBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (NoSuchAlgorithmException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (NoSuchPaddingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (InvalidKeyException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (InvalidAlgorithmParameterException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (IllegalBlockSizeException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (BadPaddingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
    }
}

