/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.soap.v11;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.util.SOAPInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPFault
extends XMLElement {
    public static final String VersionMismatch = "VersionMismatch";
    public static final String MustUnderstand = "MustUnderstand";
    public static final String Client = "Client";
    public static final String Server = "Server";
    private static final String[] nsURIs = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/", "http://schemas.xmlsoap.org/soap/envelope/"};
    private static final String[] localNames = new String[]{"faultcode", "faultstring", "faultactor", "detail"};

    public SOAPFault(Document owner) throws DOMException {
        super(owner, "http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    }

    public SOAPFault(Element soapFault) throws DOMException {
        super(soapFault);
    }

    public SOAPFault(Element soapFault, String systemId) throws DOMException {
        super(soapFault, systemId);
    }

    public void setFaultCode(String localPart) throws DOMException {
        this.setFaultCode(localPart, null);
    }

    public void setFaultCode(String localPart, String prefix) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "*", "faultcode");
        Element fc = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultcode");
        XMLUtils.insertChild((Element)this.node, fc, nsURIs, localNames);
        if (prefix == null) {
            prefix = this.getPrefix();
        }
        String qname = prefix != null && prefix.length() != 0 ? prefix + ":" + localPart : localPart;
        fc.appendChild(doc.createTextNode(qname));
    }

    public void setFaultCode(String localPart, String prefix, String NS) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "*", "faultcode");
        Element fc = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultcode");
        XMLElement.addNSPrefixAttr(fc, prefix, NS);
        XMLUtils.insertChild((Element)this.node, fc, nsURIs, localNames);
        if (prefix == null) {
            prefix = this.getPrefix();
        }
        String qname = prefix != null && prefix.length() != 0 ? prefix + ":" + localPart : localPart;
        fc.appendChild(doc.createTextNode(qname));
    }

    public String getFaultCode() {
        NodeList nodes = this.getChildElementsByTagNameNS("*", "faultcode");
        if (nodes.getLength() != 0) {
            return XMLUtils.collectText(nodes.item(0));
        }
        return null;
    }

    public void setFaultString(String faultString) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "*", "faultstring");
        Element fs = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultstring");
        XMLUtils.insertChild((Element)this.node, fs, nsURIs, localNames);
        fs.appendChild(doc.createTextNode(faultString));
    }

    public String getFaultString() {
        NodeList nodes = this.getChildElementsByTagNameNS("*", "faultstring");
        if (nodes.getLength() != 0) {
            return XMLUtils.collectText(nodes.item(0));
        }
        return null;
    }

    public void setFaultActor(String actorURI) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "*", "faultactor");
        Element fa = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultactor");
        XMLUtils.insertChild((Element)this.node, fa, nsURIs, localNames);
        fa.appendChild(doc.createTextNode(actorURI));
    }

    public String getFaultActor() {
        NodeList nodes = this.getChildElementsByTagNameNS("*", "faultactor");
        if (nodes.getLength() != 0) {
            return XMLUtils.collectText(nodes.item(0));
        }
        return null;
    }

    public void addDetailEntry(Element detailEntry) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element detail = null;
        NodeList list = this.getChildElementsByTagNameNS("*", "detail");
        if (list.getLength() != 0) {
            detail = (Element)list.item(0);
        } else {
            detail = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "detail");
            XMLUtils.insertChild((Element)this.node, detail, nsURIs, localNames);
        }
        detail.appendChild(detailEntry);
    }

    public Element getDetail() {
        NodeList nodes = this.getChildElementsByTagNameNS("*", "detail");
        if (nodes.getLength() != 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public List getDetailElements() {
        ArrayList<Node> dt = new ArrayList<Node>();
        Element detail = this.getDetail();
        if (detail != null) {
            NodeList list = XMLElement.getChildElementsByTagName(detail, "*");
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                dt.add(list.item(i));
            }
        }
        return dt;
    }

    static {
        SOAPInitializer.initialize();
    }
}

