/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class NodeReaderForSubtree
extends NodeReader {
    private Node subTree;
    private HashMap subTreeAncestorNamespaces = new HashMap();
    private Node currentNode;
    private int eventType;
    private boolean eof = false;
    private NamedNodeMap subTreeAttributes;
    private static StreamingC14NImpl.AttrComparator aComparator = new StreamingC14NImpl.AttrComparator();
    private char[] text;
    private AttributeIterator iter = new AttributeIterator();
    private static Object DUMMY = new Object();

    public NodeReaderForSubtree(Node subTree) {
        this.subTree = subTree;
        this.populateAncestorNamespaces();
        this.subTreeAttributes = new SimpleNamedNodeMap(subTree.getAttributes());
        for (Attr attr : this.subTreeAncestorNamespaces.values()) {
            ((SimpleNamedNodeMap)this.subTreeAttributes).add(attr);
        }
        this.currentNode = subTree;
        this.setEventType();
    }

    private final void populateAncestorNamespaces() {
        if (this.subTree.getNodeType() == 9) {
            return;
        }
        Element r = (Element)this.subTree;
        while (r.getParentNode() != null && r.getParentNode() != r.getOwnerDocument()) {
            r = (Element)r.getParentNode();
            NamedNodeMap attribs = r.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Attr attr = (Attr)attribs.item(i);
                String attrName = attr.getNodeName();
                String prefix = NodeReaderForSubtree.getPrefix(attrName);
                if (prefix == null || this.subTreeAncestorNamespaces.get(prefix) != null) continue;
                this.subTreeAncestorNamespaces.put(prefix, attr);
            }
        }
    }

    private final void setEventType() {
        if (this.currentNode.getNodeType() == 1) {
            this.eventType = 1;
        } else if (this.currentNode.getNodeType() == 8) {
            this.eventType = 5;
        } else if (this.currentNode.getNodeType() == 7) {
            this.eventType = 3;
        } else if (this.currentNode.getNodeType() == 3) {
            this.eventType = 4;
        } else if (this.currentNode.getNodeType() == 4) {
            this.eventType = 4;
        } else if (this.currentNode.getNodeType() == 10) {
            this.eventType = 11;
        } else if (this.currentNode.getNodeType() == 9) {
            this.eventType = 7;
        }
    }

    @Override
    public final int next() {
        this.text = null;
        if (this.eof) {
            this.eventType = -1;
            return -1;
        }
        if (this.eventType == 7 || this.eventType == 1) {
            Node newNode = this.currentNode.getFirstChild();
            if (newNode == null) {
                this.eventType = this.eventType == 7 ? 8 : 2;
                return this.eventType;
            }
            this.currentNode = newNode;
            this.setEventType();
            return this.eventType;
        }
        if (this.eventType == 8) {
            this.eof = true;
            this.currentNode = null;
            return -1;
        }
        if (this.eventType == 2 && this.currentNode == this.subTree) {
            this.eof = true;
            this.currentNode = null;
            return -1;
        }
        Node newNode = this.currentNode.getNextSibling();
        if (newNode == null) {
            this.currentNode = this.currentNode.getParentNode();
            this.eventType = this.currentNode.getNodeType() == 9 ? 8 : 2;
            return this.eventType;
        }
        this.currentNode = newNode;
        this.setEventType();
        return this.eventType;
    }

    @Override
    public final int getEventType() {
        return this.eventType;
    }

    private static final String getPrefix(String attrName) {
        if (attrName.equals("xmlns")) {
            return "";
        }
        if (attrName.startsWith("xmlns:")) {
            return attrName.substring(6);
        }
        return null;
    }

    @Override
    public final String getLocalName() {
        Element elem = (Element)this.currentNode;
        String localName = elem.getLocalName();
        if (localName == null) {
            localName = elem.getNodeName();
            localName = this.parseLocalName(localName);
        }
        return localName;
    }

    private String parseLocalName(String s) {
        if (s == null) {
            return s;
        }
        int i = s.length();
        String s1 = s.substring(s.indexOf(58) + 1, i);
        return s1.intern();
    }

    @Override
    public final String getNamespaceURI() {
        Element elem = (Element)this.currentNode;
        return elem.getNamespaceURI();
    }

    @Override
    public final String getPrefix() {
        Element elem = (Element)this.currentNode;
        return elem.getPrefix();
    }

    @Override
    public final String getPIData() {
        ProcessingInstruction pi = (ProcessingInstruction)this.currentNode;
        return pi.getData();
    }

    @Override
    public final String getPITarget() {
        ProcessingInstruction pi = (ProcessingInstruction)this.currentNode;
        return pi.getTarget();
    }

    @Override
    public final char[] getText() {
        if (this.text == null) {
            this.text = this.currentNode.getNodeValue().toCharArray();
        }
        return this.text;
    }

    @Override
    public final int getTextStart() {
        return 0;
    }

    @Override
    public final int getTextLength() {
        if (this.text == null) {
            this.text = this.currentNode.getNodeValue().toCharArray();
        }
        return this.text.length;
    }

    @Override
    public final boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.eventType == 8) {
            return false;
        }
        return this.eventType != 2 || this.currentNode != this.subTree;
    }

    @Override
    public final Node getNode() {
        return this.currentNode;
    }

    @Override
    public final Iterator getAttributes() {
        if (this.eventType == 1) {
            Element elem = (Element)this.currentNode;
            if (elem == this.subTree) {
                this.iter.init(this.subTreeAttributes);
            } else {
                this.iter.init(elem.getAttributes());
            }
            return this.iter;
        }
        return null;
    }

    @Override
    public boolean isElementAnOrphan() {
        return this.currentNode == this.subTree && this.subTree.getNodeType() != 9 && this.subTree != this.subTree.getOwnerDocument().getDocumentElement();
    }

    @Override
    public Collection getAncestorXmlAttributes(boolean c14n11) throws NodeReaderException {
        TreeMap<String, Attr> xmlAttribs = new TreeMap<String, Attr>();
        ArrayList<String> xmlBaseAttribs = null;
        boolean foundAncestorInNodeSet = false;
        if (this.currentNode.getNodeType() != 1) {
            return null;
        }
        Element r = (Element)this.currentNode;
        while (true) {
            NamedNodeMap attribs = r.getAttributes();
            int n = attribs.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attribs.item(i);
                String attrName = attr.getNodeName();
                if (!attrName.startsWith("xml:")) continue;
                if (c14n11) {
                    if (attrName.equals("xml:base")) {
                        if (foundAncestorInNodeSet) continue;
                        if (xmlBaseAttribs == null) {
                            xmlBaseAttribs = new ArrayList<String>();
                        }
                        xmlBaseAttribs.add(0, attr.getNodeValue());
                        continue;
                    }
                    if (!attrName.equals("xml:lang") && !attrName.equals("xml:space")) continue;
                }
                xmlAttribs.put(attr.getLocalName(), attr);
            }
            if (r.getParentNode() == null || r.getParentNode() == r.getOwnerDocument()) break;
            r = (Element)r.getParentNode();
        }
        if (xmlBaseAttribs != null && xmlBaseAttribs.size() > 0) {
            try {
                String fixedXmlBaseAttrib = XMLUtils.joinXmlBaseURI(xmlBaseAttribs);
                StreamingC14NImpl.AttrObj a = new StreamingC14NImpl.AttrObj("http://www.w3.org/XML/1998/namespace", "xml", "base", "xml:base", fixedXmlBaseAttrib);
                xmlAttribs.put("xml:base", a);
            }
            catch (URISyntaxException ex) {
                throw new NodeReaderException(ex);
            }
        }
        if (xmlAttribs.size() == 0) {
            return null;
        }
        return xmlAttribs.values();
    }

    @Override
    public Iterator getNamespacesForMissingAncestors() {
        if (this.currentNode == this.subTree) {
            return this.subTreeAncestorNamespaces.values().iterator();
        }
        return null;
    }

    private class AttributeIterator
    implements Iterator {
        int index = 0;
        int size;
        NamedNodeMap attribs;

        private AttributeIterator() {
        }

        void init(NamedNodeMap attribs) {
            this.attribs = attribs;
            this.index = 0;
            this.size = attribs.getLength();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        public Object next() {
            return this.attribs.item(this.index++);
        }

        @Override
        public void remove() {
        }
    }

    public class SimpleNamedNodeMap
    extends ArrayList
    implements NamedNodeMap {
        @Override
        public int getLength() {
            return this.size();
        }

        @Override
        public Node getNamedItem(String name) {
            return null;
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) {
            return null;
        }

        @Override
        public Node item(int index) {
            return (Node)this.get(index);
        }

        @Override
        public Node removeNamedItem(String name) throws DOMException {
            return null;
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            return null;
        }

        @Override
        public Node setNamedItem(Node arg) throws DOMException {
            return null;
        }

        @Override
        public Node setNamedItemNS(Node arg) throws DOMException {
            return null;
        }

        public SimpleNamedNodeMap(NamedNodeMap map) {
            if (map == null) {
                return;
            }
            int n = map.getLength();
            for (int i = 0; i < n; ++i) {
                Node nd = map.item(i);
                this.add(nd);
            }
        }
    }
}

