/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import oracle.security.xmlsec.util.XMLUtils;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class NodeSetReader
implements XMLReader {
    Collection nodes;
    boolean generateDummyRoot;
    ContentHandler ct;
    DTDHandler dt;
    ErrorHandler er;
    EntityResolver et;
    HashMap props = new HashMap();
    HashMap features = new HashMap();
    static final String ROOT_NS = "http://tempuri.org";
    static final String ROOT_NAME = "ROOT";
    private Element pendingElem = null;
    private AttributesImpl pendingAttrs = null;
    private ArrayList lastAncestors = new ArrayList();
    ArrayList ancestors = new ArrayList();

    public NodeSetReader(Collection nodes, boolean generateDummyRoot) {
        this.generateDummyRoot = generateDummyRoot;
        this.nodes = nodes;
    }

    private void checkPending() throws SAXException {
        if (this.pendingElem != null) {
            this.ct.startElement(this.pendingElem.getNamespaceURI(), this.pendingElem.getLocalName(), this.pendingElem.getNodeName(), this.pendingAttrs);
            this.lastAncestors.add(this.pendingElem);
            this.pendingElem = null;
            this.pendingAttrs = null;
        }
    }

    private void closeAncestors(Node node) throws SAXException {
        this.checkPending();
        if (node == null) {
            for (int i = this.lastAncestors.size() - 1; i >= 0; --i) {
                Element ancestor = (Element)this.lastAncestors.get(i);
                this.ct.endElement(ancestor.getNamespaceURI(), ancestor.getLocalName(), ancestor.getNodeName());
                this.lastAncestors.remove(i);
            }
            return;
        }
        XMLUtils.computeAncestors(node, this.ancestors);
        for (int i = this.lastAncestors.size() - 1; i >= 0; --i) {
            Element ancestor = (Element)this.lastAncestors.get(i);
            boolean found = false;
            for (int j = this.ancestors.size() - 2; j >= 0; --j) {
                if ((Element)this.ancestors.get(j) != ancestor) continue;
                found = true;
                break;
            }
            if (found) break;
            this.ct.endElement(ancestor.getNamespaceURI(), ancestor.getLocalName(), ancestor.getNodeName());
            this.lastAncestors.remove(i);
        }
    }

    public void parse() throws IOException, SAXException {
        this.ct.startDocument();
        if (this.generateDummyRoot) {
            this.ct.startElement(ROOT_NS, ROOT_NAME, ROOT_NAME, new AttributesImpl());
        }
        for (Node node : this.nodes) {
            switch (node.getNodeType()) {
                case 1: {
                    Element elem;
                    this.closeAncestors(node);
                    this.pendingElem = elem = (Element)node;
                    this.pendingAttrs = new AttributesImpl();
                    break;
                }
                case 2: {
                    Attr attr = (Attr)node;
                    this.pendingAttrs.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getName(), "CDATA", attr.getValue());
                    break;
                }
                case 13: {
                    NamespaceNode ns = (NamespaceNode)node;
                    this.pendingAttrs.addAttribute(null, ns.getLocalName(), ns.getNodeName().equals("") ? "xmlns:" : "xmlns:" + ns.getNodeName(), "CDATA", ns.getNodeValue());
                    break;
                }
                case 3: {
                    this.closeAncestors(node);
                    Text txt = (Text)node;
                    char[] chars = txt.getNodeValue().toCharArray();
                    this.ct.characters(chars, 0, chars.length);
                    break;
                }
                case 8: {
                    break;
                }
            }
        }
        this.closeAncestors(null);
        if (this.generateDummyRoot) {
            this.ct.endElement(ROOT_NS, ROOT_NAME, ROOT_NAME);
        }
        this.ct.endDocument();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.parse();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.ct;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.ct = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dt;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dt = handler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.et;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.et = resolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.er;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.er = handler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean feature = (Boolean)this.features.get(name);
        return feature == null ? false : feature;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.features.put(name, new Boolean(value));
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.props.get(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.props.put(name, value);
    }
}

