/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import oracle.security.xmlsec.util.GenericXMLElement;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QName {
    private final String localPart;
    private final String namespace;
    private final String prefix;
    private transient String toStringCache;
    private transient Integer hashCodeCache;

    public QName(String localPart, String namespace, String prefix) {
        this.localPart = localPart;
        this.namespace = namespace;
        this.prefix = prefix;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            QName q = (QName)obj;
            if (!QName.equals(this.getLocalPart(), q.getLocalPart())) {
                return false;
            }
            return QName.equals(this.getNamespace(), q.getNamespace());
        }
        return false;
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            StringBuffer buf = new StringBuffer();
            if (this.namespace != null) {
                buf.append(this.namespace);
            }
            if (this.localPart != null) {
                buf.append(this.localPart);
            }
            this.hashCodeCache = buf.length() != 0 ? new Integer(buf.toString().hashCode()) : new Integer(super.hashCode());
        }
        return this.hashCodeCache;
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuffer buf = new StringBuffer();
            if (this.prefix != null && this.prefix.length() > 0) {
                buf.append(this.prefix);
                buf.append(':');
            }
            if (this.localPart != null) {
                buf.append(this.localPart);
            }
            this.toStringCache = buf.toString();
        }
        return this.toStringCache;
    }

    public static boolean equals(String qn1, Node context1, String qn2, Node context2) {
        if (qn1 == qn2) {
            return true;
        }
        if (qn1 == null || qn2 == null) {
            return false;
        }
        return QName.equals(QName.getLocalPart(qn1), QName.getLocalPart(qn2)) && QName.equals(QName.resolvePrefix(qn1, context1), QName.resolvePrefix(qn2, context2));
    }

    public static String resolvePrefix(String qname, Node context) {
        String pref = QName.getPrefixPart(qname);
        if (pref.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return XMLUtils.resolveNSPrefix(pref, context);
    }

    public static String getPrefixPart(String qname) {
        int i = qname.indexOf(58);
        if (i > 0) {
            return qname.substring(0, i);
        }
        return "";
    }

    public static String getLocalPart(String qname) {
        if (qname == null) {
            return "";
        }
        int i = qname.lastIndexOf(58) + 1;
        if (i < qname.length()) {
            return qname.substring(i);
        }
        return "";
    }

    public static void setQNameValue(Node node, QName qname) {
        short nodeType = node.getNodeType();
        GenericXMLElement parent = null;
        if (nodeType == 1) {
            parent = new GenericXMLElement((Element)node);
        } else {
            short pNodeType;
            Node p = node;
            do {
                if ((pNodeType = p.getNodeType()) != 1) continue;
                parent = new GenericXMLElement((Element)p);
                break;
            } while ((p = pNodeType == 2 ? ((Attr)p).getOwnerElement() : p.getParentNode()) != null);
        }
        if (parent == null) {
            throw new DOMException(3, "No parent element found for target node");
        }
        String defaultNS = XMLUtils.resolveNSPrefix("", parent.getNode());
        String prefix = qname.getPrefix();
        String namespace = qname.getNamespace();
        if (namespace == null) {
            namespace = defaultNS;
        }
        if (prefix == null) {
            if (defaultNS != null && !namespace.equals(defaultNS)) {
                throw new DOMException(14, "Default Namespace for Value is different from Default StatusCode Namespace");
            }
        } else {
            String parentPrefix = parent.getPrefix();
            if (prefix.equals(parentPrefix)) {
                String resolvedNS = XMLUtils.resolveNSPrefix(parentPrefix, parent.getNode());
                if (resolvedNS != null && !namespace.equals(resolvedNS)) {
                    throw new DOMException(14, "Namespace for Value is different from StatusCode Namespace for the same prefix: " + prefix);
                }
            } else {
                String resolvedNS = XMLUtils.resolveNSPrefix(prefix, parent.getNode());
                if (resolvedNS != null) {
                    if (!resolvedNS.equals(namespace)) {
                        throw new DOMException(14, "Namespace " + resolvedNS + " already declared for prefix" + prefix);
                    }
                } else {
                    parent.addNSPrefixAttr(prefix, namespace);
                }
            }
        }
        String qnameStr = qname.toString();
        if (nodeType == 2) {
            ((Attr)node).setValue(qnameStr);
        } else {
            node.appendChild(node.getOwnerDocument().createTextNode(qnameStr));
        }
    }

    public static QName getInstance(String qnameValue, XMLElement element) {
        String prefix = QName.getPrefixPart(qnameValue);
        String value = QName.getLocalPart(qnameValue);
        String namespace = null;
        namespace = prefix != null ? QName.resolvePrefix(qnameValue, element.getNode()) : XMLUtils.resolveNSPrefix("", element.getNode());
        return new QName(value, namespace, prefix);
    }

    static boolean isValidQName(String qname) {
        if (qname == null || qname.length() == 0) {
            return false;
        }
        try {
            return qname.equals(QName.makeQName(QName.getPrefixPart(qname), QName.getLocalPart(qname)));
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    static String makeQName(String prefix, String localName) throws IllegalArgumentException {
        if (localName == null || localName.length() == 0) {
            throw new IllegalArgumentException("QName must have local part");
        }
        StringBuffer qname = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            qname.append(prefix);
            qname.append(':');
        }
        qname.append(localName);
        return qname.toString();
    }
}

