/*
 * Decompiled with CFR 0.152.
 */
package dbmodel;

import dbmodel.BaseClass;
import dbmodel.bundle_xml.TargetType;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SystemInstance {
    private final Logger logger = Logger.getLogger(BaseClass.class.getName());
    protected List<BaseClass> systemEntities = new ArrayList<BaseClass>();
    private AbstractBaseTarget top = null;

    public List<BaseClass> getEntities() {
        return this.systemEntities;
    }

    public SystemInstance(List<BaseClass> all, AbstractBaseTarget top) {
        this.top = top;
        this.systemEntities = all;
    }

    public SystemInstance() {
    }

    public void writeFile(File f) throws FileNotFoundException {
        XMLEncoder enc = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));
        enc.writeObject(this.getEntities());
        enc.close();
    }

    public SystemInstance readFile(File f) throws FileNotFoundException {
        XMLDecoder dec = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)));
        SystemInstance ti = new SystemInstance();
        ArrayList arr = (ArrayList)dec.readObject();
        for (Object o : arr) {
            ti.getEntities().add((BaseClass)o);
        }
        return ti;
    }

    public AbstractBaseTarget getTop() {
        return this.top;
    }

    public AbstractBaseTarget setTop(AbstractBaseTarget in) {
        AbstractBaseTarget old = this.top;
        this.top = in;
        return old;
    }

    public void add(BaseClass in) {
        this.systemEntities.add(in);
    }

    public <T extends AbstractBaseTarget> List<T> getTargetsOfType(Class<T> classs) {
        ArrayList<T> ret = new ArrayList<T>();
        this.logger.fine("Filtering for class: " + classs);
        for (BaseClass base : this.getEntities()) {
            if (!classs.isInstance(base)) continue;
            ret.add(classs.cast(base));
        }
        this.logger.fine("Found and returning: " + ret);
        return ret;
    }

    public List<AbstractBaseTarget> getTargetsOfEMTypeAndVersion(TargetType tt) {
        ArrayList<AbstractBaseTarget> result = new ArrayList<AbstractBaseTarget>();
        if (tt.getType() == null) {
            throw new IllegalArgumentException(" type is missing in subpatch target type metadata");
        }
        if (tt.getType() == null) {
            throw new IllegalArgumentException(" type ID is missing in subpatch target type metadata");
        }
        String typeId = tt.getType().toString().trim();
        String version = tt.getVersion();
        String propertyName = tt.getPropertyName();
        String propertyValue = tt.getPropertyValue();
        for (BaseClass base : this.getEntities()) {
            String targetTypeId;
            AbstractBaseTarget target = null;
            if (base instanceof AbstractBaseTarget) {
                target = (AbstractBaseTarget)base;
            }
            if (target == null || (targetTypeId = target.getTargetTypeId()) == null || targetTypeId.trim().length() == 0) continue;
            targetTypeId = targetTypeId.trim();
            String targetVersion = target.getVersion();
            if (targetVersion != null) {
                targetVersion = targetVersion.trim();
            }
            if (!typeId.equals(targetTypeId) || version != null && !version.trim().equals(targetVersion)) continue;
            if (propertyName == null || propertyName.trim().length() == 0) {
                result.add(target);
                continue;
            }
            if (propertyValue == null || propertyValue.trim().length() == 0) continue;
            String name = target.getEMpropertyName();
            String value = target.getEMpropertyValue();
            if (name == null || name.trim().length() == 0 || value == null || value.trim().length() == 0 || !name.trim().equals(propertyName.trim()) || !value.trim().equals(propertyValue.trim())) continue;
            result.add(target);
        }
        return result;
    }

    public List<OracleHome> getAllHomes() {
        ArrayList<OracleHome> homes = new ArrayList<OracleHome>();
        for (BaseClass obj : this.getEntities()) {
            if (!(obj instanceof OracleHome)) continue;
            homes.add((OracleHome)obj);
        }
        return homes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(" SystemInstance: top=").append(this.getTop() != null ? this.getTop().toString() : "null");
        for (BaseClass base : this.getEntities()) {
            if (!(base instanceof AbstractBaseTarget)) continue;
            AbstractBaseTarget target = (AbstractBaseTarget)base;
            sb.append("\n").append(base.toString()).append(" version=").append(target.getVersion()).append(" targetTypeId=").append(target.getTargetTypeId()).append(" EM property name=").append(target.getEMpropertyName()).append(" EM property Value=").append(target.getEMpropertyValue());
        }
        return sb.toString();
    }
}

