/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import java.util.Arrays;

public abstract class ASN1Container {
    protected static final String a = "EndContainer is missing.";
    public boolean dataPresent;
    public byte[] data;
    public int dataOffset;
    public int dataLen;
    protected int b = -1;
    protected int c;
    protected int d;
    protected int e = -1;
    protected int f;
    protected int g;
    protected int h;
    protected int i;
    protected int j;
    boolean k;
    boolean l;
    protected boolean m;
    protected int n;
    static final int o = 65535;
    static final int p = 65536;
    static final int q = 131072;
    static final int r = 262144;
    protected static final int s = 0x100000;
    protected static final int t = 0x200000;
    static final int u = 0x400000;
    protected static final int v = 0x1000000;
    protected static final int w = 0x2000000;
    static final int x = 0x10000000;
    static final int y = 0x20000000;
    protected int z;
    protected boolean A;
    protected int B;

    protected ASN1Container() {
    }

    protected ASN1Container(int n2, int n3) {
        this(n2, true, 0, n3);
    }

    protected ASN1Container(int n2, int n3, int n4) {
        this(n2, true, 0, n3, n4);
    }

    protected ASN1Container(int n2, boolean bl2, int n3, int n4) {
        this(n2, bl2, n3, n4, 0);
    }

    protected ASN1Container(int n2, boolean bl2, int n3, int n4, int n5) {
        if (n2 >= 0) {
            this.i = n2;
        }
        this.dataPresent = bl2;
        this.j = n3;
        this.f = n4;
        this.B = n5;
        this.g = 0;
        if ((n4 & 0x2000) != 0) {
            this.k = true;
        }
    }

    public void setExtendedTag(int n2) throws ASN_Exception {
        if (this.e != -1) {
            throw new ASN_Exception("Extended tag already set.");
        }
        if (n2 < 0 || n2 > 0x1FFFFFF) {
            throw new ASN_Exception("Invalid extended tag value.");
        }
        if (n2 < 31) {
            this.i |= n2;
            return;
        }
        this.e = n2;
    }

    public boolean isComplete() {
        return (this.n & 0x2000000) != 0;
    }

    public boolean checkTag() {
        return (this.n & 0x100000) != 0;
    }

    public void addData(byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) throws ASN_Exception {
        if (bl2) {
            if ((this.n & 0x2000000) != 0) {
                this.n ^= 0x2000000;
            }
        } else {
            if ((this.i & 0x4000000) == 0) {
                throw new ASN_Exception("This type is not allowed to accept new data.");
            }
            if ((this.n & 0x2000000) != 0) {
                throw new ASN_Exception("The container cannot accept new data, already encoded.");
            }
        }
        if ((this.n & 0x40000) != 0 && byArray != null) {
            throw new ASN_Exception("The container cannot accept new data any more.");
        }
        this.data = byArray;
        this.n |= 0x20000;
        if (byArray == null) {
            if (!bl3 || (this.i & 0x4000000) == 0) {
                throw new ASN_Exception("Cannot add null newData unless dataComplete is true.");
            }
            this.dataOffset = 0;
            this.dataLen = 0;
            this.n ^= 0x20000;
            this.n |= 0x40000;
            return;
        }
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: offset is out of range.");
        }
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new ASN_Exception("ASN1Container.addData: len is out of range.");
        }
        this.dataOffset = n2;
        this.dataLen = n3;
        this.dataPresent = true;
        if (bl3) {
            this.n |= 0x40000;
        }
    }

    public void noMoreData() throws ASN_Exception {
        this.n |= 0x40000;
    }

    void a() {
        if ((this.n & 0x2000000) != 0) {
            this.n &= 0xFDFFFFFF;
            this.n |= 0x20000;
        }
        if ((this.i & 0x20000) != 0) {
            this.j = 0;
        }
        this.d = this.f >>> 8;
        int n2 = this.i & 0xE00000;
        if (n2 == 0) {
            return;
        }
        n2 >>>= 16;
        if (this.k) {
            n2 |= 0x20;
        }
        if (this.e == -1) {
            n2 |= this.i & 0xFF;
        } else {
            n2 |= 0x1F;
            int n3 = this.e;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                int n6 = (n3 & 0x7F) << n5;
                if (n5 != 0) {
                    n6 |= 128 << n5;
                }
                n4 |= n6;
                if ((n3 >>>= 7) == 0) break;
                n5 += 8;
            }
            n2 <<= n5 + 8;
            n2 |= n4;
        }
        if ((this.i & 0x200000) != 0) {
            this.b = n2;
        } else {
            this.d = n2;
        }
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.a();
        this.n |= 0x40000;
        if (!this.dataPresent) {
            return this.a(false, null, 0);
        }
        if (this.l) {
            return this.dataLen;
        }
        this.h = this.dataLen;
        int n3 = ASN1Lengths.getTagLen(this.d) + this.h + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.b == -1) {
            return n3;
        }
        this.c = n3;
        return ASN1Lengths.getTagLen(this.b) + this.c + ASN1Lengths.getLengthLen(n3);
    }

    int a(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        this.n = 0x2000000;
        if (!this.dataPresent) {
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if (this.b != -1) {
            n3 += ASN1Lengths.writeTag(byArray, n3, this.b);
            n3 += ASN1Lengths.writeLength(byArray, n3, this.c);
        }
        n3 += ASN1Lengths.writeTag(byArray, n3, this.d);
        n3 += ASN1Lengths.writeLength(byArray, n3, this.h);
        if (this.data != null) {
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.derEncode: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        return n3 - n4;
    }

    int a(boolean bl2, byte[] byArray, int n2) throws ASN_Exception {
        if ((this.i & 0x10000) != 0 && this.j == 5) {
            if (bl2) {
                byArray[n2] = 5;
                byArray[n2 + 1] = 0;
            }
            return 2;
        }
        if ((this.i & 0xF0000) != 0) {
            return 0;
        }
        int n3 = 2;
        if (this.b != -1) {
            if (bl2) {
                byArray[n2] = (byte)this.b;
                byArray[n2 + 1] = 2;
            }
            n3 += 2;
            n2 += 2;
        }
        if (bl2) {
            byArray[n2] = (byte)this.d;
            byArray[n2 + 1] = 0;
        }
        return n3;
    }

    void b(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.a();
        this.h = this.dataLen;
        if ((this.i & 0x4000000) != 0 && (this.n & 0x40000) == 0) {
            this.d |= 0x20;
            this.h = -1;
        } else {
            this.n |= 0x40000;
        }
        this.n |= 0x10000;
    }

    int b(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        if (this.n == 0) {
            throw new ASN_Exception("Cannot continue BER encoding without new data.");
        }
        if ((this.n & 0x2000000) != 0) {
            return 0;
        }
        if (!this.dataPresent) {
            this.n = 0x2000000;
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if ((this.n & 0x10000) != 0) {
            n3 += this.a(byArray, n3);
        }
        if ((this.n & 0x20000) != 0) {
            n3 += this.c(aSN1ContainerArray, n2, byArray, n3);
        }
        if ((this.n & 0x40000) != 0) {
            n3 += this.b(byArray, n3);
        }
        return n3 - n4;
    }

    int a(byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        if (this.b != -1) {
            n2 += ASN1Lengths.writeTag(byArray, n2, this.b);
            byArray[n2++] = -128;
        }
        n2 += ASN1Lengths.writeTag(byArray, n2, this.d);
        if (this.h == -1) {
            byArray[n2++] = -128;
        } else {
            n2 += ASN1Lengths.writeLength(byArray, n2, this.h);
        }
        this.n ^= 0x10000;
        return n2 - n3;
    }

    int c(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4 = n3;
        if (this.data != null && this.dataLen != 0) {
            if (this.h == -1) {
                if (this.f == 7680 || this.f == 5632 || this.f == 4608 || this.f == 4864 || this.f == 5120 || this.f == 7168) {
                    this.g = this.f;
                    this.f = 1024;
                }
                byArray[n3++] = (byte)(this.f >>> 8);
                n3 += ASN1Lengths.writeLength(byArray, n3, this.dataLen);
            }
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("ASN1Container.writeDataBER: no room in encoding to put data.");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        this.n ^= 0x20000;
        return n3 - n4;
    }

    int b(byte[] byArray, int n2) {
        this.n = 0x2000000;
        int n3 = n2;
        if (this.h == -1) {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
            n2 += 2;
        }
        if (this.b != -1) {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
            n2 += 2;
        }
        if (this.g != 0) {
            this.f = this.g;
            this.d = this.f >>> 8;
        }
        return n2 - n3;
    }

    void b() {
        this.c();
        this.a();
        this.n = 0x100000;
        if (this.b != -1) {
            this.n |= 0x200000;
        }
        this.dataPresent = true;
    }

    void c() {
        this.c = 0;
        this.h = 0;
        this.clearSensitiveData();
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5;
        block3: {
            this.clearSensitiveData();
            n5 = n3;
            this.z = n4 - n3;
            if ((this.n & 0x100000) != 0) {
                int n6 = this.b(aSN1Template, n2, byArray, n3, this.z);
                if ((this.n & 0x1000000) != 0 || (this.n & 0x2000000) != 0) {
                    return n6;
                }
                this.n |= 0x400000;
                n3 += n6;
                this.z -= n6;
            }
            if (this.z < 1 && this.h != 0) break block3;
            do {
                n3 += this.a(aSN1Template, n2, byArray, n3);
            } while ((this.n & 0x1000000) == 0 && (this.n & 0x2000000) == 0 && this.z >= 1);
        }
        return n3 - n5;
    }

    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4;
        int n5 = n3;
        if (this.h > 0) {
            n4 = this.h;
            if (this.z < this.h) {
                n4 = this.z;
            }
            if (this.A) {
                this.a(byArray, n3, n4);
            } else {
                if (this.B != 0 && this.B >= n4) {
                    this.data = new byte[this.B];
                    System.arraycopy(byArray, n3, this.data, 0, n4);
                    this.dataOffset = 0;
                } else {
                    this.data = byArray;
                    this.dataOffset = n3;
                }
                this.dataLen = n4;
            }
            this.h -= n4;
            n3 += n4;
            if (this.h > 0) {
                this.n |= 0x1000000;
                return n3 - n5;
            }
            this.z -= n4;
        }
        n4 = this.a(aSN1Template, byArray, n3, this.z);
        n3 += n4;
        this.z -= n4;
        if ((this.n & 0x1000000) != 0 || (this.n & 0x2000000) != 0) {
            return n3 - n5;
        }
        this.n |= 0x100000;
        n4 = this.b(aSN1Template, n2, byArray, n3, this.z);
        n3 += n4;
        if ((this.n & 0x1000000) != 0) {
            return n3 - n5;
        }
        this.z -= n4;
        if (this.z < 1) {
            this.n |= 0x1000000;
        }
        this.A = true;
        return n3 - n5;
    }

    int a(ASN1Template aSN1Template, byte[] byArray, int n2, int n3) throws ASN_Exception {
        int n4 = this.n & 0xFFFF;
        if (n4 == 0) {
            this.n = 0x2000000;
            return 0;
        }
        if (n3 < 1) {
            return 0;
        }
        int n5 = n2;
        int n6 = this.b(aSN1Template, byArray, n2, n3);
        n2 += n6;
        if ((this.n & 0x1000000) != 0) {
            return n2 - n5;
        }
        n3 -= n6;
        if (aSN1Template.c[0] == 0) {
            if (aSN1Template.c[1] != 0) {
                throw new ASN_Exception("Improper ending to indefinite length.");
            }
            this.n -= 2;
            aSN1Template.e = 0;
            if ((n4 -= 2) == 0) {
                this.n = 0x2000000;
                if (this.g != 0) {
                    this.f = this.g;
                    this.d = this.f >>> 8;
                }
                return n2 - n5;
            }
            n2 += this.a(aSN1Template, byArray, n2, n3);
            return n2 - n5;
        }
        if (this.c == -1 && n4 == 2) {
            throw new ASN_Exception("Improper ending to indefinite length.");
        }
        return n2 - n5;
    }

    void a(byte[] byArray, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        if (this.data == null && this.B != 0) {
            this.data = new byte[this.B];
        }
        if (this.data != null && this.data.length > this.dataLen + n3) {
            System.arraycopy(byArray, n2, this.data, this.dataLen, n3);
            this.dataLen += n3;
            return;
        }
        byte[] byArray2 = new byte[this.dataLen + n3];
        if (this.data != null) {
            System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
        }
        System.arraycopy(byArray, n2, byArray2, this.dataLen, n3);
        if (this.m) {
            this.clearSensitiveData();
        }
        this.data = byArray2;
        this.dataOffset = 0;
        this.dataLen = byArray2.length;
        this.m = true;
    }

    int b(ASN1Template aSN1Template, int n2, byte[] byArray, int n3, int n4) throws ASN_Exception {
        int n5 = n3;
        int n6 = this.b(aSN1Template, byArray, n3, n4);
        if ((this.n & 0x1000000) != 0) {
            return n6;
        }
        n3 += n6;
        n4 -= n6;
        if ((this.n & 0x200000) != 0) {
            if (!this.a(aSN1Template, this.b)) {
                this.b(aSN1Template, n2);
                return n3 - n5;
            }
            this.n ^= 0x200000;
            this.c = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.c == -1) {
                this.n += 2;
            }
            aSN1Template.e = 0;
            n6 = this.b(aSN1Template, byArray, n3, n4);
            n3 += n6;
            n4 -= n6;
            if ((this.n & 0x1000000) != 0) {
                return n3 - n5;
            }
        }
        if (this.a(aSN1Template, this.d)) {
            this.h = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.h == -1) {
                if ((aSN1Template.c[0] & 0x20) == 0) {
                    throw new ASN_Exception("Invalid indefinite length octet.");
                }
                this.n += 2;
            }
            this.n ^= 0x100000;
            aSN1Template.e = 0;
            return n3 - n5;
        }
        int n7 = 32;
        n7 <<= (aSN1Template.d - 1) * 8;
        if ((this.i & 0x4000000) != 0 && this.a(aSN1Template, n7 |= this.d)) {
            this.h = ASN1Lengths.determineLength(aSN1Template.c, aSN1Template.d);
            if (this.h != -1) {
                throw new ASN_Exception("Primitive promoted to constructed must be indefinite length.");
            }
            this.n ^= 0x100000;
            this.n += 2;
            if (this.f == 7680 || this.f == 5632 || this.f == 4608 || this.f == 4864 || this.f == 5120 || this.f == 7168) {
                this.g = this.f;
                this.f = 1024;
            }
            this.d = this.f >>> 8;
            aSN1Template.e = 0;
            return n3 - n5;
        }
        if (this.b != -1) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        if ((this.i & 0x4000000) != 0 && n4 > 1 && byArray[n5] == 0 && byArray[n5 + 1] == 0) {
            this.n = 0x2000000;
            if (this.g != 0) {
                this.f = this.g;
                this.d = this.f >>> 8;
            }
            n3 = n5 + 2;
            return n3 - n5;
        }
        this.b(aSN1Template, n2);
        return n3 - n5;
    }

    int b(ASN1Template aSN1Template, byte[] byArray, int n2, int n3) throws ASN_Exception {
        this.n |= 0x1000000;
        int n4 = n2;
        int n5 = this.a(aSN1Template);
        while (n5 > 0 && n3 >= 1) {
            if (aSN1Template.e >= aSN1Template.c.length) {
                throw new ASN_Exception("Tag and len len is too large.");
            }
            aSN1Template.c[aSN1Template.e] = byArray[n2];
            --n3;
            ++aSN1Template.e;
            ++n2;
            if (--n5 >= 1) continue;
            n5 = this.a(aSN1Template);
        }
        if (n5 < 1) {
            this.n ^= 0x1000000;
        }
        return n2 - n4;
    }

    int a(ASN1Template aSN1Template) throws ASN_Exception {
        int n2;
        if (aSN1Template.e == 0) {
            return 1;
        }
        aSN1Template.d = 1;
        if ((aSN1Template.c[0] & 0x1F) == 31) {
            for (n2 = 1; n2 < aSN1Template.e && (aSN1Template.c[n2] & 0x80) != 0; ++n2) {
            }
            if (n2 >= aSN1Template.e) {
                return 1;
            }
            aSN1Template.d = ++n2;
        }
        if (n2 >= aSN1Template.e) {
            return 1;
        }
        int n3 = n2;
        return (n3 += ASN1Lengths.determineLengthLen(aSN1Template.c, n2)) - aSN1Template.e;
    }

    boolean a(ASN1Template aSN1Template, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < aSN1Template.d; ++i2) {
            n3 = n3 << 8 | aSN1Template.c[i2] & 0xFF;
        }
        return n3 == n2;
    }

    void b(ASN1Template aSN1Template, int n2) throws ASN_Exception {
        if ((this.n & 0x400000) != 0) {
            throw new ASN_Exception("Invalid encoding: expected tag or data not there.");
        }
        if ((this.i & 0x10000) != 0 && aSN1Template.e > 0 && aSN1Template.c[0] == 5) {
            this.dataPresent = false;
            this.j = 5;
            if (aSN1Template.c[1] != 0) {
                throw new ASN_Exception("Length after NULL not zero.");
            }
            this.n |= 0x2000000;
            aSN1Template.e = 0;
            return;
        }
        if ((this.i & 0xF0000) == 0) {
            throw new ASN_Exception("Invalid encoding: expected tag not there.");
        }
        this.dataPresent = false;
        this.n |= 0x2000000;
    }

    boolean a(int n2, ASN1Container[] aSN1ContainerArray, int n3) throws ASN_Exception {
        if ((this.n & 0x2000000) != 0) {
            return false;
        }
        if (n2 == 5 && (this.i & 0x10000) != 0) {
            return true;
        }
        if (this.b != -1) {
            return n2 == this.b;
        }
        if (n2 == this.d) {
            return true;
        }
        return (this.i & 0x4000000) != 0 && n2 == (this.d | 0x20);
    }

    boolean a(ASN1Container aSN1Container) {
        return false;
    }

    abstract ASN1Container d();

    public void clearSensitiveData() {
        if (this.data != null && this.m) {
            Arrays.fill(this.data, (byte)0);
        }
        this.data = null;
        this.dataOffset = 0;
        this.dataLen = 0;
        this.m = false;
    }
}

