/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto;

import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.BadPaddingException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.IllegalBlockSizeException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.InvalidKeyException;
import com.rsa.crypto.JCMCloneable;
import com.rsa.crypto.Key;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.SensitiveData;
import java.io.Serializable;

public interface Cipher
extends JCMCloneable,
SensitiveData,
Serializable {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;

    public String getAlg();

    public CryptoModule getCryptoModule();

    public int getMaxInputLen();

    public void init(int var1, Key var2, AlgorithmParams var3, SecureRandom var4) throws InvalidAlgorithmParameterException, InvalidKeyException;

    public int update(byte[] var1, int var2, int var3, byte[] var4, int var5);

    public void updateAAD(byte[] var1, int var2, int var3);

    public int doFinal(byte[] var1, int var2, int var3, byte[] var4, int var5) throws BadPaddingException, IllegalBlockSizeException;

    public int doFinal(byte[] var1, int var2) throws BadPaddingException, IllegalBlockSizeException;

    public void reInit(AlgorithmParams var1);

    public int getOutputSize(int var1);

    public int getBlockSize();

    public AlgorithmParams getAlgorithmParams();
}

