/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.alg;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.BadPaddingException;
import com.rsa.crypto.IllegalBlockSizeException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.InvalidKeyException;
import com.rsa.crypto.Key;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.alg.AbstractAsymmCipher;
import com.rsa.crypto.ncm.alg.c;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAlgorithmIdentifier;
import com.rsa.crypto.ncm.ccme.CCMEAsymmetricKey;
import com.rsa.crypto.ncm.ccme.CCMECryptoContext;
import com.rsa.crypto.ncm.ccme.CCMECryptoObject;
import com.rsa.crypto.ncm.key.ECPrivateKeyImpl;
import com.rsa.crypto.ncm.key.ECPublicKeyImpl;
import com.rsa.crypto.ncm.key.a;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ECIESCipher
extends AbstractAsymmCipher {
    ByteArrayOutputStream h = null;
    byte[] i;
    byte[] j;

    public ECIESCipher(b b2, String string) {
        super(b2, string);
        this.b = ECIESCipher.a(this.a);
        this.c = CCMEAlgorithmIdentifier.getAlgId(this.b);
        this.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.c);
    }

    @Override
    public int getMaxInputLen() {
        return -1;
    }

    @Override
    public void init(int n2, Key key, AlgorithmParams algorithmParams, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.a(n2);
        this.a(key);
        this.a(algorithmParams);
        this.a(secureRandom);
        this.initNative(this.e, this.d, this.g, this.i, this.j);
        if (this.h != null) {
            this.h.reset();
        }
        this.f = true;
    }

    @Override
    public int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.b();
        if (byArray == null || n3 <= 0) {
            return 0;
        }
        if (this.h == null) {
            this.h = new ByteArrayOutputStream(n3);
        }
        this.h.write(byArray, n2, n3);
        return 0;
    }

    @Override
    public int getOutputSize(int n2) {
        this.b();
        return Math.max(0, this.getOutputSizeNative(this.e, n2 + (this.h != null ? this.h.size() : 0)));
    }

    @Override
    public int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException {
        this.update(byArray, n2, n3, byArray2, n4);
        return this.doFinal(byArray2, n4);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws BadPaddingException, IllegalBlockSizeException {
        this.b();
        if (this.h != null && this.h.size() > 0) {
            int n3 = this.doFinalNative(this.e, this.h.toByteArray(), 0, this.h.size(), byArray, n2);
            this.h.reset();
            return n3;
        }
        return 0;
    }

    @Override
    public void reInit(AlgorithmParams algorithmParams) {
        this.b();
        this.a(algorithmParams);
        this.initNative(this.e, this.d, this.g, this.i, this.j);
        if (this.h != null) {
            this.h.reset();
        }
    }

    @Override
    public int getBlockSize() {
        return 0;
    }

    @Override
    public AlgorithmParams getAlgorithmParams() {
        if (this.i == null && this.j == null) {
            return null;
        }
        com.rsa.crypto.ncm.alg.b b2 = new com.rsa.crypto.ncm.alg.b(this.cryptoModule);
        if (this.i != null) {
            b2.set("sharedData1", this.i);
        }
        if (this.j != null) {
            b2.set("sharedData2", this.j);
        }
        return b2;
    }

    @Override
    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.h != null) {
            byte[] byArray = new byte[this.h.size()];
            Arrays.fill(byArray, (byte)0);
            this.h.reset();
            this.h.write(byArray, 0, byArray.length);
            this.h.reset();
        }
        if (this.i != null) {
            Arrays.fill(this.i, (byte)0);
            this.i = null;
        }
        if (this.j != null) {
            Arrays.fill(this.j, (byte)0);
            this.j = null;
        }
    }

    @Override
    protected void dupObject(CCMECryptoObject cCMECryptoObject) {
        super.dupObject(cCMECryptoObject);
        if (this.isSensitiveDataCleared()) {
            return;
        }
        ECIESCipher eCIESCipher = (ECIESCipher)cCMECryptoObject;
        eCIESCipher.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.c);
        if (this.h != null) {
            eCIESCipher.h = new ByteArrayOutputStream(this.h.size());
            eCIESCipher.h.write(this.h.toByteArray(), 0, this.h.size());
        }
        if (this.i != null) {
            eCIESCipher.i = (byte[])this.i.clone();
        }
        if (this.j != null) {
            eCIESCipher.j = (byte[])this.j.clone();
        }
        if (this.f) {
            eCIESCipher.initNative(eCIESCipher.e, eCIESCipher.d, eCIESCipher.g, eCIESCipher.i, eCIESCipher.j);
        }
    }

    private void a(Key key) {
        if (!(key instanceof a)) {
            throw new InvalidKeyException("Not a native EC key.");
        }
        if (this.e && !(key instanceof ECPublicKeyImpl) || !this.e && !(key instanceof ECPrivateKeyImpl)) {
            throw new InvalidKeyException("Wrong key type.");
        }
        this.a();
        this.d = (CCMEAsymmetricKey)key.clone();
    }

    private void a(AlgorithmParams algorithmParams) {
        if (algorithmParams == null) {
            return;
        }
        if (!(algorithmParams instanceof AlgInputParams)) {
            throw new InvalidAlgorithmParameterException("Invalid ECIES cipher initialization parameters");
        }
        AlgInputParams algInputParams = (AlgInputParams)algorithmParams;
        this.i = com.rsa.crypto.ncm.alg.c.b(algInputParams, "sharedData1", null);
        this.j = com.rsa.crypto.ncm.alg.c.b(algInputParams, "sharedData2", null);
    }

    private static String a(String string) {
        String[] stringArray = string.split("/");
        String string2 = null;
        if (stringArray.length == 5 && "XOR".equalsIgnoreCase(stringArray[1]) && "SHA1".equalsIgnoreCase(stringArray[2]) && "SHA1".equalsIgnoreCase(stringArray[3]) && "ECDHC".equalsIgnoreCase(stringArray[4])) {
            string2 = "ECIES_XOR_HMAC_SHA1";
        } else if (stringArray.length == 6 && "DESede".equalsIgnoreCase(stringArray[1]) && "SHA224".equalsIgnoreCase(stringArray[2]) && "SHA224".equalsIgnoreCase(stringArray[3]) && "ECDHC".equalsIgnoreCase(stringArray[4]) && Integer.parseInt(stringArray[5]) == 192) {
            string2 = "ECIES_3DES_EDE_HMAC_SHA224";
        } else if (stringArray.length == 6 && "AES".equalsIgnoreCase(stringArray[1]) && "ECDHC".equalsIgnoreCase(stringArray[4])) {
            if ("SHA256".equalsIgnoreCase(stringArray[2]) && "SHA256".equalsIgnoreCase(stringArray[3]) && Integer.parseInt(stringArray[5]) == 128) {
                string2 = "ECIES_AES_128_HMAC_SHA256";
            } else if ("SHA384".equalsIgnoreCase(stringArray[2]) && "SHA384".equalsIgnoreCase(stringArray[3]) && Integer.parseInt(stringArray[5]) == 192) {
                string2 = "ECIES_AES_192_HMAC_SHA384";
            } else if ("SHA512".equalsIgnoreCase(stringArray[2]) && "SHA512".equalsIgnoreCase(stringArray[3]) && Integer.parseInt(stringArray[5]) == 256) {
                string2 = "ECIES_AES_256_HMAC_SHA512";
            }
        }
        if (string2 == null) {
            throw new NoSuchAlgorithmException("This functionality is not supported by the native module. " + string);
        }
        return string2;
    }

    private native void createObject(CCMECryptoContext var1, byte[] var2, int var3);

    protected native void initNative(boolean var1, CCMEAsymmetricKey var2, CCMECryptoObject var3, byte[] var4, byte[] var5);
}

