/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.e.qa;
import com.rsa.cryptoj.e.qd;
import com.rsa.cryptoj.e.qg;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public final class SuiteBChecker {
    private SuiteBChecker() {
    }

    public static boolean isSuiteBCompliant(X509CRL x509CRL, PublicKey publicKey) {
        return qg.a(x509CRL) && qg.a(x509CRL, publicKey) && qg.b(x509CRL);
    }

    public static boolean isSuiteBCompliant(X509Certificate x509Certificate) throws CertPathValidatorException {
        try {
            return SuiteBChecker.isSuiteBCompliant(x509Certificate, x509Certificate.getPublicKey());
        }
        catch (SecurityException securityException) {
            throw new CertPathValidatorException(securityException.getMessage());
        }
    }

    public static boolean isSuiteBCompliant(X509Certificate x509Certificate, PublicKey publicKey) throws CertPathValidatorException {
        try {
            if (!(x509Certificate instanceof qd)) {
                x509Certificate = qa.a(ByteBuffer.wrap(x509Certificate.getEncoded()));
            }
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Unable to check certificate for SuiteB compliance.", exception);
        }
        qd qd2 = (qd)x509Certificate;
        try {
            return qg.c(qd2) && qg.a(qd2, publicKey) && qg.a(qd2) && qg.a(qd2.getPublicKey(), publicKey) && qg.b(qd2) && qg.a((X509Certificate)qd2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException("Unsupported PublicKey object: must be instance of java.security.ECPublicKey", invalidKeyException);
        }
        catch (SecurityException securityException) {
            throw new CertPathValidatorException("Certificate does not contain a valid key", securityException);
        }
    }
}

