/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertStore;
import java.security.cert.TrustAnchor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509V1ValidatorParameters
implements CertPathParameters {
    private Set<TrustAnchor> a;
    private Date b;
    private boolean c = true;
    private final List<CertStore> d = new ArrayList<CertStore>();

    public X509V1ValidatorParameters(Set<TrustAnchor> set) throws InvalidAlgorithmParameterException {
        if (set == null || set.isEmpty()) {
            throw new InvalidAlgorithmParameterException("The trustAnchors parameters must be non-null and a non-empty Set");
        }
        this.a = Collections.unmodifiableSet(set);
    }

    public void setDate(Date date) {
        this.b = date == null ? new Date() : (Date)date.clone();
    }

    public Date getDate() {
        if (this.b == null) {
            return null;
        }
        return (Date)this.b.clone();
    }

    public void setRevocationEnabled(boolean bl2) {
        this.c = bl2;
    }

    public boolean isRevocationEnabled() {
        return this.c;
    }

    public Set<TrustAnchor> getTrustAnchors() {
        return this.a;
    }

    public void addCertStore(CertStore certStore) {
        this.d.add(certStore);
    }

    public List<CertStore> getCertStores() {
        return Collections.unmodifiableList(this.d);
    }

    @Override
    public Object clone() {
        try {
            X509V1ValidatorParameters x509V1ValidatorParameters = (X509V1ValidatorParameters)super.clone();
            x509V1ValidatorParameters.a = Collections.unmodifiableSet(this.a);
            return x509V1ValidatorParameters;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

