/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.e.cg;
import com.rsa.cryptoj.e.ch;
import com.rsa.cryptoj.e.rt;
import com.rsa.cryptoj.e.ru;
import com.rsa.cryptoj.e.rw;
import com.rsa.jsafe.cert.CertRequest;
import com.rsa.jsafe.cert.CertRequestException;
import com.rsa.jsafe.cert.ProofGenerationParameters;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.b;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;

public final class CertRequestFactory {
    private final ru a;

    private CertRequestFactory(ru ru2) {
        this.a = ru2;
    }

    public static CertRequestFactory getInstance(String string) throws CertRequestException {
        return CertRequestFactory.a(string, cg.a());
    }

    public static CertRequestFactory getInstance(String string, FIPS140Context fIPS140Context) throws CertRequestException {
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context cannot be null");
        }
        return CertRequestFactory.a(string, b.a(fIPS140Context));
    }

    private static CertRequestFactory a(String string, ch ch2) throws CertRequestException {
        if (string == null) {
            throw new IllegalArgumentException("The requestType cannot be null");
        }
        ch2.l();
        if (string.equalsIgnoreCase("pkcs10")) {
            return new CertRequestFactory(new rw(ch2));
        }
        if (string.equalsIgnoreCase("crmf")) {
            return new CertRequestFactory(new rt(ch2));
        }
        throw new CertRequestException("Unsupported certificate request " + string);
    }

    public String getType() {
        return this.a.a();
    }

    public CertRequest generateRequest(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, CertRequestException {
        return this.a.a(algorithmParameterSpec);
    }

    public CertRequest generateRequest(AlgorithmParameterSpec algorithmParameterSpec, ProofGenerationParameters proofGenerationParameters) throws InvalidAlgorithmParameterException, CertRequestException {
        return this.a.a(algorithmParameterSpec, proofGenerationParameters);
    }

    public CertRequest loadRequest(InputStream inputStream) throws CertRequestException {
        return this.a.a(inputStream);
    }
}

