/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.e.a;
import com.rsa.cryptoj.e.d;
import com.rsa.cryptoj.e.dj;
import com.rsa.cryptoj.e.dn;
import com.rsa.cryptoj.e.dw;
import com.rsa.jsafe.cert.DistributionPointName;
import com.rsa.jsafe.cert.GeneralName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DistributionPoint
implements Cloneable {
    private DistributionPointName a;
    private List<GeneralName> b;
    private boolean[] c;

    public void setDistributionPointName(DistributionPointName distributionPointName) {
        if (distributionPointName == null) {
            throw new IllegalArgumentException("DistributionPointName is null");
        }
        this.a = distributionPointName;
    }

    public void setCRLIssuer(List<GeneralName> list) {
        if (list == null || list.contains(null) || list.isEmpty()) {
            throw new IllegalArgumentException("cRLIssuer is null or contains null elements");
        }
        this.b = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public void setReasonFlags(boolean[] blArray) {
        if (blArray == null || blArray.length == 0) {
            throw new IllegalArgumentException("Reason flags is null or empty");
        }
        if (blArray.length > 9) {
            throw new IllegalArgumentException("Unexpected number of reason flags");
        }
        this.c = dj.a(blArray);
    }

    public DistributionPointName getDistributionPointName() {
        return this.a;
    }

    public List<GeneralName> getCrLIssuer() {
        return this.b;
    }

    public boolean[] getReasonFlags() {
        return dj.a(this.c);
    }

    public byte[] getEncoded() {
        Object[] objectArray;
        d d2 = null;
        d d3 = null;
        d d4 = null;
        if (this.a != null) {
            d4 = this.a.getASN1Value();
        }
        if (this.b != null) {
            objectArray = new Object[this.b.size()];
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                objectArray[i2] = com.rsa.cryptoj.e.a.a("GeneralName", this.b.get(i2).getEncoded(), 0);
            }
            d3 = com.rsa.cryptoj.e.a.a("GeneralNames", (Object)objectArray).d(com.rsa.cryptoj.e.a.c(2));
        }
        if (this.c != null) {
            d2 = com.rsa.cryptoj.e.a.a("ReasonFlags", (Object)this.c).d(com.rsa.cryptoj.e.a.c(1));
        }
        objectArray = new Object[]{d4, d2, d3};
        d d5 = com.rsa.cryptoj.e.a.a("DistributionPoint", (Object)objectArray);
        return com.rsa.cryptoj.e.a.c(d5);
    }

    public int hashCode() {
        int n2 = dn.a(7, this.b);
        n2 = dn.a(n2, this.c);
        n2 = dn.a(n2, this.a);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DistributionPoint distributionPoint = (DistributionPoint)object;
        return dw.a(this.c, distributionPoint.c) && dw.a(this.b, distributionPoint.b) && dw.a(this.a, distributionPoint.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Distribution Point [").append(dw.a);
        if (this.a != null) {
            stringBuffer.append(this.a.toString());
        }
        if (this.b != null) {
            stringBuffer.append("   ").append("CRL Issuer [").append(dw.a);
            stringBuffer.append("      ");
            for (GeneralName generalName : this.b) {
                stringBuffer.append(generalName).append(dw.a);
            }
            stringBuffer.append("   ").append("]").append(dw.a);
        }
        if (this.c != null) {
            stringBuffer.append("   ").append("Reason Flags [").append(dw.a);
            stringBuffer.append("      ");
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                stringBuffer.append(this.c[i2]).append(", ");
            }
            stringBuffer.append("]").append(dw.a);
        }
        stringBuffer.append("   ").append("]").append(dw.a);
        return stringBuffer.toString();
    }

    public Object clone() {
        DistributionPoint distributionPoint;
        try {
            distributionPoint = (DistributionPoint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object");
        }
        distributionPoint.c = dj.a(this.c);
        return distributionPoint;
    }
}

