/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.e.dj;
import com.rsa.cryptoj.e.dn;
import com.rsa.cryptoj.e.dw;
import com.rsa.jsafe.cert.AccessDescription;
import com.rsa.jsafe.cert.AuthorityKeyIdentifier;
import com.rsa.jsafe.cert.DistributionPoint;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.ObjectID;
import com.rsa.jsafe.cert.X509ExtensionRequestSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class X509ExtensionSpec
extends X509ExtensionRequestSpec {
    private Set<ObjectID> b = new HashSet<ObjectID>();
    private AuthorityKeyIdentifier c;
    private byte[] d;
    private List<GeneralName> e;
    private List<AccessDescription> f;
    private List<AccessDescription> g;
    private List<DistributionPoint> h;
    private List<DistributionPoint> i;

    public X509ExtensionSpec() {
    }

    public X509ExtensionSpec(X509ExtensionRequestSpec x509ExtensionRequestSpec) {
        if (x509ExtensionRequestSpec == null) {
            throw new IllegalArgumentException("X509ExtensionRequestSpec is null");
        }
        if (x509ExtensionRequestSpec.isBasicConstraintsSpecified()) {
            this.setBasicConstraints(x509ExtensionRequestSpec.getBasicConstraints());
        }
        if (x509ExtensionRequestSpec.getCertificatePolicies() != null) {
            this.setCertificatePolicies(x509ExtensionRequestSpec.getCertificatePolicies());
        }
        if (x509ExtensionRequestSpec.getExtendedKeyUsage() != null) {
            this.setExtendedKeyUsage(x509ExtensionRequestSpec.getExtendedKeyUsage());
        }
        if (x509ExtensionRequestSpec.getInhibitAnyPolicy() >= 0) {
            this.setInhibitAnyPolicy(x509ExtensionRequestSpec.getInhibitAnyPolicy());
        }
        if (x509ExtensionRequestSpec.getKeyUsage() != null) {
            this.setKeyUsage(x509ExtensionRequestSpec.getKeyUsage());
        }
        this.setNameConstraints(x509ExtensionRequestSpec.getNameConstraintsPermitted(), x509ExtensionRequestSpec.getNameConstraintsExcluded());
        if (x509ExtensionRequestSpec.getRequireExplicitPolicy() >= 0 || x509ExtensionRequestSpec.getInhibitPolicyMapping() >= 0) {
            this.setPolicyConstraints(x509ExtensionRequestSpec.getRequireExplicitPolicy(), x509ExtensionRequestSpec.getInhibitPolicyMapping());
        }
        if (x509ExtensionRequestSpec.getPolicyMappings() != null) {
            this.setPolicyMappings(x509ExtensionRequestSpec.getPolicyMappings());
        }
        if (x509ExtensionRequestSpec.getSubjectAlternativeNames() != null) {
            this.setSubjectAlternativeNames(x509ExtensionRequestSpec.getSubjectAlternativeNames());
        }
        if (x509ExtensionRequestSpec.getSubjectDirectoryAttributes() != null) {
            this.setSubjectDirectoryAttributes(x509ExtensionRequestSpec.getSubjectDirectoryAttributes());
        }
        if (x509ExtensionRequestSpec.getOtherExtensions() != null) {
            List<byte[]> list = x509ExtensionRequestSpec.getOtherExtensions();
            for (byte[] byArray : list) {
                this.addOtherExtension(byArray);
            }
        }
    }

    public void setAuthorityKeyIdentifier(AuthorityKeyIdentifier authorityKeyIdentifier) {
        if (authorityKeyIdentifier == null) {
            throw new IllegalArgumentException("Authority key identifier is null");
        }
        this.a = false;
        this.c = authorityKeyIdentifier;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Key identifier is null");
        }
        this.a = false;
        this.d = dj.a(byArray);
    }

    public void setSubjectInformationAccess(List<AccessDescription> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("Subject Access Information is null or contains null elements");
        }
        this.a = false;
        this.f = Collections.unmodifiableList(new ArrayList<AccessDescription>(list));
    }

    public void setAuthorityInformationAccess(List<AccessDescription> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("Authority Access Information is null or contains null elements");
        }
        this.a = false;
        this.g = Collections.unmodifiableList(new ArrayList<AccessDescription>(list));
    }

    public void setCRLDistributionPoint(List<DistributionPoint> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("CRL Distribution point is null or contains null elements");
        }
        this.a = false;
        this.h = Collections.unmodifiableList(new ArrayList<DistributionPoint>(list));
    }

    public void setFreshestCRL(List<DistributionPoint> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("freshestCRL distribution point is null or contains null elements");
        }
        this.a = false;
        this.i = Collections.unmodifiableList(new ArrayList<DistributionPoint>(list));
    }

    public void setIssuerAlternativeNames(List<GeneralName> list) {
        if (list == null || list.contains(null)) {
            throw new IllegalArgumentException("names is null or contains null entries.");
        }
        this.a(list);
        this.a = false;
        this.e = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
    }

    public List<DistributionPoint> getCrlDistributionPoint() {
        return this.h;
    }

    public List<DistributionPoint> getFreshestCRL() {
        return this.i;
    }

    public List<AccessDescription> getSubjectAccessInformation() {
        return this.f;
    }

    public List<AccessDescription> getAuthorityAccessInformation() {
        return this.g;
    }

    public AuthorityKeyIdentifier getAuthorityKeyIdentifier() {
        return this.c;
    }

    public List<GeneralName> getIssuerAlternativeNames() {
        return this.e;
    }

    public byte[] getSubjectKeyIdentifier() {
        return dj.a(this.d);
    }

    public void setCriticalExtnOIDS(Set<ObjectID> set) {
        if (set == null || set.contains(null)) {
            throw new IllegalArgumentException("Critical extension set is null or contains null elements");
        }
        this.b = new HashSet<ObjectID>(set);
    }

    public void addCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.b.add(objectID);
    }

    public void removeCriticalExtn(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Critical extension OID is null");
        }
        this.b.remove(objectID);
    }

    public Set<ObjectID> getCriticalExtOIDS() {
        return new HashSet<ObjectID>(this.b);
    }

    @Override
    public Object clone() {
        X509ExtensionSpec x509ExtensionSpec = (X509ExtensionSpec)super.clone();
        x509ExtensionSpec.b = new HashSet<ObjectID>(this.b);
        x509ExtensionSpec.d = dj.a(this.d);
        return x509ExtensionSpec;
    }

    public boolean isEmpty() {
        return this.a;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = dn.a(n2, this.b);
        n2 = dn.a(n2, this.c);
        n2 = dn.a(n2, this.d);
        n2 = dn.a(n2, this.e);
        n2 = dn.a(n2, this.f);
        n2 = dn.a(n2, this.g);
        n2 = dn.a(n2, this.h);
        n2 = dn.a(n2, this.i);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X509ExtensionSpec x509ExtensionSpec = (X509ExtensionSpec)object;
        return super.equals(object) && dw.b(this.b, x509ExtensionSpec.b) && dw.a(this.c, x509ExtensionSpec.c) && dw.a((Object)this.d, (Object)x509ExtensionSpec.d) && dw.b(this.e, x509ExtensionSpec.e) && dw.b(this.f, x509ExtensionSpec.f) && dw.b(this.g, x509ExtensionSpec.g) && dw.b(this.h, x509ExtensionSpec.h) && dw.b(this.i, x509ExtensionSpec.i);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.c != null) {
            stringBuffer.append("AuthorityKeyIdentifier [");
            stringBuffer.append(dw.e(this.c.getKeyIdentifier()));
            stringBuffer.append("]").append(dw.a);
        }
        if (this.d != null) {
            stringBuffer.append("SubjectKeyIdentifier [");
            stringBuffer.append(dw.e(this.d));
            stringBuffer.append("]").append(dw.a);
        }
        if (this.g != null) {
            stringBuffer.append("AuthorityAccessInformation [").append(dw.a);
            for (AccessDescription object : this.g) {
                stringBuffer.append("   ").append(object).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.f != null) {
            stringBuffer.append("SubjectAccessInformation [").append(dw.a);
            for (AccessDescription accessDescription : this.f) {
                stringBuffer.append("   ").append(accessDescription).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.h != null) {
            stringBuffer.append("CRLDistributionPoint [").append(dw.a);
            for (DistributionPoint distributionPoint : this.h) {
                stringBuffer.append("   ").append(distributionPoint).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.i != null) {
            stringBuffer.append("FreshestCRL [").append(dw.a);
            for (DistributionPoint distributionPoint : this.i) {
                stringBuffer.append("   ").append(distributionPoint).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        if (this.e != null) {
            stringBuffer.append("IssuerAltName [").append(dw.a);
            for (GeneralName generalName : this.e) {
                stringBuffer.append("   ").append(generalName).append(dw.a);
            }
            stringBuffer.append("]").append(dw.a);
        }
        stringBuffer.append("Critical Extensions [").append(dw.a);
        for (ObjectID objectID : this.b) {
            stringBuffer.append("   ").append(objectID).append(dw.a);
        }
        stringBuffer.append("]").append(dw.a);
        stringBuffer.append("]").append(dw.a);
        return stringBuffer.toString();
    }
}

