/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cms;

import com.rsa.cryptoj.e.id;
import com.rsa.cryptoj.e.ih;
import com.rsa.cryptoj.e.iy;
import com.rsa.cryptoj.e.jb;
import com.rsa.cryptoj.e.jf;
import com.rsa.cryptoj.e.jw;
import com.rsa.cryptoj.e.kb;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.X509ExtensionSpec;
import com.rsa.jsafe.cms.Accuracy;
import com.rsa.jsafe.cms.CMSParameters;
import com.rsa.jsafe.cms.RecipientInfo;
import com.rsa.jsafe.cms.SignerInfo;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.CertStore;
import java.util.Date;
import javax.crypto.SecretKey;

public final class ParameterFactory {
    public static final String MAC_HMAC_SHA1 = "HMACSHA1";
    public static final String MAC_HMAC_SHA224 = "HMACSHA224";
    public static final String MAC_HMAC_SHA256 = "HMACSHA256";
    public static final String MAC_HMAC_SHA384 = "HMACSHA384";
    public static final String MAC_HMAC_SHA512 = "HMACSHA512";
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final String ENCRYPTION_ALG_AES_CBC_PKCS5PAD = "AES/CBC/PKCS5Padding";
    public static final String ENCRYPTION_ALG_DES_CBC_PKCS5PAD = "DES/CBC/PKCS5Padding";
    public static final String ENCRYPTION_ALG_DESEDE_CBC_PKCS5PAD = "DESede/CBC/PKCS5Padding";
    public static final String ENCRYPTION_ALG_RC2_CBC_PKCS5PAD = "RC2/CBC/PKCS5Padding";
    public static final String ENCRYPTION_ALG_AES_GCM_NOPAD = "AES/GCM/NoPadding";
    public static final String ENCRYPTION_ALG_AES_CCM_NOPAD = "AES/CCM/NoPadding";

    private ParameterFactory() {
    }

    public static CMSParameters newAuthenticatedDataParameters(RecipientInfo[] recipientInfoArray, String string) {
        return new ih(recipientInfoArray, string, 0, null, null, null, null);
    }

    public static CMSParameters newAuthenticatedDataParameters(RecipientInfo[] recipientInfoArray, String string, int n2, CertStore certStore, Attribute[] attributeArray, Attribute[] attributeArray2, SecureRandom secureRandom) {
        return new ih(recipientInfoArray, string, n2, certStore, attributeArray, attributeArray2, secureRandom);
    }

    public static CMSParameters newDigestedDataParameters(String string) {
        return new iy(string);
    }

    public static CMSParameters newEncryptedDataParameters(String string, SecretKey secretKey) {
        return new jb(string, secretKey, null, null);
    }

    public static CMSParameters newEncryptedDataParameters(String string, SecretKey secretKey, Attribute[] attributeArray, SecureRandom secureRandom) {
        return new jb(string, secretKey, attributeArray, secureRandom);
    }

    public static CMSParameters newEnvelopedDataParameters(RecipientInfo[] recipientInfoArray, String string) {
        return new jf(recipientInfoArray, string, 0, null, null, null);
    }

    public static CMSParameters newEnvelopedDataParameters(RecipientInfo[] recipientInfoArray, String string, int n2, CertStore certStore, Attribute[] attributeArray, SecureRandom secureRandom) {
        return new jf(recipientInfoArray, string, n2, certStore, attributeArray, secureRandom);
    }

    public static CMSParameters newSignedDataParameters(SignerInfo[] signerInfoArray, CertStore certStore) {
        return ParameterFactory.newSignedDataParameters(signerInfoArray, certStore, null);
    }

    public static CMSParameters newSignedDataParameters(SignerInfo[] signerInfoArray, CertStore certStore, SecureRandom secureRandom) {
        return new jw(signerInfoArray, certStore, secureRandom);
    }

    public static CMSParameters newTimeStampTokenParameters(String string, String string2, byte[] byArray, BigInteger bigInteger, Date date) {
        return new kb(string, string2, byArray, bigInteger, date, null, false, null, null, null);
    }

    public static CMSParameters newTimeStampTokenParameters(String string, String string2, byte[] byArray, BigInteger bigInteger, Date date, Accuracy accuracy, boolean bl2, BigInteger bigInteger2, GeneralName generalName, X509ExtensionSpec x509ExtensionSpec) {
        return new kb(string, string2, byArray, bigInteger, date, accuracy, bl2, bigInteger2, generalName, x509ExtensionSpec);
    }

    public static CMSParameters newAuthEnvelopedDataParameters(RecipientInfo[] recipientInfoArray, String string) {
        return new id(recipientInfoArray, string, 0, null, null, null, null);
    }

    public static CMSParameters newAuthEnvelopedDataParameters(RecipientInfo[] recipientInfoArray, String string, int n2, CertStore certStore, Attribute[] attributeArray, Attribute[] attributeArray2, SecureRandom secureRandom) {
        return new id(recipientInfoArray, string, n2, certStore, attributeArray, attributeArray2, secureRandom);
    }
}

