/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crypto;

import com.rsa.crypto.CryptoException;
import com.rsa.cryptoj.e.bi;
import com.rsa.cryptoj.e.bx;
import com.rsa.cryptoj.e.bz;
import com.rsa.cryptoj.e.cc;
import com.rsa.cryptoj.e.cg;
import com.rsa.cryptoj.e.ch;
import com.rsa.cryptoj.e.cn;
import com.rsa.cryptoj.e.cq;
import com.rsa.cryptoj.e.ct;
import com.rsa.cryptoj.e.dj;
import com.rsa.cryptoj.e.du;
import com.rsa.cryptoj.e.dy;
import com.rsa.cryptoj.e.kj;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.crypto.FIPS140SecurityLevel;
import com.rsa.jsafe.crypto.JSAFE_InvalidUseException;
import com.rsa.jsafe.provider.Assurance;
import com.rsa.jsafe.provider.JsafeJCE;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.io.File;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;

public final class CryptoJ {
    private static final String a = "Method only available for FIPS140 compliant jar.";
    private static final String b = "Can't change the user role in a non-FIPS140 toolkit";
    private static final String c = "Can't change the mode in a non-FIPS140 toolkit";
    public static final String CRYPTO_J_VERSION = dy.a();
    public static final int NOT_INITIALIZED = 0;
    public static final int UNDER_SELF_TEST = 1;
    public static final int OPERATIONAL = 2;
    public static final int FAILED = 3;
    public static final int FIPS140_MODE = 0;
    public static final int NON_FIPS140_MODE = 1;
    public static final int FIPS140_SSL_MODE = 2;
    public static final int FIPS140_ECC_MODE = 0;
    public static final int FIPS140_SSL_ECC_MODE = 2;
    public static final int CRYPTO_OFFICER_ROLE = 10;
    public static final int USER_ROLE = 11;
    public static final int CRYPTO_OFFICER_ROLE_PIN_POS = 0;
    public static final int USER_ROLE_PIN_POS = 1;
    private static byte[][] d;

    private CryptoJ() {
    }

    public static FIPS140Context getFIPS140Context() {
        return new FIPS140Context(cg.a());
    }

    public static SecureRandom getSeeder() {
        return bx.a();
    }

    public static void setSeeder(SecureRandom secureRandom, boolean bl2) {
        bx.a(secureRandom, bl2);
    }

    public static void setSeeder(SecureRandom secureRandom) {
        CryptoJ.setSeeder(secureRandom, true);
    }

    public static SecureRandom getDefaultRandom(FIPS140Context fIPS140Context) {
        if (!(cq.i() != 2 || fIPS140Context != null && fIPS140Context.isUserRole())) {
            throw new SecurityException("For FIPS140 Security Level 2 context must be in user role.");
        }
        ch ch2 = fIPS140Context == null ? cg.a() : fIPS140Context.ctx();
        return kj.a(ch2);
    }

    public static SecureRandom getDefaultRandom() {
        return CryptoJ.getDefaultRandom(null);
    }

    @Deprecated
    public static boolean isNativeAvailable(String string) {
        return cq.n();
    }

    public static boolean isNativeAvailable() {
        return cq.n();
    }

    public static boolean isFIPS140Compliant() {
        return cq.f();
    }

    public static boolean isAndroid() {
        return cq.e();
    }

    public static int getState() {
        try {
            CryptoJ.runSelfTests();
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            // empty catch block
        }
        return ct.a();
    }

    public static boolean inJCEStaticInitialization() {
        return ct.b();
    }

    public static int getMode() {
        return cg.a().c();
    }

    public static void setMode(int n2) throws JSAFE_InvalidUseException {
        if (!CryptoJ.isFIPS140Compliant()) {
            throw new JSAFE_InvalidUseException(c);
        }
        try {
            if (cg.a().c() == n2) {
                return;
            }
            cg.a(ch.a(n2, cg.a().d()));
        }
        catch (SecurityException securityException) {
            throw new JSAFE_InvalidUseException(securityException);
        }
    }

    public static int getRole() {
        return cg.a().d();
    }

    public static void setRole(int n2) throws JSAFE_InvalidUseException {
        if (!CryptoJ.isFIPS140Compliant()) {
            throw new JSAFE_InvalidUseException(b);
        }
        try {
            if (cg.a().d() == n2) {
                return;
            }
            cg.a(ch.a(cg.a().c(), n2));
        }
        catch (SecurityException securityException) {
            throw new JSAFE_InvalidUseException(securityException);
        }
    }

    @Deprecated
    public static void disableLibrary() {
    }

    @Deprecated
    public static void disableLibrary(FIPS140Context fIPS140Context) {
    }

    public static boolean selfTestPassed() {
        cn.a(cg.a(), cc.a);
        return true;
    }

    public static boolean runSelfTests() throws JSAFE_InvalidUseException {
        if (!cq.f()) {
            throw new JSAFE_InvalidUseException(a);
        }
        cn.a(cg.a(), cc.a);
        return true;
    }

    public static boolean runSelfTests(FIPS140Context fIPS140Context) throws JSAFE_InvalidUseException {
        if (!cq.f()) {
            throw new JSAFE_InvalidUseException(a);
        }
        cn.a(fIPS140Context.ctx(), cc.a);
        return true;
    }

    public static boolean isInFIPS140Mode() {
        return cg.a().e();
    }

    public static boolean isInSSLMode() {
        return cg.a().f();
    }

    public static boolean isInECCMode() {
        return cg.a().g();
    }

    public static boolean notInFIPS140Mode() {
        return cg.a().h();
    }

    public static void checkIntegrity() {
    }

    public static FIPS140SecurityLevel getFIPS140SecurityLevel() {
        return FIPS140SecurityLevel.a();
    }

    public static boolean isFIPS140SecurityLevelOne() {
        return cq.i() == 1;
    }

    public static boolean isFIPS140SecurityLevelTwo() {
        return cq.i() == 2;
    }

    public static byte[][] initFIPS140RolePINs() throws JSAFE_InvalidUseException {
        try {
            return bz.a(null, null, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
        catch (bi bi2) {
            throw new JSAFE_InvalidUseException(bi2.getMessage());
        }
    }

    public static byte[][] initFIPS140RolePINs(Calendar calendar, Calendar calendar2) throws JSAFE_InvalidUseException {
        try {
            return bz.a(calendar, calendar2, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[][] initFIPS140RolePINs(File file) throws JSAFE_InvalidUseException {
        try {
            return bz.a(null, null, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[][] initFIPS140RolePINs(Calendar calendar, Calendar calendar2, File file) throws JSAFE_InvalidUseException {
        try {
            return bz.a(calendar, calendar2, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2) throws JSAFE_InvalidUseException {
        try {
            return bz.a(byArray, n2, null, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2, Calendar calendar) throws JSAFE_InvalidUseException {
        try {
            return bz.a(byArray, n2, calendar, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2, File file) throws JSAFE_InvalidUseException {
        try {
            return bz.a(byArray, n2, null, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2, Calendar calendar, File file) throws JSAFE_InvalidUseException {
        try {
            return bz.a(byArray, n2, calendar, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2) throws JSAFE_InvalidUseException {
        try {
            bz.a(byArray, n2, byArray2, null, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2, Calendar calendar) throws JSAFE_InvalidUseException {
        try {
            bz.a(byArray, n2, byArray2, calendar, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2, File file) throws JSAFE_InvalidUseException {
        try {
            bz.a(byArray, n2, byArray2, null, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2, Calendar calendar, File file) throws JSAFE_InvalidUseException {
        try {
            bz.a(byArray, n2, byArray2, calendar, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static String getFIPS140ModuleName() {
        return "RSA BSAFE Crypto-J JSAFE and JCE Software Module";
    }

    @Deprecated
    public static void fips186RandomClearQ(SecureRandom secureRandom) {
    }

    @Deprecated
    public static void fips186RandomSetQ(SecureRandom secureRandom, byte[] byArray) {
    }

    public static void setX931TestResult(byte[][] byArray) {
        d = new byte[byArray.length][];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            CryptoJ.d[i2] = dj.a(byArray[i2]);
        }
    }

    public static byte[][] getX931TestResult() {
        if (d == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[d.length][];
        for (int i2 = 0; i2 < d.length; ++i2) {
            if (d == null) continue;
            byArrayArray[i2] = dj.a(d[i2]);
            du.a.a(d[i2]);
            CryptoJ.d[i2] = null;
        }
        d = null;
        return byArrayArray;
    }

    @Deprecated
    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3) {
        return CryptoJ.verifyPQGParams(byArray, byArray2, n2, byArray3, byArray4, byArray5, n3, null);
    }

    @Deprecated
    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3, FIPS140Context fIPS140Context) {
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = new BigInteger(1, byArray3);
        BigInteger bigInteger3 = new BigInteger(1, byArray4);
        BigInteger bigInteger4 = byArray5 == null ? null : new BigInteger(1, byArray5);
        DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec = new DSADomainParameterGenerationSpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray, n3);
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, "SHA1", 2, null, fIPS140Context);
    }

    @Deprecated
    public static void setDiscardFirstBlockForCRNG(SecureRandom secureRandom, boolean bl2) {
    }

    public static void main(String[] stringArray) {
        JsafeJCE.main(stringArray);
    }
}

