/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider;

import com.rsa.jsafe.provider.HardwareIterator;
import com.rsa.jsafe.provider.HardwareStoreException;
import com.rsa.jsafe.provider.HardwareStoreSpi;
import com.rsa.jsafe.provider.JsafeJCEPKCS11;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.Certificate;

public class HardwareStore {
    private final HardwareStoreSpi a;
    private final Provider b;
    private final String c;

    protected HardwareStore(HardwareStoreSpi hardwareStoreSpi, Provider provider, String string) {
        this.a = hardwareStoreSpi;
        this.b = provider;
        this.c = string;
    }

    public HardwareIterator<Key> keyIterator(KeyIteratorParameters keyIteratorParameters) throws HardwareStoreException, IllegalArgumentException {
        return this.a.engineKeyIterator(keyIteratorParameters);
    }

    public HardwareIterator<Certificate> certificateIterator(CertIteratorParameters certIteratorParameters) throws HardwareStoreException, IllegalArgumentException {
        return this.a.engineCertificateIterator(certIteratorParameters);
    }

    public void setKey(byte[] byArray, String string, Key key) throws HardwareStoreException {
        this.a.setKey(byArray, string, key);
    }

    public void setCertificate(byte[] byArray, String string, Certificate certificate) throws HardwareStoreException {
        this.a.setCertificate(byArray, string, certificate);
    }

    public Provider getProvider() {
        return this.b;
    }

    public String getType() {
        return this.c;
    }

    public static HardwareStore getInstance(String string, JsafeJCEPKCS11 jsafeJCEPKCS11) throws NoSuchAlgorithmException {
        HardwareStoreSpi hardwareStoreSpi = (HardwareStoreSpi)jsafeJCEPKCS11.getService("HardwareStore", string).newInstance(new Object[]{null});
        return new HardwareStore(hardwareStoreSpi, jsafeJCEPKCS11, string);
    }

    public static interface CertIteratorParameters {
    }

    public static interface KeyIteratorParameters {
    }
}

