/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.profiles.attribute.x500;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class X500Attribute
extends Attribute {
    public X500Attribute(Element element) throws DOMException {
        super(element);
    }

    public X500Attribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public X500Attribute(Document owner) throws DOMException {
        super(owner);
        this.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.setX500Encoding("LDAP");
    }

    public void addAttributeValue(String[] attributeValues) {
        this.addAttributeValues(attributeValues);
    }

    public void addAttributeValue(byte[] attributeValue) {
        Text node = this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])attributeValue, (boolean)true));
        this.addAttributeValue(node, SAML2URI.encoding_xsitype_Base64Binary);
    }

    protected void setX500Encoding(String encoding) {
        String prefix = XMLElement.getDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:2.0:profiles:attribute:X500");
        if (prefix == null || prefix.length() < 1) {
            prefix = "x500prof";
        }
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "urn:oasis:names:tc:SAML:2.0:profiles:attribute:X500");
        this.setAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:X500", prefix + ":Encoding", encoding);
    }

    protected String getX500Encoding() {
        String encoding = this.getAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:X500", "Encoding");
        if (encoding != null && encoding.length() > 0) {
            return encoding;
        }
        return null;
    }

    public List getAttributeValueBytes() {
        List avList = SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        if (avList != null) {
            ArrayList<byte[]> byteList = new ArrayList<byte[]>(avList.size());
            int len = avList.size();
            for (int i = 0; i < len; ++i) {
                Element av = (Element)avList.get(i);
                QName avType = X500Attribute.getXsiType(av);
                if (!SAML2URI.encoding_xsitype_Base64Binary.equals((Object)avType)) continue;
                byteList.add(Base64.fromBase64((String)XMLUtils.collectText((Node)av)));
            }
            if (byteList.size() > 0) {
                return byteList;
            }
        }
        return null;
    }

    @Override
    public String getAttributeProfileID() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:attribute:X500";
    }
}

