/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConditionHelper {
    private static Logger _log = Logger.getLogger(ConditionHelper.class.getName());

    ConditionHelper() {
    }

    public static boolean hasCondPrereqs(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        for (TEdge outE : graph.getOutgoingEdges(vertex)) {
            VKey outKey = (VKey)((TVertex)outE.getDest()).getKey();
            VKey.VType prereqType = outKey.getType();
            if (((EKey)outE.getKey()).getType() == EKey.EType.CONFLICTS || prereqType != VKey.VType.OR_COND && prereqType != VKey.VType.AND_COND) continue;
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Found conditinal prerequisite " + outKey + " for vertex " + vKey);
            }
            return true;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Found no conditinal prerequisites for vertex " + vKey);
        }
        return false;
    }

    public static boolean isMultipleInstChoiceOr(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.OR_COND);
        int choiceCount = 0;
        for (TEdge outEdge : graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if ((((EKey)outEdge.getKey()).getType() != EKey.EType.CONFLICTS || outVKey.getInstalledState() == VKey.InstalledState.INSTALLED) && (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS || outVKey.getInstalledState() != VKey.InstalledState.INSTALLED && outVKey.getInstalledState() != VKey.InstalledState.COND_PREREQ_CANDIDATE)) continue;
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Found OR option " + outVKey);
            }
            ++choiceCount;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Found " + choiceCount + " possible option(s) for " + vKey);
        }
        return choiceCount > 1;
    }

    public static boolean hasCandidateInstPrereqs(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        for (TEdge outE : graph.getOutgoingEdges(vertex)) {
            VKey outKey = (VKey)((TVertex)outE.getDest()).getKey();
            if (((EKey)outE.getKey()).getType() == EKey.EType.CONFLICTS || outKey.getInstalledState() != VKey.InstalledState.COND_PREREQ_CANDIDATE) continue;
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Found conditinal prerequisite " + outKey + " for vertex " + vKey);
            }
            return true;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Found no conditinal prerequisites for vertex " + vKey);
        }
        return false;
    }

    public static boolean isOrSatisfied(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex) {
        return ConditionHelper.getNumSelOrOptions(graph, vertex) > 0;
    }

    public static boolean hasMultipleSelOptions(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex) {
        return ConditionHelper.getNumSelOrOptions(graph, vertex) > 1;
    }

    public static int getNumSelOrOptions(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.OR_COND);
        int selOptions = 0;
        for (TEdge outEdge : graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if ((((EKey)outEdge.getKey()).getType() != EKey.EType.CONFLICTS || outVKey.getInstalledState() != VKey.InstalledState.CONFLICTS_WITH_INSTALLED && outVKey.getSelectedState() != VKey.SelectedState.CONFLICTS && (outVKey.getSelectedState() != VKey.SelectedState.NOTSELECTED || outVKey.getInstalledState() == VKey.InstalledState.INSTALLED)) && (((EKey)outEdge.getKey()).getType() != EKey.EType.REQUIRES || outVKey.getInstalledState() != VKey.InstalledState.INSTALLED && outVKey.getSelectedState() != VKey.SelectedState.SELECTED)) continue;
            if (_log.isLoggable(Level.FINER)) {
                _log.finer("Found selected option " + outVKey + " for " + vKey);
            }
            ++selOptions;
        }
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Found " + selOptions + " selected options for " + vKey);
        }
        return selOptions;
    }
}

