/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

class PrereqsUnselector
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private List<TVertex> _unselectionCandidates = new ArrayList<TVertex>();

    PrereqsUnselector(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
    }

    public List<TVertex> getUnselectionCandidates() {
        return this._unselectionCandidates;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._unselectionCandidates.clear();
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        if (edge == null) {
            this.trace("UNSELECTING IMMEDIATE PREREQUISITES FOR UNSELECTED VERTEX <", vertex, ">");
        } else if (((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS) {
            this.trace("PROCESSING CONFLICT <", vertex, "> which conflicts with <" + edge.getSource(), ">");
        } else {
            this.trace("PROCESSING PREREQUISITE <", vertex, "> which depends on <" + edge.getSource(), ">");
        }
        VKey vKey = (VKey)vertex.getKey();
        if (edge != null && ((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS) {
            this.unmarkConflict(vertex);
            return false;
        }
        if (vKey.getType() == VKey.VType.TINFO) {
            if (edge == null) {
                return true;
            }
            if (vKey.getSelectedState() == VKey.SelectedState.SELECTED && !vKey.wasStateSetInOp() && !vKey.isExtSelectable()) {
                this.traceAction("UNSELECTION_CANDIDATE: adding not externally selectable prerequisite to unselection candidates ", vKey);
                this._unselectionCandidates.add(vertex);
            }
            return false;
        }
        if (vKey.getSelectedState() == VKey.SelectedState.SELECTED || vKey.getSelectedState() == VKey.SelectedState.PENDING_AND_COND) {
            vKey.setSelectedState(VKey.SelectedState.NOTSELECTED);
            this.traceAction("UNSELECT: unselecting intermediate vertex ", vKey);
            return true;
        }
        this.traceAction("NOACTION: Vertex is not selected ", vKey);
        return false;
    }

    private void unmarkConflict(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getType() == VKey.VType.UNRESOLVED) {
            this.traceAction("UNMARK_CONFLICT: reset the state for unresolved vertex ", vKey);
            vKey.setSelectedState(VKey.SelectedState.NOTSELECTED);
        } else if (vKey.getSelectedState() == VKey.SelectedState.CONFLICTS && !vKey.wasStateSetInOp()) {
            boolean hasConflicts = false;
            for (TEdge inEdge : this._graph.getIncomingEdges(vertex)) {
                TVertex inVtx = (TVertex)inEdge.getSource();
                VKey inKey = (VKey)inVtx.getKey();
                if (((EKey)inEdge.getKey()).getType() != EKey.EType.CONFLICTS || inKey.getSelectedState() != VKey.SelectedState.SELECTED || inKey.getType() == VKey.VType.OR_COND && ConditionHelper.hasMultipleSelOptions(this._graph, inVtx)) continue;
                this.traceAction("NOACTION: can't unmark conflicing vertex ", vKey, " as it still conflicts with ", inKey);
                hasConflicts = true;
                break;
            }
            if (!hasConflicts) {
                this.traceAction("UNMARK_CONFLICT: unmarking conflict which does not conflict with any other vertices ", vKey);
                vKey.setSelectedState(VKey.SelectedState.NOTSELECTED);
            }
        } else if (vKey.getSelectedState() != VKey.SelectedState.CONFLICTS) {
            this.traceAction("NOACTION: conflicting vertex is not marked as conflict ", vKey);
        } else if (vKey.wasStateSetInOp()) {
            this.traceAction("NOACTION: can't unmark conflicting vertex marked in the current session ", vKey);
        }
    }
}

