/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.graph;

import com.oracle.cie.dependency.graph.DirectedEdge;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.EdgeFilter;
import com.oracle.cie.dependency.graph.GraphPrePostVisitor;
import com.oracle.cie.dependency.graph.GraphVisitor;
import com.oracle.cie.dependency.graph.Vertex;
import java.util.LinkedList;
import java.util.List;

public class DirectedGraphHelper {
    public static <VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, GV extends GraphVisitor<VK, V, EK, E, G>, G extends DirectedGraph<VK, V, EK, E>> void breadthFirstEdgeTraversal(G graph, GV visitor, V start, boolean direct) {
        DirectedGraphHelper.breadthFirstEdgeTraversal(graph, visitor, start, direct, null);
    }

    public static <VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, GV extends GraphVisitor<VK, V, EK, E, G>, G extends DirectedGraph<VK, V, EK, E>> void breadthFirstEdgeTraversal(G graph, GV visitor, V start, boolean direct, EdgeFilter<VK, V, EK, E, G> filter) {
        if (graph == null || visitor == null || start == null) {
            throw new IllegalArgumentException("At least one of the parameters is missing.");
        }
        for (Vertex v : graph.getVertices()) {
            v.setColor(Vertex.Color.W);
        }
        visitor.preOp(graph);
        LinkedList<DirectedEdge> eQueue = new LinkedList<DirectedEdge>();
        start.setColor(Vertex.Color.G);
        eQueue.addLast(null);
        while (!eQueue.isEmpty()) {
            V v;
            DirectedEdge e = (DirectedEdge)eQueue.removeFirst();
            Object object = e == null ? start : (v = direct ? (Vertex)e.getDest() : (Vertex)e.getSource());
            if (visitor.visit((DirectedEdge)e, v)) {
                List<E> edges;
                List<E> list = edges = direct ? graph.getOutgoingEdges(v) : graph.getIncomingEdges(v);
                if (filter != null) {
                    edges = filter.filter(graph, v, edges);
                }
                for (DirectedEdge outE : edges) {
                    Vertex outV = direct ? (Vertex)outE.getDest() : (Vertex)outE.getSource();
                    if (outV.getColor() != Vertex.Color.W) continue;
                    outV.setColor(Vertex.Color.G);
                    eQueue.addLast(outE);
                }
            }
            visitor.postOp(graph);
        }
    }

    public static <VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, GV extends GraphPrePostVisitor<VK, V, EK, E, G>, G extends DirectedGraph<VK, V, EK, E>> void depthFirstEdgeTraversal(G graph, GV visitor, V start, boolean direct) {
        DirectedGraphHelper.depthFirstEdgeTraversal(graph, visitor, start, direct, null);
    }

    public static <VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, GV extends GraphPrePostVisitor<VK, V, EK, E, G>, G extends DirectedGraph<VK, V, EK, E>> void depthFirstEdgeTraversal_old(G graph, GV visitor, V start, boolean direct, EdgeFilter<VK, V, EK, E, G> filter) {
        if (graph == null || visitor == null || start == null) {
            throw new IllegalArgumentException("At least one of the parameters is missing.");
        }
        for (Vertex v : graph.getVertices()) {
            v.setColor(Vertex.Color.W);
        }
        visitor.preOp(graph);
        LinkedList<DirectedEdge> eStack = new LinkedList<DirectedEdge>();
        start.setColor(Vertex.Color.G);
        eStack.addFirst(null);
        while (!eStack.isEmpty()) {
            V v;
            DirectedEdge e = (DirectedEdge)eStack.removeFirst();
            Object object = e == null ? start : (v = direct ? (Vertex)e.getDest() : (Vertex)e.getSource());
            if (v.getColor() == Vertex.Color.G) {
                List<E> edges;
                v.setColor(Vertex.Color.R);
                eStack.addFirst(e);
                if (!visitor.preVisit((DirectedEdge)e, v)) continue;
                List<E> list = edges = direct ? graph.getOutgoingEdges(v) : graph.getIncomingEdges(v);
                if (filter != null) {
                    edges = filter.filter(graph, v, edges);
                }
                for (DirectedEdge outE : edges) {
                    Vertex outV = direct ? (Vertex)outE.getDest() : (Vertex)outE.getSource();
                    if (outV.getColor() != Vertex.Color.W) continue;
                    outV.setColor(Vertex.Color.G);
                    eStack.addFirst(outE);
                }
                continue;
            }
            visitor.postVisit((DirectedEdge)e, v);
        }
        visitor.postOp(graph);
    }

    public static <VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, GV extends GraphPrePostVisitor<VK, V, EK, E, G>, G extends DirectedGraph<VK, V, EK, E>> void depthFirstEdgeTraversal(G graph, GV visitor, V start, boolean direct, EdgeFilter<VK, V, EK, E, G> filter) {
        if (graph == null || visitor == null || start == null) {
            throw new IllegalArgumentException("At least one of the parameters is missing.");
        }
        for (DirectedEdge e : graph.getEdges()) {
            e.setColor(DirectedEdge.Color.W);
        }
        visitor.preOp(graph);
        DirectedEdge.Color flag = DirectedEdge.Color.W;
        LinkedList<DirectedEdge> eStack = new LinkedList<DirectedEdge>();
        eStack.addFirst(null);
        while (!eStack.isEmpty()) {
            V v;
            DirectedEdge e = (DirectedEdge)eStack.removeFirst();
            Object object = e == null ? start : (v = direct ? (Vertex)e.getDest() : (Vertex)e.getSource());
            if (e == null && flag == DirectedEdge.Color.W || e != null && e.getColor() == DirectedEdge.Color.W) {
                List<E> edges;
                eStack.addFirst(e);
                if (e != null) {
                    e.setColor(DirectedEdge.Color.G);
                } else {
                    flag = DirectedEdge.Color.G;
                }
                if (!visitor.preVisit((DirectedEdge)e, v)) continue;
                List<E> list = edges = direct ? graph.getOutgoingEdges(v) : graph.getIncomingEdges(v);
                if (filter != null) {
                    edges = filter.filter(graph, v, edges);
                }
                for (DirectedEdge outE : edges) {
                    if (outE.getColor() != DirectedEdge.Color.W) continue;
                    eStack.addFirst(outE);
                }
                continue;
            }
            visitor.postVisit((DirectedEdge)e, v);
        }
        visitor.postOp(graph);
    }

    public static <VK, V extends Vertex<VK>, EK, E extends DirectedEdge<V, EK>, GV extends GraphVisitor<VK, V, EK, E, G>, G extends DirectedGraph<VK, V, EK, E>> void breadthFirstEdgeTraversal2(G graph, GV visitor, V start, boolean direct, EdgeFilter<VK, V, EK, E, G> filter) {
        if (graph == null || visitor == null || start == null) {
            throw new IllegalArgumentException("At least one of the parameters is missing.");
        }
        for (DirectedEdge e : graph.getEdges()) {
            e.setColor(DirectedEdge.Color.W);
        }
        visitor.preOp(graph);
        DirectedEdge.Color flag = DirectedEdge.Color.W;
        LinkedList<DirectedEdge> eQueue = new LinkedList<DirectedEdge>();
        eQueue.addFirst(null);
        while (!eQueue.isEmpty()) {
            List<E> edges;
            V v;
            DirectedEdge e = (DirectedEdge)eQueue.removeFirst();
            Object object = e == null ? start : (v = direct ? (Vertex)e.getDest() : (Vertex)e.getSource());
            if ((e != null || flag != DirectedEdge.Color.W) && (e == null || e.getColor() != DirectedEdge.Color.W)) continue;
            if (e != null) {
                e.setColor(DirectedEdge.Color.G);
            } else {
                flag = DirectedEdge.Color.G;
            }
            if (!visitor.visit((DirectedEdge)e, v)) continue;
            List<E> list = edges = direct ? graph.getOutgoingEdges(v) : graph.getIncomingEdges(v);
            if (filter != null) {
                edges = filter.filter(graph, v, edges);
            }
            for (DirectedEdge outE : edges) {
                if (outE.getColor() != DirectedEdge.Color.W) continue;
                eQueue.addLast(outE);
            }
        }
        visitor.postOp(graph);
    }
}

