/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.validation;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import model.BaseClass;
import model.common.AbstractBaseTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleUtils {
    public static String getMessage(Class clazz, String string, Object ... objectArray) throws MissingResourceException {
        String string2 = BundleUtils.getBundle(clazz).getString(string);
        if (string2 == null) {
            return null;
        }
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    private static ResourceBundle getBundle(Class clazz) throws MissingResourceException {
        String string = clazz.getPackage().getName() + ".Bundle";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), clazz.getClassLoader());
        return resourceBundle;
    }

    public static String makeStringOutOfList(List<BaseClass> list) {
        String string = "\n";
        for (BaseClass baseClass : list) {
            AbstractBaseTarget abstractBaseTarget = (AbstractBaseTarget)baseClass;
            string = string + "\t" + abstractBaseTarget.getName() + "\n";
        }
        return string;
    }

    public static String makeStringForFailedResultMap(Map<AbstractBaseTarget, List<Method>> map) {
        String string = "\n";
        for (AbstractBaseTarget abstractBaseTarget : map.keySet()) {
            string = string + "\n\t" + abstractBaseTarget.getClass().getSimpleName() + "{" + abstractBaseTarget.getName() + "}:";
            for (Method method : map.get(abstractBaseTarget)) {
                String string2 = method.getName();
                string2 = string2.startsWith("get") ? string2.substring(3) : string2;
                string = string + "\n\t\t" + string2;
            }
        }
        return string;
    }
}

