/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff.handlers;

import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.common.util.FileDiff;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.JarDiff;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TextDiffHandler
implements JarDiff.DiffHandler {
    private Map<String, Pattern> _typeFilePatternMap;
    private DiffReport _report;

    public TextDiffHandler(DiffReport report) {
        this._report = report;
        this._typeFilePatternMap = new HashMap<String, Pattern>();
    }

    public void addTypePattern(String type, Pattern pattern) {
        Pattern extensionPattern = this._typeFilePatternMap.get(type);
        if (extensionPattern != null) {
            Pattern merge = Pattern.compile("(" + extensionPattern.pattern() + ")|(" + pattern.pattern() + ")");
            this._typeFilePatternMap.put(type, merge);
        } else {
            this._typeFilePatternMap.put(type, pattern);
        }
    }

    public boolean isHandled(File jarFile, String entryName) throws CarbDiffException {
        return this.isHandled(entryName);
    }

    public boolean isHandled(JarHelper jarHandler, String entryName) throws CarbDiffException {
        return this.isHandled(entryName);
    }

    private boolean isHandled(String entryName) throws CarbDiffException {
        if (StringUtil.isNullOrEmpty((String)entryName)) {
            throw new CarbDiffException("The entry name is not provided.");
        }
        if (entryName.lastIndexOf(".") == -1) {
            return false;
        }
        String extension = this.getExtension(entryName);
        if (StringUtil.isNullOrEmpty((String)extension)) {
            return false;
        }
        return this._typeFilePatternMap.containsKey(extension);
    }

    private String getExtension(String entryName) {
        return entryName.substring(entryName.lastIndexOf(".") + 1);
    }

    public boolean diff(String entryName, File file1, File file2) throws Exception {
        boolean isDifferent;
        Pattern pattern = this._typeFilePatternMap.get(this.getExtension(file1.getName()));
        if (pattern != null && !StringUtil.isNullOrEmpty((String)pattern.pattern())) {
            isDifferent = !FileUtils.areFilesEqual((File)file1, (File)file2, (Pattern)pattern);
        } else {
            boolean bl = isDifferent = !FileUtils.areFilesEqual((File)file1, (File)file2);
        }
        if (this._report != null && isDifferent) {
            this._report.addDiff(entryName, FileDiff.diff((File)file1, (File)file2, (boolean)this._report.getShowBinaryDiff()), null);
        }
        return isDifferent;
    }

    public void setDiffReport(DiffReport report) {
        this._report = report;
    }
}

