/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import java.nio.file.Path;

public class ArtifactFile
extends AbstractDataHandlerWrapper {
    public ArtifactFile(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public ArtifactFile() {
        super(ComponentHelper.getInstance().create("artifact-fileType"));
    }

    public ArtifactFile(Path location, String type) {
        this();
        this.setLocation(location.toString());
        this.setType(type);
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public String getLocation() {
        return this.getStringAttribute("location");
    }

    public String getRegex() {
        return this.getStringAttribute("regex");
    }

    public String getType() {
        return this.getStringAttribute("type");
    }

    public int hashCode() {
        String location = this.getLocation();
        String regex = this.getRegex();
        String type = this.getType();
        int result = location != null ? location.hashCode() : 0;
        result = regex != null ? regex.hashCode() : 0;
        result = type != null ? type.hashCode() : 0;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return false;
        }
        ArtifactFile artifactFile = (ArtifactFile)((Object)o);
        String location = this.getLocation();
        String regex = this.getRegex();
        String type = this.getType();
        String theirLocation = artifactFile.getLocation();
        String theirRegex = artifactFile.getRegex();
        String theirType = artifactFile.getType();
        return !(location != null && theirLocation != null && !location.equals(theirLocation) || regex != null && theirRegex != null && !regex.equals(theirRegex)) && (type == null || theirType == null || type.equals(theirType));
    }

    public boolean matches(String dest) {
        if (this.getLocation() != null && this.getLocation().equals(dest)) {
            return true;
        }
        return this.getRegex() != null && dest.matches(this.getRegex());
    }
}

