/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.lbm;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.lbm.LabelMapReference;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ComponentMapping
extends AbstractDataHandlerWrapper {
    public ComponentMapping(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public ComponentMapping() {
        this(LabelMapHelper.getInstance().create("http://xmlns.oracle.com/cie/gdr/lbm", "component-mapping"));
    }

    public ComponentMapping(ComponentMapping mapping) {
        this();
        this.setSeries(mapping.getSeries());
        this.setProduct(mapping.getProduct());
        this.setLabel(mapping.getLabel());
    }

    public List<LabelMapReference> getComponents() {
        return this.getComplexValueWrappedList("component", LabelMapReference.class);
    }

    public void setComponents(List<LabelMapReference> components) {
        this.setComplexValueWrappedList("component", components);
    }

    public String getSeries() {
        return this.getStringAttribute("series");
    }

    public void setSeries(String series) {
        this.setAttribute("series", series);
    }

    public String getProduct() {
        return this.getStringAttribute("product");
    }

    public void setProduct(String product) {
        this.setAttribute("product", product);
    }

    public String getLabel() {
        return this.getStringAttribute("label");
    }

    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    public String toString() {
        String series = this.getSeries();
        String product = this.getProduct();
        String label = this.getLabel();
        String s = "";
        if (series != null) {
            s = s + "series=" + series;
        }
        if (product != null) {
            s = s + " product=" + product;
        }
        if (label != null) {
            s = s + " label=" + label;
        }
        return s.trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ComponentMapping that = (ComponentMapping)((Object)o);
        String thisLabel = this.getLabel();
        String thisProduct = this.getProduct();
        String thisSeries = this.getSeries();
        String thatLabel = that.getLabel();
        String thatProduct = that.getProduct();
        String thatSeries = that.getSeries();
        if (thisLabel != null ? !thisLabel.equals(thatLabel) : thatLabel != null) {
            return false;
        }
        if (thisProduct != null ? !thisProduct.equals(thatProduct) : thatProduct != null) {
            return false;
        }
        return !(thisSeries != null ? !thisSeries.equals(thatSeries) : thatSeries != null);
    }

    public int hashCode() {
        String label = this.getLabel();
        String product = this.getProduct();
        String series = this.getSeries();
        int result = series != null ? series.hashCode() : 0;
        result = 31 * result + (product != null ? product.hashCode() : 0);
        result = 31 * result + (label != null ? label.hashCode() : 0);
        return result;
    }

    public void addComponent(LabelMapReference reference) {
        if (reference != null) {
            List<LabelMapReference> components = this.getComponents();
            if (components == null) {
                components = new ArrayList<LabelMapReference>();
            }
            components.add(reference);
            this.setComponents(components);
        }
    }

    public void removeComponent(Reference reference) {
        if (reference != null) {
            boolean removed = false;
            List<LabelMapReference> components = this.getComponents();
            if (components != null && !components.isEmpty()) {
                Iterator<LabelMapReference> it = components.iterator();
                while (it.hasNext()) {
                    LabelMapReference labelMapReference = it.next();
                    if (!reference.getName().equals(labelMapReference.getName()) || !reference.getVersion().equals(labelMapReference.getVersion())) continue;
                    it.remove();
                    removed = true;
                }
            }
            if (removed) {
                this.setComponents(components);
            }
        }
    }
}

