/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.pad;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.dao.pad.Artifact;
import com.oracle.cie.gdr.helpers.PatchArtifactDefinitionHelper;

public class ArtifactInfo
extends AbstractDataHandlerWrapper {
    public ArtifactInfo() {
        this(PatchArtifactDefinitionHelper.getInstance().create("carb-info"));
    }

    public ArtifactInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public Artifact getBaseArtifact() {
        return (Artifact)((Object)this.getSingleOccuranceComplexValueWrapped("base-artifact", Artifact.class));
    }

    public void setBaseArtifact(Artifact baseArtifact) {
        this.setSingleOccuranceComplexValueWrapped("base-artifact", (IDataHandlerWrapper)baseArtifact);
    }

    public Artifact getPatchedArtifact() {
        return (Artifact)((Object)this.getSingleOccuranceComplexValueWrapped("patched-artifact", Artifact.class));
    }

    public void setPatchedArtifact(Artifact patchedArtifact) {
        this.setSingleOccuranceComplexValueWrapped("patched-artifact", (IDataHandlerWrapper)patchedArtifact);
    }

    public Artifact getReleasedArtifact() {
        return (Artifact)((Object)this.getSingleOccuranceComplexValueWrapped("released-artifact", Artifact.class));
    }

    public boolean isDeleted() {
        return this.getBooleanAttribute("delete");
    }

    public void setDelete(boolean delete) {
        this.setAttribute("delete", delete);
    }

    public boolean baseArtifactMatches(ArtifactInfo artifactInfo) {
        if (artifactInfo != null) {
            Artifact thisBaseArtifact = this.getBaseArtifact();
            Artifact thatBaseArtifact = artifactInfo.getBaseArtifact();
            if (thisBaseArtifact != null && thatBaseArtifact != null) {
                String thisGroup = thisBaseArtifact.getGroupId();
                String thatGroup = thatBaseArtifact.getGroupId();
                if (thisGroup != null && thisGroup.equals(thatGroup)) {
                    Version thatVersion;
                    Version thisVersion;
                    String thisArtifactId = thisBaseArtifact.getArtifactId();
                    String thatArtifactId = thatBaseArtifact.getArtifactId();
                    if (thisArtifactId != null && thisArtifactId.equals(thatArtifactId) && (thisVersion = DependencyManagementFactory.getInstance().getVersion(thisBaseArtifact.getVersion())).equalsBase((Object)(thatVersion = DependencyManagementFactory.getInstance().getVersion(thatBaseArtifact.getVersion())))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

