/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.rgy;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.rgy.BaseInfoImpl;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import java.util.Calendar;

public class PatchInfo
extends BaseInfoImpl {
    public PatchInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public PatchInfo(ClassLoader classLoader) {
        this(RegistryHelper.getInstance(classLoader).create("patch-info"));
    }

    public PatchInfo(ClassLoader classLoader, String patchId) {
        this(classLoader);
        this.setPatchId(patchId);
    }

    public Calendar getInstallDate() {
        return this.getCalendarAttribute("install-date");
    }

    public void setInstallDate(Calendar date) {
        this.setAttribute("install-date", date);
    }

    public void setPatchId(String patchId) {
        this.setAttribute("patch-id", patchId);
    }

    public String getPatchId() {
        return this.getStringAttribute("patch-id");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !PatchInfo.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        PatchInfo patchInfo = (PatchInfo)o;
        String patchId = this.getPatchId();
        String otherPatchId = patchInfo.getPatchId();
        return !(patchId == null ? otherPatchId != null : !patchId.equals(otherPatchId));
    }

    public int hashCode() {
        String name = this.getPatchId();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result;
        return result;
    }

    public String toString() {
        return this.getPatchId();
    }
}

