/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.builder.impl;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandlerWrapper;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.di.Platform;
import com.oracle.cie.gdr.dao.di.Platforms;
import com.oracle.cie.gdr.dao.di.ProductFamily;
import com.oracle.cie.gdr.dao.di.Property;
import com.oracle.cie.gdr.dao.di.Section;
import com.oracle.cie.gdr.dao.di.Sections;
import com.oracle.cie.gdr.external.builder.BuilderException;
import com.oracle.cie.gdr.external.builder.DistributionInfoBuilder;
import com.oracle.cie.gdr.external.builder.SectionBuilder;
import com.oracle.cie.gdr.external.builder.impl.SectionBuilderImpl;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DistributionInfoBuilderImpl
implements DistributionInfoBuilder {
    private List<Section> _sectionList = new ArrayList<Section>();
    private DistributionInfo _distributionInfo;
    private List<Property> _shiphomeProperties = new ArrayList<Property>();

    public DistributionInfoBuilderImpl(String name, String version) throws BuilderException {
        if (StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            throw new BuilderException("The distribution-info name was null or empty.");
        }
        if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
            throw new BuilderException("The distribution-info version was null or empty.");
        }
        this._distributionInfo = new DistributionInfo(name, version);
    }

    @Override
    public void addShiphomeProperty(String name, String[] values) {
        Property property = new Property(name);
        property.setValues(values);
        this._shiphomeProperties.add(property);
    }

    @Override
    public void addSection(SectionBuilder section) {
        this._sectionList.add(((SectionBuilderImpl)section).getSection());
    }

    @Override
    public void setPlatforms(List<String> platforms, String generateDefaultOraparam) {
        if (platforms != null && !platforms.isEmpty()) {
            ArrayList<Platform> platformList = new ArrayList<Platform>();
            for (String platformString : platforms) {
                platformList.add(new Platform(platformString));
            }
            Platforms platformsDao = new Platforms();
            if (!StringUtil.isNullOrEmpty((String)generateDefaultOraparam)) {
                platformsDao.setGenerateDefaultOraparam(Boolean.valueOf(generateDefaultOraparam).booleanValue());
            }
            platformsDao.setPlatforms(platformList);
            this._distributionInfo.setPlatforms(Arrays.asList(platformsDao));
        }
    }

    @Override
    public void setProductFamilies(List<String> productFamilies) {
        if (productFamilies != null && !productFamilies.isEmpty()) {
            ArrayList<ProductFamily> productFamiliesList = new ArrayList<ProductFamily>();
            for (String productFamily : productFamilies) {
                productFamiliesList.add(new ProductFamily(productFamily));
            }
            this._distributionInfo.setProductFamilies(productFamiliesList);
        }
    }

    @Override
    public void save(File directory) throws BuilderException {
        if (directory == null) {
            throw new BuilderException("The specified save location was null.");
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new BuilderException("The specified save location was not a directory " + directory);
        }
        this.prepareToSave();
        File distributionInfoDir = new File(directory, DistributionInfoHelper.getInstance().getPath());
        if (!distributionInfoDir.exists()) {
            distributionInfoDir.mkdirs();
        }
        File distributionFile = new File(distributionInfoDir, DistributionInfoHelper.getInstance().getDistributionInfoFileName(this._distributionInfo));
        try {
            DistributionInfoHelper.getInstance().save((IDataHandlerWrapper)this._distributionInfo, distributionFile);
        }
        catch (DataHandlerException e) {
            throw new BuilderException("Failed to save distribution file to " + distributionFile, e);
        }
    }

    private void prepareToSave() {
        if (!this._sectionList.isEmpty()) {
            Sections sections = new Sections();
            sections.setSections(this._sectionList);
            this._distributionInfo.setSections(Arrays.asList(sections));
        }
        if (!this._shiphomeProperties.isEmpty()) {
            this._distributionInfo.setProperties(this._shiphomeProperties);
        }
    }
}

