/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.cloud.impl;

import com.oracle.cie.gdr.external.cloud.CloudException;
import com.oracle.cie.gdr.external.cloud.ProductLayer;
import com.oracle.cie.gdr.external.cloud.ProductLayersDefinition;
import com.oracle.cie.gdr.external.cloud.impl.ProductLayerImpl;
import com.oracle.cie.gdr.external.cloud.impl.ProductLayersDefinitionImpl;
import com.oracle.cie.gdr.repository.RepositoryProcessor;
import com.oracle.cie.repository.common.NextGenHelper;
import com.oracle.cie.repository.common.NextGenHelperFactory;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.resolver.RepositoryVersionResolver;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import com.oracle.cie.rest.impl.RepositoryImpl;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ProductLayersDefinitionFactoryImpl {
    private RepoCommonConfig _repoCommonConfig;
    private RepositoryVersionResolver _versionResolver;
    private RepositoryProcessor _repositoryProcessor;
    private RestHandler _restHandler = RestFactory.getRestHandler();
    private NextGenHelper _nextGenHelper = NextGenHelperFactory.getNextGenHelper((RestHandler)this._restHandler);

    private List<Repository> getRepositories(List<URL> urls, String username, String password, File localCacheRepo) {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (urls != null) {
            for (URL url : urls) {
                repositories.add((Repository)new RepositoryImpl(null, RepositoryType.REMOTE, url.toString(), null, username, password));
            }
        }
        return repositories;
    }

    public ProductLayersDefinition getProductLayersDefinition(String name, String version) throws CloudException {
        return this.getProductLayersDefinition(name, version, null, null);
    }

    public ProductLayersDefinition getProductLayersDefinition(String name, String version, File localCacheRepo) throws CloudException {
        return this.getProductLayersDefinition(name, version, null, localCacheRepo, null);
    }

    public ProductLayersDefinition getProductLayersDefinition(String name, String version, List<URL> urls, File localCacheRepo, Properties properties) throws CloudException {
        List<Repository> repositories = this.getRepositories(urls, null, null, localCacheRepo);
        ProductLayersDefinitionImpl pld = null;
        try {
            this._repoCommonConfig = RepoCommonConfig.createRepoCommonConfig(repositories, (File)localCacheRepo, (Properties)properties, null);
            if (!this._repoCommonConfig.hasProperty("USE_LATEST")) {
                this._repoCommonConfig.setProperty("USE_LATEST", "true");
            }
            this._versionResolver = this._nextGenHelper.getConfiguredRepositoryVersionResolver(this._repoCommonConfig);
            this._repositoryProcessor = new RepositoryProcessor(this._restHandler, this._versionResolver, null, repositories, false);
            pld = new ProductLayersDefinitionImpl(this._repositoryProcessor.getProductLayersDefinition(name, version));
        }
        catch (Exception anyException) {
            throw new CloudException(anyException);
        }
        return pld;
    }

    public ProductLayersDefinition getProductLayersDefinition(String name, String version, File localCacheRepo, Properties properties) throws CloudException {
        return this.getProductLayersDefinition(name, version, null, localCacheRepo, properties);
    }

    public ProductLayer getProductLayer(com.oracle.cie.gdr.dao.pld.ProductLayer productLayer) {
        return new ProductLayerImpl(productLayer);
    }
}

