/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.external.impl;

import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.pch.Locale;
import com.oracle.cie.gdr.dao.pch.PatchDependencies;
import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.Patch;
import com.oracle.cie.gdr.external.impl.ComponentImpl;
import com.oracle.cie.gdr.external.impl.InventoryCache;
import com.oracle.cie.gdr.selection.Status;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatchImpl
implements Patch {
    private com.oracle.cie.gdr.dao.pch.Patch _patch;
    private MetaDataHome _metaDataHome;
    private Mode _mode;

    PatchImpl(com.oracle.cie.gdr.dao.pch.Patch patch, MetaDataHome metaDataHome, Mode mode) {
        this._patch = patch;
        this._metaDataHome = metaDataHome;
        this._mode = mode;
    }

    @Override
    public String getPatchId() {
        return this._patch.getPatchId();
    }

    @Override
    public boolean isRollback() {
        return this._patch.isRollbackable();
    }

    @Override
    public List<String> getBugList() {
        return Arrays.asList(this._patch.getBugList().getBugs());
    }

    @Override
    public List<Component> getComponents() throws InventoryException {
        return this.getComponents(this._patch.getComponents());
    }

    List<Component> getComponents(List<ComponentReference> componentRefs) throws InventoryException {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ComponentReference componentRef : componentRefs) {
            Component cachedComponent = InventoryCache.getInstance().getComponent(this._metaDataHome, componentRef.getName(), componentRef.getVersion());
            if (null == cachedComponent) {
                cachedComponent = ComponentImpl.newInstance(componentRef.getName(), componentRef.getVersion(), this._metaDataHome, this._mode);
                InventoryCache.getInstance().putComponent(this._metaDataHome, cachedComponent);
            }
            components.add(cachedComponent);
        }
        return components;
    }

    @Override
    public String getLocation() {
        return this._patch.getLocation();
    }

    @Override
    public Status getStatus() {
        return this._patch.getStatus();
    }

    @Override
    public String getUniquePatchId() {
        return this._patch.getUniquePatchId();
    }

    @Override
    public List<String> getPatchDependencies() {
        PatchDependencies dependencies = this._patch.getPatchDependencies();
        if (dependencies == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(dependencies.getPatchIds());
    }

    @Override
    public List<java.util.Locale> getLocales() {
        ArrayList<java.util.Locale> locales = new ArrayList<java.util.Locale>();
        if (this._patch.getLocales() != null && !this._patch.getLocales().isEmpty()) {
            for (Locale locale : this._patch.getLocales()) {
                locales.add(new java.util.Locale(locale.getLanguage(), locale.getCountry()));
            }
        }
        return locales;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        Patch that = (Patch)o;
        String thisPatchId = this.getPatchId();
        String thisUniquePatchId = this.getUniquePatchId();
        String thatPatchId = that.getPatchId();
        String thatUniquePatchId = that.getUniquePatchId();
        return !(thisPatchId == null ? thatPatchId != null : !thisPatchId.equals(thatPatchId)) && !(thisUniquePatchId == null ? thatUniquePatchId != null : !thisUniquePatchId.equals(thatUniquePatchId));
    }

    public int hashCode() {
        String thisPatchId = this.getPatchId();
        String thisUniquePatchId = this.getUniquePatchId();
        int result = thisPatchId != null ? thisPatchId.hashCode() : 0;
        result = 31 * result + (thisUniquePatchId != null ? thisUniquePatchId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getPatchId() + " " + this.getUniquePatchId();
    }
}

