/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.helpers;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.libraries.LibraryException;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.patch.PatchHandlerFactory;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RegenerationHelper {
    public static final String TEMPINVENTORY_DIR = "tempInventory";
    private static RegenerationHelper _instance;
    private Set<Component> _modifiedComponents = new LinkedHashSet<Component>();
    private Set<Component> _pomComponentsToRegenerate;
    private Set<FeatureSet> _modifiedFeatureSets = new LinkedHashSet<FeatureSet>();
    private Set<FeatureSet> _pomFeatureSetsToRegenerate;
    private Map<Path, Set<String>> _modifiedFiles;
    public static final String PATCH_DIR = "patches";
    private boolean _queryMode = false;
    private Map<Path, Set<Path>> _filesToRegenerate;
    private boolean _regenerateAllFiles = false;
    private Set<LibraryType> targetLibraryTypes;
    private Map<Path, Path> _patchRollbackBackupPaths = new LinkedHashMap<Path, Path>();

    private RegenerationHelper() {
        this.init();
    }

    private void init() {
        if (!this.isRollbackQuery()) {
            this._modifiedComponents.clear();
            this._modifiedFeatureSets.clear();
        }
        this._filesToRegenerate = new LinkedHashMap<Path, Set<Path>>();
        this._pomComponentsToRegenerate = new LinkedHashSet<Component>();
        this._pomFeatureSetsToRegenerate = new LinkedHashSet<FeatureSet>();
        this._modifiedFiles = new LinkedHashMap<Path, Set<String>>();
        this._regenerateAllFiles = false;
    }

    public static RegenerationHelper getInstance() {
        if (_instance == null) {
            _instance = new RegenerationHelper();
        }
        return _instance;
    }

    public static void setUp(Map<Path, Set<String>> modifiedFiles, boolean queryMode, String targetLibraryType) throws DataHandlerException, GdrException, IOException {
        RegenerationHelper.getInstance().setModifiedFiles(modifiedFiles);
        _instance.setQueryMode(queryMode);
        _instance.setTargetLibraryType(targetLibraryType);
    }

    public Set<Component> getModifiedComponents() {
        return this._modifiedComponents;
    }

    public void addModifiedComponents(Map<String, Set<Component>> modifiedComponents) {
        if (modifiedComponents != null && !modifiedComponents.isEmpty()) {
            for (Set<Component> components : modifiedComponents.values()) {
                this._modifiedComponents.addAll(components);
            }
        }
    }

    public void addModifiedComponents(Set<Component> modifiedComponents) {
        if (modifiedComponents != null && !modifiedComponents.isEmpty()) {
            this._modifiedComponents.addAll(modifiedComponents);
        }
    }

    public Set<FeatureSet> getModifiedFeatureSets() {
        return this._modifiedFeatureSets;
    }

    public void addModifiedFeatureSets(Map<String, Set<FeatureSet>> modifiedFeatureSets) {
        if (modifiedFeatureSets != null && !modifiedFeatureSets.isEmpty()) {
            for (Set<FeatureSet> modifiedFeatures : modifiedFeatureSets.values()) {
                this._modifiedFeatureSets.addAll(modifiedFeatures);
            }
        }
    }

    public void addModifiedFeatureSets(Set<FeatureSet> modifiedFeatureSets) {
        if (modifiedFeatureSets != null && !modifiedFeatureSets.isEmpty()) {
            this._modifiedFeatureSets.addAll(modifiedFeatureSets);
        }
    }

    public Set<Component> getPomComponentsToRegenerate() {
        return this._pomComponentsToRegenerate;
    }

    public void addPomComponentToRegenerate(Component pomComponent) {
        if (pomComponent != null) {
            this._pomComponentsToRegenerate.add(pomComponent);
        }
    }

    public Set<FeatureSet> getPomFeatureSetsToRegenerate() {
        return this._pomFeatureSetsToRegenerate;
    }

    public void addPomFeatureSetToRegenerate(FeatureSet pomFeatureSet) throws GdrException, IOException, DataHandlerException {
        if (pomFeatureSet != null) {
            this._pomFeatureSetsToRegenerate.add(pomFeatureSet);
        }
    }

    public void setModifiedFiles(Map<Path, Set<String>> modifiedFiles) {
        this.init();
        this._modifiedFiles = modifiedFiles;
        if (modifiedFiles.keySet().size() == 1 && modifiedFiles.keySet().contains(NioHelper.getInstance().getPath("all", new String[0]))) {
            this._regenerateAllFiles = true;
        }
    }

    public Map<Path, Set<String>> getModifiedFiles() {
        return this._modifiedFiles;
    }

    public boolean needToRegenerateAllFiles() {
        return this._regenerateAllFiles;
    }

    public boolean regenerateType(LibraryType type) {
        return this.targetLibraryTypes == null || this.targetLibraryTypes.contains((Object)type);
    }

    public void setTargetLibraryType(String targetLibraryType) {
        if (!StringUtil.isNullOrEmpty((String)targetLibraryType)) {
            this.targetLibraryTypes = new LinkedHashSet<LibraryType>();
            this.targetLibraryTypes.add(LibraryType.valueOf(targetLibraryType));
        } else {
            this.targetLibraryTypes = null;
        }
    }

    public void rollBackMetadata(Path oracleHome, String patchID) throws LibraryException {
        HashSet<String> patchIDs = new HashSet<String>(Arrays.asList(patchID));
        this.rollBackMetadata(oracleHome, patchIDs);
    }

    public void rollBackMetadata(Path oracleHome, Set<String> patchIDs) throws LibraryException {
        try {
            PatchHandlerFactory.getPatchHandler(oracleHome).processUpdatePatch(patchIDs, true, RegenerationHelper.getInstance());
        }
        catch (Exception e) {
            throw new LibraryException("Failed to rollback inventory patches for patch IDs" + patchIDs + " from home " + oracleHome, e);
        }
    }

    public boolean getQueryMode() {
        return this._queryMode;
    }

    public void setQueryMode(boolean queryMode) {
        this._queryMode = queryMode;
    }

    public Set<Path> getFilesToRegenerate() {
        return this._filesToRegenerate.keySet();
    }

    public Map<Path, Set<Path>> getSourceFilesToRegenerate() {
        return this._filesToRegenerate;
    }

    public synchronized void addFilesToRegenerate(Path file) {
        this._filesToRegenerate.put(file, new HashSet());
    }

    public synchronized void addSourceFilesToRegenerate(Path file, Set<Path> sourceFiles) {
        if (this._filesToRegenerate.containsKey(file)) {
            Set<Path> existingFiles = this._filesToRegenerate.get(file);
            existingFiles.addAll(sourceFiles);
            this._filesToRegenerate.put(file, existingFiles);
        } else {
            this._filesToRegenerate.put(file, sourceFiles);
        }
    }

    public synchronized void backupRollbackPath(Path metadataPatchPath, Path backupLocation) throws IOException {
        Path backupFile = backupLocation.resolve(metadataPatchPath.getParent().getFileName()).resolve(metadataPatchPath.getFileName());
        Files.createDirectories(backupFile.getParent(), new FileAttribute[0]);
        Files.copy(metadataPatchPath, backupFile, StandardCopyOption.REPLACE_EXISTING);
        this._patchRollbackBackupPaths.put(backupFile, metadataPatchPath);
    }

    public synchronized void restorePatchRollbackBackupPaths() throws IOException {
        for (Map.Entry<Path, Path> entry : this._patchRollbackBackupPaths.entrySet()) {
            Path backup = entry.getKey();
            Path dest = entry.getValue();
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.copy(backup, dest, StandardCopyOption.REPLACE_EXISTING);
            Files.delete(backup);
            Path patchDir = backup.getParent();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchDir);){
                if (!dirStream.iterator().hasNext()) {
                    Files.delete(patchDir);
                }
            }
            Path rollbackDir = patchDir.getParent();
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(rollbackDir);
            try {
                if (dirStream.iterator().hasNext()) continue;
                Files.delete(rollbackDir);
            }
            finally {
                if (dirStream == null) continue;
                dirStream.close();
            }
        }
        this._patchRollbackBackupPaths.clear();
    }

    public static boolean isRegenerateState() {
        return !RegenerationHelper.getInstance().getModifiedFiles().isEmpty() || RegenerationHelper.hasModifiedMetaData();
    }

    public static boolean hasModifiedMetaData() {
        return !RegenerationHelper.getInstance().getModifiedComponents().isEmpty() || !RegenerationHelper.getInstance().getModifiedFeatureSets().isEmpty();
    }

    private boolean isRollbackQuery() {
        return !this._patchRollbackBackupPaths.isEmpty();
    }
}

