/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.installation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.dependency.DependencyException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cmn.QuickReference;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetGroup;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.dao.nfo.InstallerInfo;
import com.oracle.cie.gdr.external.InstallerSession;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import com.oracle.cie.gdr.helpers.LabelMapHelper;
import com.oracle.cie.gdr.installation.ComponentArchiveInstaller;
import com.oracle.cie.gdr.installation.InstallationSession;
import com.oracle.cie.gdr.installation.InstallationValidator;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentArchiveInstallationSession
extends InstallationSession
implements InstallerSession {
    private static final Logger _log = Logger.getLogger(ComponentArchiveInstallationSession.class.getName());
    public static final String COMPONENT_ARCHIVE_INSTALLER_DISTRIBUTION = "ComponentArchiveInstallerDistribution";
    public static final String COMPONENT_ARCHIVE_INSTALLER_FEATURE = "ComponentArchiveInstallerFeature";
    public static final String COMPONENT_ARCHIVE_INSTALLER_FEATURE_SET_GROUP = "ComponentArchiveInstallerFeatureSetGroup";
    private DirectoryMap _directoryMap;
    private LabelMap _labelMap;
    private FeatureLoader _featureLoader;
    private DistributionTarget _distributionTarget;
    private InstallerDistributionInfo _installerDistributionInfo;
    private ComponentLoader _componentLoader;

    public ComponentArchiveInstallationSession(File shipHomeDir, File homeDir, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(shipHomeDir, homeDir, true, null, null, directoryMap, platforms, locales);
    }

    public ComponentArchiveInstallationSession(File shipHomeDir, File homeDir, Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(shipHomeDir, homeDir, true, featureRefs, componentReferences, directoryMap, platforms, locales);
    }

    public ComponentArchiveInstallationSession(File shipHomeDir, File homeDir, boolean gdrLabelRequired, Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales) throws GdrException, IOException, DataHandlerException {
        this(ComponentHelper.getInstance().findMetaDataHome(shipHomeDir, gdrLabelRequired), homeDir, featureRefs, componentReferences, directoryMap, platforms, locales, null);
    }

    public ComponentArchiveInstallationSession(File shipHomeDir, File homeDir, boolean gdrLabelRequired, Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo) throws GdrException, IOException, DataHandlerException {
        this(ComponentHelper.getInstance().findMetaDataHome(shipHomeDir, gdrLabelRequired), homeDir, featureRefs, componentReferences, directoryMap, platforms, locales, installerInfo);
    }

    public ComponentArchiveInstallationSession(MetaDataHome metaDataHome, File homeDir, Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales);
        this.setInstallerInfo(installerInfo);
        this._directoryMap = directoryMap;
        this.init(featureRefs, componentReferences, this._directoryMap);
    }

    public ComponentArchiveInstallationSession(MetaDataHome metaDataHome, Path homeDir, Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap, Set<Integer> platforms, Set<Integer> locales, InstallerInfo installerInfo, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, IOException, DataHandlerException {
        super(metaDataHome, homeDir, platforms, locales, previouslyLoadedComponents);
        this.setInstallerInfo(installerInfo);
        this._directoryMap = directoryMap;
        this.init(featureRefs, componentReferences, this._directoryMap);
    }

    @Override
    public DistributionTarget getDistributionTarget() {
        return this._distributionTarget;
    }

    @Override
    public InstallerDistributionInfo getInstallerDistributionInfo() {
        return this._installerDistributionInfo;
    }

    public FeatureLoader getFeatureLoader() {
        return this._featureLoader;
    }

    @Override
    public ComponentLoader getComponentLoader() {
        return this._componentLoader;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return this.getFeatureLoader().getFeatureSets();
    }

    @Override
    public DirectoryMap getDirectoryMap() {
        return this._directoryMap;
    }

    public LabelMap getLabelMap() {
        return this._labelMap;
    }

    protected void init(Set<Reference> featureRefs, Set<Reference> componentReferences, DirectoryMap directoryMap) throws GdrException, IOException, DataHandlerException {
        if (directoryMap == null) {
            GdrException ex = new GdrException("Directory map was null and is required for installation.");
            _log.throwing(ComponentArchiveInstaller.class.getName(), "init", ex);
            throw ex;
        }
        MetaDataHome metadataHome = this.getMetaDataHome();
        if (!metadataHome.isShiphome() && !metadataHome.isRepository()) {
            try {
                this._labelMap = LabelMapHelper.getInstance().getLabelMap(this.getMetaDataHome().getGdrMetaDataHomePath());
            }
            catch (FileNotFoundException fnfe) {
                if (featureRefs != null && !featureRefs.isEmpty()) {
                    throw fnfe;
                }
                _log.finest("Label map file not found, but is not required: " + fnfe.getMessage());
            }
            if (this._labelMap == null && featureRefs != null && !featureRefs.isEmpty()) {
                GdrException ex = new GdrException("The label map definition was not loaded properly.");
                _log.throwing(ComponentArchiveInstaller.class.getName(), "init", ex);
                throw ex;
            }
        }
        if (featureRefs == null && componentReferences == null) {
            File installDir = this.getMetaDataHome().getComponentMetaDataHome().getParentFile();
            componentReferences = ComponentHelper.getInstance().findComponents(installDir, false, true);
            if (componentReferences == null || componentReferences.isEmpty()) {
                GdrException ex = new GdrException("Failed to install component archives because no components were found under " + installDir);
                _log.throwing(ComponentArchiveInstaller.class.getName(), "init", ex);
                throw ex;
            }
        }
        if ((featureRefs == null || featureRefs.isEmpty()) && (componentReferences == null || componentReferences.isEmpty())) {
            GdrException ex = new GdrException("Failed to install component archives because no components or features were provided.");
            _log.throwing(ComponentArchiveInstaller.class.getName(), "init", ex);
            throw ex;
        }
        HashSet<FeatureSet> dummyFeature = null;
        if (componentReferences != null && !componentReferences.isEmpty()) {
            dummyFeature = new HashSet<FeatureSet>();
            dummyFeature.add(ComponentArchiveInstallationSession.getDummyFeatureSet(this.getHome(), componentReferences));
        }
        this._featureLoader = new FeatureLoader(this.getMetaDataHome(), FeatureSetHelper.getInstance().convertReferences(featureRefs), dummyFeature);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featureLoader.getFeatureSets().size() + " feature sets.");
        }
        Distribution distribution = ComponentArchiveInstallationSession.getDummyDistribution(this.getHome(), this._featureLoader.getFeatureSets(), directoryMap);
        this._installerDistributionInfo = InstallerInfoHelper.getInstance().getInstallerDistributionInfo(this.getInstallerInfo());
        this._distributionTarget = new DistributionTarget(distribution, this._featureLoader.getFeatureSets());
        this._componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.INSTALL, this.getFeatureLoader().getFeatureSets(), this.getDirectoryMap(), this.getInstallerDistributionInfo(), this.getLabelMap(), this.getPreviouslyLoadedComponents());
        this.setInstallationStates(this._componentLoader.getComponentsMap());
    }

    @Override
    public void validateInstallation() throws DependencyException, GdrException {
        super.validateInstallation();
        InstallationValidator.validate(this.getDistributionTarget(), this.getDistributionInfo(), this.getSelectedFeatures(), this.getComponentLoader(), this.getDirectoryMap(), this.getHome());
    }

    public static FeatureSet getDummyFeatureSet(Home home, Set<Reference> componentReferences) {
        String featureName = COMPONENT_ARCHIVE_INSTALLER_FEATURE;
        String featureVersion = Version.getVersion();
        int x = 1;
        while (home.getInstalledFeature(new QuickReference(featureName, featureVersion)) != null) {
            featureName = COMPONENT_ARCHIVE_INSTALLER_FEATURE + x;
            ++x;
        }
        return FeatureSetHelper.getInstance().createFeatureSet(featureName, featureVersion, componentReferences);
    }

    public static Distribution getDummyDistribution(Home home, Set<FeatureSet> featureSets, DirectoryMap directoryMap) {
        String distributionName = COMPONENT_ARCHIVE_INSTALLER_DISTRIBUTION;
        String distributionVersion = Version.getVersion();
        int x = 1;
        while (home.getInstalledDistribution(distributionName, distributionVersion) != null) {
            distributionName = COMPONENT_ARCHIVE_INSTALLER_DISTRIBUTION + x;
            ++x;
        }
        Distribution distribution = new Distribution(distributionName, distributionVersion);
        FeatureSetGroup fsg = new FeatureSetGroup(COMPONENT_ARCHIVE_INSTALLER_FEATURE_SET_GROUP);
        fsg.setFeatures(DistributionHelper.getInstance().getFeatureSetReferences(featureSets));
        ArrayList<FeatureSetGroup> fsgs = new ArrayList<FeatureSetGroup>();
        fsgs.add(fsg);
        distribution.setFeatureSetGroups(fsgs);
        distribution.setDirectoryMap(directoryMap);
        return distribution;
    }
}

