/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.gdr.libraries.JarLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryAccessException;
import com.oracle.cie.gdr.libraries.LibraryEntryLocation;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryObserverData;
import com.oracle.cie.gdr.libraries.LibraryProcessorManager;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryTargetHolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibraryProcessorTask
extends Observable
implements Runnable {
    private static final Logger _log = Logger.getLogger(LibraryProcessorTask.class.getName());
    private LibraryKey key;
    private LibraryTarget target;
    private LibraryTargetHolder targetHolder;
    private Set<LibraryEntryLocation> entryLocations;
    private String location;
    private JarLibraryHandler lib;

    public LibraryProcessorTask(JarLibraryHandler lib, LibraryKey key, LibraryTarget target, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        this.lib = lib;
        this.key = key;
        this.target = target;
        this.entryLocations = entryLocations;
        this.location = location;
        this.targetHolder = null;
    }

    public LibraryProcessorTask(JarLibraryHandler lib, LibraryKey key, LibraryTargetHolder targetHolder, Set<LibraryEntryLocation> entryLocations, String location) throws LibraryHandlerException {
        this.lib = lib;
        this.key = key;
        this.target = null;
        this.entryLocations = entryLocations;
        this.location = location;
        this.targetHolder = targetHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LibraryObserverData observerData = new LibraryObserverData();
        try {
            if (LibraryProcessorManager.getObserver() != null) {
                this.addObserver(LibraryProcessorManager.getObserver());
            }
            observerData.setLibraryKey(this.key);
            observerData.setState(LibraryObserverData.State.Before);
            this.setChanged();
            this.notifyObservers(observerData);
            if (this.isFeatureLibrary()) {
                this.lib.processFeatureLibrary(this.key, this.targetHolder, this.entryLocations, this.location);
                LibraryProcessorManager.removeLibraryFromLoop(this.lib.getAbsoluteFeaturesetJarPaths(this.key, this.targetHolder).get(0));
            } else {
                this.lib.processComponentLibrary(this.key, this.target, this.entryLocations, this.location);
                LibraryProcessorManager.removeLibraryFromLoop(this.lib.getAbsoluteComponentJarPaths(this.key, this.target).get(0));
            }
        }
        catch (LibraryAccessException e) {
            if (this.isFeatureLibrary()) {
                try {
                    _log.log(Level.FINE, "LibraryAccessException hit: " + e.getMessage(), (Throwable)((Object)e));
                    LibraryProcessorManager.addLibraryToLoop(this.lib.getAbsoluteFeaturesetJarPaths(this.key, this.targetHolder).get(0), (Throwable)((Object)e));
                    LibraryProcessorManager.addFeatureSetLibrary(this.lib.getHome(), this.lib.getInstallerWrapper(), this.lib.getMode(), this.key.getType(), this.key, this.targetHolder, this.entryLocations, this.location);
                }
                catch (LibraryHandlerException e1) {
                    LibraryProcessorManager.stopAll(e1);
                }
            }
        }
        catch (LibraryHandlerException e) {
            LibraryProcessorManager.stopAll(e);
        }
        finally {
            observerData.setState(LibraryObserverData.State.After);
            this.setChanged();
            this.notifyObservers(observerData);
        }
    }

    private boolean isFeatureLibrary() {
        return this.target == null;
    }

    public List<String> getLibrariesLocations() throws LibraryHandlerException {
        ArrayList<String> libraries = new ArrayList<String>();
        if (this.isFeatureLibrary()) {
            for (String loc : this.lib.getFeaturesetJarLocations(this.key, this.targetHolder)) {
                libraries.add(this.lib.getFullJarLocation(this.location + File.separator + loc));
            }
        } else {
            for (String loc : this.lib.getComponentJarLocations(this.key, this.target)) {
                libraries.add(this.lib.getFullJarLocation(this.location + File.separator + loc));
            }
        }
        return libraries;
    }

    public void removeLoc(Collection<Integer> indexes) {
        if (indexes.size() == 0) {
            return;
        }
        if (this.isFeatureLibrary()) {
            this.targetHolder.removeFeaturesetJarLocations(this.key, indexes);
        } else {
            this.target.removeLibraryJarLocations(this.key, indexes);
        }
    }

    public LibraryKey getKey() {
        return this.key;
    }
}

