/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.libraries;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Library;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.ftr.FeatureLibrary;
import com.oracle.cie.gdr.dao.ftr.FeatureLibraryInclude;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.libraries.DefaultLibraryHandler;
import com.oracle.cie.gdr.libraries.LibraryHandlerException;
import com.oracle.cie.gdr.libraries.LibraryKey;
import com.oracle.cie.gdr.libraries.LibraryTarget;
import com.oracle.cie.gdr.libraries.LibraryType;
import com.oracle.cie.gdr.libraries.LibraryVersion;
import com.oracle.cie.gdr.utils.GdrException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class LibraryTargetHolder {
    private static final Logger _log = Logger.getLogger(LibraryTargetHolder.class.getName());
    private FeatureSet _feature;
    private LinkedHashSet<LibraryTargetHolder> _dependencies;
    private Collection<Component> _components;
    private Map<LibraryKey, List<LibraryTarget>> _targets;
    private Map<LibraryKey, FeatureLibrary> _featureKeys;
    private Map<FeatureLibrary, String> _featureLibraryProductHomes;
    private DirectoryMap _dirMap;
    private Map<LibraryKey, List<String>> _featureJarLocations;
    private Home _home;

    public LibraryTargetHolder(FeatureSet feature, LinkedHashSet<LibraryTargetHolder> dependencies, Collection<Component> components, DirectoryMap dirMap, Home home) {
        this._feature = feature;
        this._dependencies = dependencies != null ? dependencies : new LinkedHashSet();
        this._components = components != null ? components : new ArrayList();
        this._dirMap = dirMap;
        this._featureJarLocations = new LinkedHashMap<LibraryKey, List<String>>();
        this._home = home;
        this.buildLibraryTargets();
    }

    public Home getHome() {
        return this._home;
    }

    public FeatureSet getFeature() {
        return this._feature;
    }

    public Set<LibraryTargetHolder> getDependencies() {
        return this._dependencies;
    }

    private void buildLibraryTargets() {
        List<FeatureLibrary> featureLibraries;
        this._targets = new LinkedHashMap<LibraryKey, List<LibraryTarget>>();
        this._featureKeys = new LinkedHashMap<LibraryKey, FeatureLibrary>();
        if (this._components != null && !this._components.isEmpty()) {
            for (Component component : this._components) {
                List<Library> libraries = component.getLibraries();
                if (libraries == null || libraries.isEmpty()) continue;
                for (Library library : libraries) {
                    LibraryTarget target = new LibraryTarget(component, library, this._dirMap, this.getHome());
                    List<LibraryTarget> targets = this._targets.get(target.getKey());
                    if (targets == null) {
                        targets = new ArrayList<LibraryTarget>();
                        this._targets.put(target.getKey(), targets);
                    }
                    targets.add(target);
                }
            }
        }
        if (this._feature != null && (featureLibraries = this._feature.getLibraries()) != null && !featureLibraries.isEmpty()) {
            for (FeatureLibrary flib : featureLibraries) {
                String version;
                String completeVersion = version = flib.getVersion();
                if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                    version = ComponentHelper.getShortenedVersion(this._feature.getVersion());
                    completeVersion = this._feature.getVersion();
                }
                this._featureKeys.put(new LibraryKey(flib.getType(), flib.getName(), flib.getExtension(), version, completeVersion, flib.getVisibility(), flib.getIgnoreType(), flib.getIgnoreVersion(), flib.getPomGen(), flib.getHK2Gen(), flib.getHK2Location(), flib.getOverwriteHigherVersion(), flib.getSuppressManifestProperties()), flib);
            }
        }
    }

    public Collection<LibraryKey> getLibraryKeys() {
        return new ArrayList<LibraryKey>(this._targets.keySet());
    }

    public Collection<LibraryKey> getLibraryKeys(String name) {
        ArrayList<LibraryKey> keys = new ArrayList<LibraryKey>();
        if (name != null) {
            for (LibraryKey key : this.getLibraryKeys()) {
                if (!name.equals(key.getName())) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public Collection<LibraryKey> getLibraryKeys(LibraryType type, String name, LibraryVersion version, boolean ignoreVersion, boolean isSingleton) {
        ArrayList<LibraryKey> keys = new ArrayList<LibraryKey>();
        if (type != null && name != null && version != null) {
            for (LibraryKey key : this.getLibraryKeys()) {
                if (type != key.getType() && key.getType() != LibraryType.none || !name.equals(key.getName()) || !DefaultLibraryHandler.isValidVersion(key.getLibraryVersion(), version, ignoreVersion, key.getIgnoreVersion(), isSingleton)) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public Collection<LibraryKey> getFeatureLibraryKeys(String name) {
        ArrayList<LibraryKey> keys = new ArrayList<LibraryKey>();
        if (name != null) {
            for (LibraryKey key : this.getFeatureLibraryKeys()) {
                if (!name.equals(key.getName())) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public Collection<LibraryKey> getFeatureLibraryKeys(LibraryType type, String name, LibraryVersion version) {
        ArrayList<LibraryKey> keys = new ArrayList<LibraryKey>();
        if (type != null && name != null && version != null) {
            for (LibraryKey key : this.getFeatureLibraryKeys()) {
                if (type != key.getType() || !name.equals(key.getName()) || !version.equals(key.getLibraryVersion())) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    public Collection<LibraryKey> getFeatureLibraryKeys() {
        return new ArrayList<LibraryKey>(this._featureKeys.keySet());
    }

    public FeatureLibrary getFeatureLibrary(LibraryKey key) {
        return this._featureKeys.get(key);
    }

    public Map<LibraryKey, List<LibraryTarget>> getLibraryTargets(LibraryType type) {
        LinkedHashMap<LibraryKey, List<LibraryTarget>> targets = new LinkedHashMap<LibraryKey, List<LibraryTarget>>();
        if (type != null) {
            for (LibraryKey key : this._targets.keySet()) {
                if (type != key.getType()) continue;
                targets.put(key, this._targets.get(key));
            }
        }
        return targets;
    }

    public boolean hasLibraryTypes(LibraryType type) {
        List<FeatureLibrary> featureLibraries;
        for (LibraryKey key : this._targets.keySet()) {
            if (type != key.getType()) continue;
            return true;
        }
        if (this._feature != null && (featureLibraries = this._feature.getLibraries()) != null && !featureLibraries.isEmpty()) {
            for (FeatureLibrary library : featureLibraries) {
                if (!library.getType().equals(type.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public List<LibraryTarget> getLibraryTargets(LibraryKey key) {
        ArrayList<LibraryTarget> targets = new ArrayList<LibraryTarget>();
        if (key != null && this._targets.containsKey(key)) {
            targets.addAll((Collection<LibraryTarget>)this._targets.get(key));
        }
        return targets;
    }

    public String getProductHome(FeatureLibrary feature, Mode mode) throws GdrException {
        if (this._featureLibraryProductHomes == null || this._featureLibraryProductHomes.isEmpty()) {
            this.generateProductHomes(mode);
        }
        return this._featureLibraryProductHomes.get((Object)feature);
    }

    protected void generateProductHomes(Mode mode) throws GdrException {
        this._featureLibraryProductHomes = new LinkedHashMap<FeatureLibrary, String>();
        List<FeatureLibrary> featureLibraries = this._feature.getLibraries();
        if (featureLibraries != null && !featureLibraries.isEmpty()) {
            for (FeatureLibrary flib : featureLibraries) {
                String productHome = null;
                String symbol = flib.getSymbol();
                if (!StringUtil.isNullOrEmpty((String)symbol, (boolean)true)) {
                    Collection<String> rootDirs = DistributionHelper.getInstance().getRootDirsForSymbol(this._dirMap, symbol);
                    if (rootDirs.size() > 1) {
                        _log.warning("The symbol " + symbol + " is mapped to more than one directory. Use a different symbol for the library " + flib.getName());
                    }
                    if (!rootDirs.isEmpty()) {
                        productHome = (String)rootDirs.iterator().next();
                    }
                }
                if (productHome == null) {
                    for (Map.Entry entry : this._targets.entrySet()) {
                        for (LibraryTarget target : (List)entry.getValue()) {
                            if (productHome == null) {
                                productHome = target.getProductHome(mode);
                            }
                            if (productHome == null || productHome.equals(target.getProductHome(mode))) continue;
                            _log.warning("The components included belong to different product homes. Please use the \"symbol\" attribute on the library " + flib.getName() + " to set the correct product home");
                            break;
                        }
                        if (productHome == null) continue;
                        break;
                    }
                }
                if (productHome == null && this._dependencies != null && !this._dependencies.isEmpty()) {
                    List<FeatureLibraryInclude> includes = flib.getIncludes();
                    ArrayList<LibraryTarget> arrayList = new ArrayList<LibraryTarget>();
                    for (FeatureLibraryInclude include : includes) {
                        for (LibraryTargetHolder dep : this._dependencies) {
                            HashMap<FeatureLibrary, Set<FeatureLibrary>> cycleCheck = new HashMap<FeatureLibrary, Set<FeatureLibrary>>();
                            cycleCheck.put(flib, new HashSet());
                            this.getDependencyLibraryTargets(flib, this.getIncludeVersion(include, this.getLibraryKey(flib)), include, dep, arrayList, cycleCheck);
                        }
                    }
                    for (LibraryTarget target : arrayList) {
                        if (productHome == null) {
                            productHome = target.getProductHome(mode);
                        }
                        if (productHome == null || productHome.equals(target.getProductHome(mode))) continue;
                        _log.warning("The components included belong to different product homes. Please use the \"symbol\" attribute on the library " + flib.getName() + " to set the correct product home");
                        break;
                    }
                }
                if (productHome == null) {
                    _log.warning("The product home for feature library " + flib.getName() + " was not set. Please use the correct symbol or file map");
                }
                this._featureLibraryProductHomes.put(flib, productHome);
            }
        }
    }

    public void getDependencyLibraryTargets(FeatureLibrary flib, LibraryVersion version, FeatureLibraryInclude include, LibraryTargetHolder dep, List<LibraryTarget> dependencyTargets, Map<FeatureLibrary, Set<FeatureLibrary>> cycleCheck) throws GdrException {
        block13: {
            String name;
            LibraryType type;
            block14: {
                Set<LibraryTargetHolder> childDeps;
                type = LibraryType.getLibraryType(flib.getType());
                name = include.getName();
                if (type == null || name == null || version == null) break block13;
                if (include.isFeature().booleanValue()) break block14;
                Collection<LibraryKey> compKeys = dep.getLibraryKeys(type, name, version, include.getIgnoreVersion(), dep.getFeature().isSingleton());
                if (compKeys != null && !compKeys.isEmpty()) {
                    for (LibraryKey libraryKey : compKeys) {
                        dependencyTargets.addAll(dep.getLibraryTargets(libraryKey));
                    }
                }
                if ((childDeps = dep.getDependencies()) == null || childDeps.isEmpty()) break block13;
                for (LibraryTargetHolder childDep : childDeps) {
                    this.getDependencyLibraryTargets(flib, version, include, childDep, dependencyTargets, cycleCheck);
                }
                break block13;
            }
            Collection<LibraryKey> featureKeys = dep.getFeatureLibraryKeys(type, name, version);
            if (featureKeys != null && !featureKeys.isEmpty()) {
                for (LibraryKey libraryKey : featureKeys) {
                    FeatureLibrary lib = dep.getFeatureLibrary(libraryKey);
                    if (flib.equals((Object)lib)) {
                        LibraryHandlerException ex = new LibraryHandlerException("Cyclic dependency detected in featureset library " + flib.getName());
                        _log.throwing(this.getClass().getName(), "getDependencyLibraryTargets", (Throwable)((Object)ex));
                        throw ex;
                    }
                    cycleCheck.get((Object)flib).add(lib);
                    for (Map.Entry<FeatureLibrary, Set<FeatureLibrary>> entry : cycleCheck.entrySet()) {
                        if (!entry.getValue().contains((Object)flib)) continue;
                        if (entry.getKey().equals((Object)lib)) {
                            LibraryHandlerException ex = new LibraryHandlerException("Cyclic dependency detected in featureset library " + flib.getName());
                            _log.throwing(this.getClass().getName(), "getDependencyLibraryTargets", (Throwable)((Object)ex));
                            throw ex;
                        }
                        cycleCheck.get((Object)entry.getKey()).add(lib);
                    }
                    if (!cycleCheck.containsKey((Object)lib)) {
                        cycleCheck.put(lib, new HashSet());
                    }
                    for (FeatureLibraryInclude innerInclude : lib.getIncludes()) {
                        this.getDependencyLibraryTargets(lib, this.getIncludeVersion(innerInclude, libraryKey), innerInclude, dep, dependencyTargets, cycleCheck);
                    }
                }
            } else {
                Set<LibraryTargetHolder> childDeps = dep.getDependencies();
                if (childDeps != null && !childDeps.isEmpty()) {
                    for (LibraryTargetHolder childDep : childDeps) {
                        this.getDependencyLibraryTargets(flib, version, include, childDep, dependencyTargets, cycleCheck);
                    }
                }
            }
        }
    }

    protected LibraryVersion getIncludeVersion(FeatureLibraryInclude include, LibraryKey key) {
        LibraryVersion version = new LibraryVersion(include.getVersion());
        if (StringUtil.isNullOrEmpty((String)include.getVersion(), (boolean)true)) {
            version = key.getLibraryVersion();
        }
        return version;
    }

    public LibraryKey getLibraryKey(FeatureLibrary flib) {
        Set<LibraryKey> libKeys = this._featureKeys.keySet();
        for (LibraryKey key : libKeys) {
            FeatureLibrary lib = this._featureKeys.get(key);
            if (!lib.matches(flib.getType(), flib.getName(), flib.getVersion())) continue;
            return key;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryTargetHolder that = (LibraryTargetHolder)o;
        return !(this._feature == null ? that._feature != null : !this._feature.equals(that._feature));
    }

    public int hashCode() {
        return this._feature != null ? this._feature.hashCode() : 0;
    }

    public String toString() {
        return this._feature != null ? this._feature.toString() : super.toString();
    }

    public boolean needsRegeneration() {
        if (RegenerationHelper.getInstance().getModifiedFeatureSets().contains(this._feature)) {
            return true;
        }
        for (LibraryTargetHolder dependency : this._dependencies) {
            if (!dependency.needsRegeneration()) continue;
            return true;
        }
        for (LibraryKey key : this._targets.keySet()) {
            List<LibraryTarget> targets = this._targets.get(key);
            for (LibraryTarget target : targets) {
                if (!target.needsRegeneration()) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getFeaturesetJarLocations(LibraryKey key) {
        return this._featureJarLocations.get(key);
    }

    public void setFeaturesetJarLocations(LibraryKey key, List<String> jarLocations) {
        this._featureJarLocations.put(key, jarLocations);
    }

    public void removeFeaturesetJarLocations(LibraryKey key, Collection<Integer> indexes) {
        List<String> locations = this._featureJarLocations.get(key);
        ArrayList<String> remove = new ArrayList<String>();
        for (Integer i : indexes) {
            remove.add(locations.get(i));
        }
        locations.removeAll(remove);
        this._featureJarLocations.put(key, locations);
    }
}

