/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.pack200;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.FileCopy;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.pack200.Pack200Engine;
import com.oracle.cie.gdr.pack200.PackedFile;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Pack200;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

public class Pack200Helper {
    private static final String INDEX_LIST_LOCATION = "META-INF/INDEX.LIST";
    private static final Logger _log = Logger.getLogger(Pack200Helper.class.getName());
    private static Pack200Helper _instance;
    private static final String FS;

    public static Pack200Helper getInstance() {
        if (_instance == null) {
            _instance = new Pack200Helper();
        }
        return _instance;
    }

    public PackedFile packAndVerify(String jarPath) throws GdrException, SecurityException {
        if (jarPath == null || jarPath.isEmpty()) {
            throw new GdrException("Tha jar to pack and verify can not be null or empty.");
        }
        return this.packAndVerify(new File(jarPath));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PackedFile packAndVerify(File jarFile) throws GdrException, SecurityException {
        JarFile jarFileObject;
        PackedFile packedFile;
        block12: {
            packedFile = new PackedFile(jarFile);
            File unpackedFile = null;
            jarFileObject = null;
            try {
                jarFileObject = new JarFile(jarFile);
                JarEntry entry = jarFileObject.getJarEntry(INDEX_LIST_LOCATION);
                if (entry != null) {
                    throw new GdrException("There was a problem while packing and verifying the file, indexed jars should not be packed");
                }
                packedFile.setPackedFile(Pack200Engine.getInstance().pack(packedFile.getJar()));
                unpackedFile = Pack200Engine.getInstance().unpack(packedFile.getPackedFile());
                this.verifyJar(unpackedFile);
                if (unpackedFile != null) {
                    packedFile.setUnpackedJarSize(unpackedFile.length());
                }
                if (unpackedFile == null) break block12;
            }
            catch (IOException e) {
                try {
                    if (packedFile.getPackedFile() == null) throw new GdrException("There was a problem while packing and verifying the file ", (Throwable)e);
                    Delete.delete((File)packedFile.getPackedFile());
                    throw new GdrException("There was a problem while packing and verifying the file ", (Throwable)e);
                    catch (GdrException | SecurityException e2) {
                        if (packedFile.getPackedFile() == null) throw e2;
                        Delete.delete((File)packedFile.getPackedFile());
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (unpackedFile != null) {
                        Delete.delete(unpackedFile);
                    }
                    if (jarFileObject == null) throw throwable;
                    try {
                        jarFileObject.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        throw new GdrException("There was a problem while closing the jar while filepacking and verifying", (Throwable)e3);
                    }
                }
            }
            Delete.delete((File)unpackedFile);
        }
        if (jarFileObject == null) return packedFile;
        try {
            jarFileObject.close();
            return packedFile;
        }
        catch (IOException e) {
            throw new GdrException("There was a problem while closing the jar while filepacking and verifying", (Throwable)e);
        }
    }

    private void verifyJar(File jar) throws SecurityException, IOException {
        File tmpfile = null;
        FileOutputStream out = null;
        FileInputStream fis = null;
        ZipInputStream jis = null;
        Pack200.Packer packer = Pack200.newPacker();
        packer.properties().putAll(Pack200Engine.getDefaultFlags());
        try {
            tmpfile = File.createTempFile("jar", ".tmp");
            out = new FileOutputStream(tmpfile);
            fis = new FileInputStream(jar);
            jis = new JarInputStream(fis);
            packer.pack((JarInputStream)jis, (OutputStream)out);
        }
        catch (IOException e) {
            throw new IOException("The temporary dest file could not be created", e);
        }
        catch (SecurityException e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException iOException) {}
            }
            Delete.delete((File)tmpfile);
        }
    }

    public Set<Component> getComponentsForPack200(String comps, ComponentLoader loader) {
        if (StringUtil.isNullOrEmpty((String)comps)) {
            return null;
        }
        String[] compsArray = (comps = comps.replace(" ", "")).split(",");
        if (compsArray.length < 1) {
            _log.finest("The specified components list for Pack200 compression is invalid");
            throw new IllegalArgumentException("The specified components list for Pack200 compression is invalid");
        }
        HashSet<Component> selectedComps = new HashSet<Component>();
        for (String component : compsArray) {
            String[] values = component.split(":");
            String name = null;
            String version = null;
            if (values.length != 2) {
                _log.finest("There was an error while getting the component list for Pack200 compression.");
                _log.finest("Invalid component specified: " + component);
                throw new IllegalArgumentException("The specified component for Pack200 compression is invalid: " + component);
            }
            name = values[0];
            version = values[1];
            Component comp = loader.getComponent(name, version);
            if (comp == null) {
                _log.finest("The specified component was not found: " + component);
                continue;
            }
            selectedComps.add(comp);
        }
        return selectedComps;
    }

    public void compressComponents(File stageDir, Set<Component> components) throws GdrException {
        for (Component comp : components) {
            this.compressComponent(stageDir, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressComponent(File stageDir, Component component) throws GdrException {
        _log.finest("Applying Pack200 compression to component " + component.getName() + " version " + component.getVersion());
        for (FileMap fileMap : component.getFileMaps()) {
            File tmpFilegroupJar;
            File tmpFilegroupDir;
            block19: {
                JarHelper tmpFilegroupJarHelper;
                JarHelper filegroupJarHelper;
                File filegroupJar;
                block16: {
                    block17: {
                        if (!this.containsJarFiles(fileMap) || fileMap.isBootstrap()) continue;
                        filegroupJar = null;
                        tmpFilegroupDir = null;
                        tmpFilegroupJar = null;
                        filegroupJarHelper = null;
                        tmpFilegroupJarHelper = null;
                        try {
                            filegroupJar = new File(this.getFileGroupLocation(stageDir, component.getName(), component.getVersion(), fileMap.getSource()));
                            tmpFilegroupDir = Files.createTempDirectory(fileMap.getSource(), new FileAttribute[0]).toFile();
                            tmpFilegroupJar = new File(tmpFilegroupDir.getPath() + ".jar");
                        }
                        catch (IOException e) {
                            throw new GdrException("There was a problem obtaining the path to " + fileMap.getSource() + ", in component: " + component.getName(), (Throwable)e);
                        }
                        if (filegroupJar.exists()) break block16;
                        _log.finest(fileMap.getSource() + " didn't exist in component " + component.getName() + " version " + component.getVersion());
                        if (filegroupJarHelper == null) break block17;
                        filegroupJarHelper.close();
                    }
                    Delete.delete((File)tmpFilegroupDir);
                    Delete.delete((File)tmpFilegroupJar);
                    continue;
                }
                try {
                    try {
                        tmpFilegroupJarHelper = new JarHelper(filegroupJar, 0);
                        tmpFilegroupJarHelper.extract(tmpFilegroupDir);
                    }
                    catch (IOException e) {
                        throw new GdrException("There was a problem extracting filegroup: " + fileMap.getSource() + ", of component: " + component.getName(), (Throwable)e);
                    }
                    finally {
                        tmpFilegroupJarHelper.close();
                    }
                    for (Directory dir : fileMap.getDirectories()) {
                        String dirDest = dir.getDest();
                        if (!StringUtil.isNullOrEmpty((String)dirDest)) {
                            this.processDirectory(dir, tmpFilegroupDir.getPath() + FS + dir.getDest());
                            continue;
                        }
                        this.processDirectory(dir, tmpFilegroupDir.getPath());
                    }
                    this.processFiles(fileMap.getFiles(), tmpFilegroupDir.getPath());
                    try {
                        filegroupJarHelper = new JarHelper(tmpFilegroupJar, 1);
                        filegroupJarHelper.append(tmpFilegroupDir, false);
                        filegroupJarHelper.close();
                        FileCopy.copy((File)tmpFilegroupJar, (File)filegroupJar);
                    }
                    catch (IOException e) {
                        throw new GdrException("There was a problem creating filegroup: " + fileMap.getSource() + ", in component: " + component.getName(), (Throwable)e);
                    }
                    if (filegroupJarHelper == null) break block19;
                }
                catch (Throwable throwable) {
                    if (filegroupJarHelper != null) {
                        filegroupJarHelper.close();
                    }
                    Delete.delete(tmpFilegroupDir);
                    Delete.delete(tmpFilegroupJar);
                    throw throwable;
                }
                filegroupJarHelper.close();
            }
            Delete.delete((File)tmpFilegroupDir);
            Delete.delete((File)tmpFilegroupJar);
        }
    }

    private String getFileGroupLocation(File stageDir, String componentName, String componentVersion, String fileMapSource) {
        return FileUtils.formatPath(stageDir.getPath() + FS + "Components" + FS + componentName + FS + componentVersion + FS + "DataFiles" + FS + fileMapSource);
    }

    private void processDirectory(Directory dir, String filesDir) {
        for (Directory subdir : dir.getDirectories()) {
            String subdirDest = subdir.getDest();
            if (!StringUtil.isNullOrEmpty((String)subdirDest)) {
                this.processDirectory(subdir, filesDir + FS + subdir.getDest());
                continue;
            }
            this.processDirectory(subdir, filesDir);
        }
        this.processFiles(dir.getFiles(), filesDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles(List<com.oracle.cie.gdr.dao.cpd.File> files, String filesDir) {
        for (com.oracle.cie.gdr.dao.cpd.File file : files) {
            File theFile = new File(filesDir + FS + file.getDest());
            if (!StringUtil.isNullOrEmpty((String)file.getJarEntry()) || !StringUtil.isNullOrEmpty((String)file.getSymlink()) || !JarUtils.isArchive((File)theFile)) continue;
            _log.finest("Applying Pack200 compression to: " + file.getDest());
            long unpackedSize = 0L;
            PackedFile packedFile = null;
            try {
                packedFile = this.packAndVerify(theFile);
                unpackedSize = packedFile.getUnpackedJarSize();
                FileCopy.copy((File)packedFile.getPackedFile(), (File)theFile);
                file.setSize(unpackedSize);
                file.setPack(true);
            }
            catch (GdrException | IOException e) {
                _log.finest("There was a problem while packing file: " + file.getDest() + " .Pack200 compression will be ommited");
            }
            catch (SecurityException ex) {
                _log.finest("Verification failed. Pack200 compression will be ommited for file " + file.getDest());
            }
            finally {
                if (packedFile == null) continue;
                Delete.delete((File)packedFile.getPackedFile());
            }
        }
    }

    private boolean containsJarFiles(FileMap fileMap) {
        for (Directory dir : fileMap.getDirectories()) {
            if (!this.containsJarFiles(dir)) continue;
            return true;
        }
        for (com.oracle.cie.gdr.dao.cpd.File file : fileMap.getFiles()) {
            if (!file.getDest().endsWith(".jar")) continue;
            return true;
        }
        return false;
    }

    private boolean containsJarFiles(Directory dir) {
        for (Directory subdir : dir.getDirectories()) {
            if (!this.containsJarFiles(subdir)) continue;
            return true;
        }
        for (com.oracle.cie.gdr.dao.cpd.File file : dir.getFiles()) {
            if (!file.getDest().endsWith(".jar")) continue;
            return true;
        }
        return false;
    }

    static {
        FS = File.separator;
    }
}

