/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.patch;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.ComponentTarget;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Home;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.Version;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.pch.BugList;
import com.oracle.cie.gdr.dao.pch.PatchDependencies;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.SessionAction;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.external.impl.LibraryGeneratorImpl;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.helpers.PatchHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.helpers.RegenerationHelper;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.libraries.LibraryException;
import com.oracle.cie.gdr.patch.InternalPatchHandler;
import com.oracle.cie.gdr.patch.PatchHandlerFactory;
import com.oracle.cie.gdr.patch.PatchHandlerImpl;
import com.oracle.cie.gdr.patch.PatchLockedRegistryHandler;
import com.oracle.cie.gdr.patch.StringSubsEnvHandlerImpl;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.FileUtils;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchActions;
import oracle.glcm.opatch.common.api.PatchAutomation;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchChecksum;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.api.SessionMode;
import oracle.glcm.opatch.common.api.SystemPatchBundle;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.HomeOperationsException;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;
import oracle.glcm.opatch.common.api.install.HomeOperationsShell;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.glcm.opatch.common.api.install.VersionInfo;
import oracle.glcm.opatch.common.impl.PatchFactoryImpl;

public class HomeOperationsImpl
extends HomeOperationsShell {
    private static final Logger _log = Logger.getLogger(HomeOperationsImpl.class.getName());
    private final Home _home;
    private final HomeOperationsFactory _homeOperationsFactory = HomeOperationsFactory.getInstance();
    private Map<String, PatchInfo> _addedPatchInfos;
    private Map<String, PatchInfo> _removedPatchInfos;
    private final Map<PatchHandlerKey, InternalPatchHandler> _patchHandlerCache = new HashMap<PatchHandlerKey, InternalPatchHandler>();

    public HomeOperationsImpl(Path homeDir) throws HomeOperationsException {
        try {
            this._home = Home.getHome(homeDir);
        }
        catch (Exception e) {
            throw new HomeOperationsException("Failed to load home: " + homeDir, (Throwable)e);
        }
    }

    public boolean isMethodImplemented(String methodName) {
        for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    public String getHomeDir() {
        return this.getHome().getHomePath().toString();
    }

    protected Home getHome() {
        return this._home;
    }

    public Set<oracle.glcm.opatch.common.api.install.ComponentInfo> getPatchComponentsInOHForApply(Set<oracle.glcm.opatch.common.api.install.ComponentInfo> patchComponents) throws HomeOperationsException {
        return new HashSet<InventoryComponentInfo>(this.calculateInventoryComponentInfos(patchComponents).values());
    }

    public Set<InventoryComponentInfo> getApplyInventoryComponents(String uniquePatchID, Set<PatchComponentInfo> patchComponents) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "getApplyInventoryComponents");
        Map<ComponentReference, InventoryComponentInfo> inventoryCompsMap = this.calculateInventoryComponentInfos(new HashSet<PatchComponentInfo>(patchComponents));
        HashSet<InventoryComponentInfo> inventoryComps = new HashSet<InventoryComponentInfo>(inventoryCompsMap.values());
        ArrayList<Path> affectedFiles = new ArrayList<Path>();
        InventoryComponentInfo metadataComponent = null;
        HashSet<Distribution> distributionsToUpgrade = new HashSet<Distribution>();
        HashSet<FeatureSet> featureSetsToAdd = new HashSet<FeatureSet>();
        HashSet<FeatureSet> featureSetsToRemove = new HashSet<FeatureSet>();
        HashSet<FeatureSet> featureSetsToUpgrade = new HashSet<FeatureSet>();
        HashMap<InventoryComponentInfo, Component> componentsToAdd = new HashMap<InventoryComponentInfo, Component>();
        HashMap<InventoryComponentInfo, Component> componentsToRemove = new HashMap<InventoryComponentInfo, Component>();
        try {
            InternalPatchHandler patchHandler = this._patchHandlerCache.get(new PatchHandlerKey(uniquePatchID, this.getHome()));
            if (patchHandler == null) {
                patchHandler = PatchHandlerFactory.getInternalPatchHandler(this.getHome());
                this._patchHandlerCache.put(new PatchHandlerKey(uniquePatchID, this.getHome()), patchHandler);
            }
            for (PatchComponentInfo patchComponentInfo : patchComponents) {
                if ("oracle.nextgen.metadata".equals(patchComponentInfo.getName())) {
                    metadataComponent = this._homeOperationsFactory.getInventoryComponentInfo(patchComponentInfo.getName(), patchComponentInfo.getVersion(), patchComponentInfo.getPatchLevel(), InventoryComponentInfo.Action.PATCH);
                    for (Map.Entry entry : patchComponentInfo.getPatchFilePaths().entrySet()) {
                        FeatureSet featureSet;
                        InventoryComponentInfo compInfo;
                        String absolutePath = FileUtils.formatPath(((Path)entry.getValue()).toAbsolutePath().toString(), "/");
                        metadataComponent.addAffectedFile(FileState.ADDED, (Path)entry.getValue());
                        if (this.matchesComponentInstall(uniquePatchID, absolutePath)) {
                            compInfo = this.processInventoryComponentInfoForInstall((Path)entry.getValue(), componentsToAdd, patchHandler);
                            inventoryComps.add(compInfo);
                            continue;
                        }
                        if (this.matchesComponentDeinstall(uniquePatchID, absolutePath)) {
                            compInfo = this.processInventoryComponentInfoForDeinstall((Path)entry.getValue(), componentsToRemove, patchHandler);
                            inventoryComps.add(compInfo);
                            continue;
                        }
                        if (this.matchesFeatureSetInstall(uniquePatchID, absolutePath)) {
                            featureSet = patchHandler.getFeatureSetMetaDataPatchHandler().getPatchMetaDataFeatureSet((Path)entry.getValue());
                            featureSetsToAdd.add(featureSet);
                            continue;
                        }
                        if (this.matchesFeatureSetDeinstall(uniquePatchID, absolutePath)) {
                            featureSet = patchHandler.getFeatureSetMetaDataPatchHandler().getPatchMetaDataFeatureSet((Path)entry.getValue());
                            featureSetsToRemove.add(featureSet);
                            continue;
                        }
                        if (this.matchesFeatureSetUpgrade(uniquePatchID, absolutePath)) {
                            featureSet = patchHandler.getFeatureSetMetaDataPatchHandler().getPatchMetaDataFeatureSet((Path)entry.getValue());
                            featureSetsToUpgrade.add(featureSet);
                            continue;
                        }
                        if (!this.matchesDistributionUpgrade(uniquePatchID, absolutePath)) continue;
                        Distribution dist = patchHandler.getDistributionMetaDataPatchHandler().getPatchMetaDataDistribution((Path)entry.getValue());
                        distributionsToUpgrade.add(dist);
                    }
                    inventoryComps.add(metadataComponent);
                    continue;
                }
                for (Path path : patchComponentInfo.getPatchFilePaths().keySet()) {
                    Path affectedPath = Paths.get(this.getHome().getHomePath().relativize(path).toString(), new String[0]);
                    affectedFiles.add(affectedPath);
                }
            }
            patchHandler.analyzePatch(distributionsToUpgrade, featureSetsToAdd, featureSetsToRemove, featureSetsToUpgrade, componentsToAdd, componentsToRemove, metadataComponent);
            if (!componentsToAdd.isEmpty()) {
                this.processComponentFiles(patchHandler, componentsToAdd, Mode.INSTALL);
            }
            if (!componentsToRemove.isEmpty()) {
                this.processComponentFiles(patchHandler, componentsToRemove, Mode.DEINSTALL);
            }
            if (!featureSetsToAdd.isEmpty()) {
                RegenerationHelper.getInstance().addModifiedFeatureSets(featureSetsToAdd);
            }
            if (!featureSetsToRemove.isEmpty()) {
                RegenerationHelper.getInstance().addModifiedFeatureSets(featureSetsToRemove);
            }
            if (!componentsToAdd.isEmpty()) {
                RegenerationHelper.getInstance().addModifiedComponents(new HashSet<Component>(componentsToAdd.values()));
            }
            if (!componentsToRemove.isEmpty()) {
                RegenerationHelper.getInstance().addModifiedComponents(new HashSet<Component>(componentsToRemove.values()));
            }
            this.queryLibraryRegeneration(affectedFiles, featureSetsToAdd, featureSetsToUpgrade, featureSetsToRemove, patchHandler);
        }
        catch (DataHandlerException | GdrException | IOException e) {
            _log.log(Level.SEVERE, "A failure occurred while analyzing patch: " + uniquePatchID, e);
            throw new HomeOperationsException("A failure occurred while analyzing patch: " + uniquePatchID, e);
        }
        Map<Path, Set<Path>> librarySourceMap = RegenerationHelper.getInstance().getSourceFilesToRegenerate();
        if (metadataComponent != null && !librarySourceMap.isEmpty()) {
            for (Map.Entry entry : librarySourceMap.entrySet()) {
                metadataComponent.addAffectedFile(FileState.GENERATED, (Path)entry.getKey());
                for (Path path : (Set)entry.getValue()) {
                    metadataComponent.addAffectedFile(FileState.REFERENCED, path);
                }
            }
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "getApplyInventoryComponents");
        return new HashSet<InventoryComponentInfo>(inventoryComps);
    }

    private boolean matchesComponentInstall(String uniquePatchID, String absolutePath) {
        return absolutePath.matches(".*/inventory/Components/.*/\\d+\\.\\d+\\.\\d+\\.\\d+\\.\\d+/install/" + uniquePatchID + "/.*\\." + "carb");
    }

    private boolean matchesComponentDeinstall(String uniquePatchID, String absolutePath) {
        return absolutePath.matches(".*/inventory/Components/.*/\\d+\\.\\d+\\.\\d+\\.\\d+\\.\\d+/deinstall/" + uniquePatchID + "/" + "compDef.xml");
    }

    private boolean matchesFeatureSetInstall(String uniquePatchID, String absolutePath) {
        return absolutePath.matches(".*/inventory/featuresets/install/" + uniquePatchID + "/.*\\." + "xml");
    }

    private boolean matchesFeatureSetDeinstall(String uniquePatchID, String absolutePath) {
        return absolutePath.matches(".*/inventory/featuresets/deinstall/" + uniquePatchID + "/.*\\." + "xml");
    }

    private boolean matchesFeatureSetUpgrade(String uniquePatchID, String absolutePath) {
        return absolutePath.matches(".*/inventory/featuresets/upgrades/" + uniquePatchID + "/.*\\." + "xml");
    }

    private boolean matchesDistributionUpgrade(String uniquePatchID, String absolutePath) {
        return absolutePath.matches(".*/inventory/distributions/upgrades/" + uniquePatchID + "/.*\\." + "xml");
    }

    private Map<ComponentReference, InventoryComponentInfo> calculateInventoryComponentInfos(Set<oracle.glcm.opatch.common.api.install.ComponentInfo> patchComponents) {
        Home home = this.getHome();
        HashMap<ComponentReference, InventoryComponentInfo> homeComponentInfos = new HashMap<ComponentReference, InventoryComponentInfo>();
        if (patchComponents != null && !patchComponents.isEmpty()) {
            Set<ComponentReference> installedComponents = home.getInstalledComponents();
            for (oracle.glcm.opatch.common.api.install.ComponentInfo patchCompInfo : patchComponents) {
                List<ComponentReference> matchingInstalledComponents = FeatureSetHelper.getInstance(home.getClassLoader()).getMatchingComponentRefs(patchCompInfo.getName(), installedComponents);
                for (ComponentReference componentReference : matchingInstalledComponents) {
                    if (homeComponentInfos.containsKey((Object)componentReference)) continue;
                    InventoryComponentInfo compInfo = this._homeOperationsFactory.getInventoryComponentInfo(componentReference.getName(), componentReference.getVersion(), componentReference.getPatchLevel(), InventoryComponentInfo.Action.PATCH);
                    if (patchCompInfo instanceof PatchComponentInfo) {
                        for (Path affectedFile : ((PatchComponentInfo)patchCompInfo).getPatchFilePaths().values()) {
                            compInfo.addAffectedFile(FileState.MODIFIED, affectedFile);
                        }
                    }
                    homeComponentInfos.put(componentReference, compInfo);
                }
            }
        }
        return homeComponentInfos;
    }

    private void queryLibraryRegeneration(List<Path> affectedFiles, Set<FeatureSet> featureSetsToAdd, Set<FeatureSet> featureSetsToUpgrade, Set<FeatureSet> featureSetsToRemove, InternalPatchHandler patchHandler) throws LibraryException {
        Map<Distribution, Set<FeatureSet>> featureSetsDistMap = patchHandler.getFeatureSetMetaDataPatchHandler().getDistributionMap();
        LinkedHashMap<Path, Set<String>> affectedFilesMap = new LinkedHashMap<Path, Set<String>>();
        for (Path affectedFile : affectedFiles) {
            affectedFilesMap.put(affectedFile, new LinkedHashSet());
        }
        LibraryGeneratorImpl libraryGenerator = new LibraryGeneratorImpl(this.getHome().getHomePath());
        for (FeatureSet feature : featureSetsToAdd) {
            for (Map.Entry<Distribution, Set<FeatureSet>> entry : featureSetsDistMap.entrySet()) {
                if (!entry.getValue().contains(feature)) continue;
                libraryGenerator.addFeatureSetToAdd(entry.getKey(), feature);
            }
        }
        libraryGenerator.queryLibraryPaths(affectedFilesMap);
    }

    private InventoryComponentInfo processInventoryComponentInfoForInstall(Path carbPath, Map<InventoryComponentInfo, Component> componentsToAdd, InternalPatchHandler patchHandler) throws GdrException, HomeOperationsException, IOException, DataHandlerException {
        Path inventoryPath = carbPath.getRoot().resolve(carbPath.subpath(0, carbPath.getNameCount() - 6));
        if (Files.exists(inventoryPath, new LinkOption[0])) {
            MetaDataHome metaDataHome = new MetaDataHome(inventoryPath, false, false, true);
            Component comp = patchHandler.getComponentMetaDataPatchHandler().getPatchMetaDataComponent(metaDataHome, carbPath);
            InventoryComponentInfo invCompInfo = this._homeOperationsFactory.getInventoryComponentInfo(comp.getName(), comp.getVersion(), comp.getPatchLevel(), InventoryComponentInfo.Action.ADD);
            if (componentsToAdd != null) {
                componentsToAdd.put(invCompInfo, comp);
            }
            return invCompInfo;
        }
        HomeOperationsException e = new HomeOperationsException("Path inventory " + inventoryPath + " does not exist for CARB " + carbPath);
        _log.log(Level.SEVERE, "Path inventory " + inventoryPath + " does not exist for CARB " + carbPath, e);
        throw e;
    }

    private InventoryComponentInfo processInventoryComponentInfoForDeinstall(Path compDef, Map<InventoryComponentInfo, Component> componentsToRemove, InternalPatchHandler patchHandler) throws GdrException, HomeOperationsException, IOException, DataHandlerException {
        Component comp = patchHandler.getComponentMetaDataPatchHandler().getPatchMetaDataComponent(compDef);
        InventoryComponentInfo invCompInfo = this._homeOperationsFactory.getInventoryComponentInfo(comp.getName(), comp.getVersion(), comp.getPatchLevel(), InventoryComponentInfo.Action.REMOVE);
        if (componentsToRemove != null) {
            componentsToRemove.put(invCompInfo, comp);
        }
        return invCompInfo;
    }

    private void processComponentFiles(InternalPatchHandler patchHandler, Map<InventoryComponentInfo, Component> components, Mode mode) throws GdrException {
        Set platIds = PlatformInfoHelper.getInstance().getPlatformIds();
        ServiceHolder serviceHolder = new ServiceHolder(platIds, null, null);
        for (Map.Entry<InventoryComponentInfo, Component> compEntry : components.entrySet()) {
            if (!compEntry.getKey().getComponentCheckResult().getResult().isProcessComponent()) continue;
            HashSet<FeatureSet> parentFeatureSets = new HashSet<FeatureSet>();
            for (Map.Entry<FeatureSet, Set<Component>> featureEntry : patchHandler.getComponentMetaDataPatchHandler().getFeatureSetMap().entrySet()) {
                if (!featureEntry.getValue().contains(compEntry.getValue())) continue;
                parentFeatureSets.add(featureEntry.getKey());
            }
            for (FeatureSet feature : parentFeatureSets) {
                for (Map.Entry<Distribution, Set<FeatureSet>> distEntry : patchHandler.getFeatureSetMetaDataPatchHandler().getDistributionMap().entrySet()) {
                    if (!distEntry.getValue().contains(feature)) continue;
                    Component comp = compEntry.getValue();
                    Collection<ComponentTarget> targets = FeatureSetHelper.getInstance().getComponentTargets(mode, comp, distEntry.getKey().getDirectoryMap(), serviceHolder);
                    for (ComponentTarget compTarget : targets) {
                        for (FileTarget fileTarget : compTarget.getFileTargets()) {
                            if (!fileTarget.isFile()) continue;
                            Path affectedFile = this.getHome().getHomePath().resolve(fileTarget.getDest());
                            if (mode.isInstallMode()) {
                                if (Files.exists(affectedFile, new LinkOption[0])) {
                                    compEntry.getKey().addAffectedFile(FileState.MODIFIED, affectedFile);
                                    continue;
                                }
                                compEntry.getKey().addAffectedFile(FileState.ADDED, affectedFile);
                                continue;
                            }
                            if (!mode.isDeInstallMode() || !Files.exists(affectedFile, new LinkOption[0])) continue;
                            compEntry.getKey().addAffectedFile(FileState.DELETED, affectedFile);
                        }
                    }
                }
            }
        }
    }

    public Map<String, List<oracle.glcm.opatch.common.api.install.ComponentInfo>> getPatchComponentsInOHForRollback(List<String> uniquePatchIds) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "getPatchComponentsInOHForRollback");
        Home home = this.getHome();
        HashMap<String, List<oracle.glcm.opatch.common.api.install.ComponentInfo>> homeComponentInfos = new HashMap<String, List<oracle.glcm.opatch.common.api.install.ComponentInfo>>();
        if (uniquePatchIds != null && !uniquePatchIds.isEmpty()) {
            for (String upi : new HashSet<String>(uniquePatchIds)) {
                HashMap<ComponentReference, Integer> referenceCountMap = new HashMap<ComponentReference, Integer>();
                Map<ComponentInfo, SessionInfo> componentInfosForPatch = home.getRegistryHelper().getComponentInfosSessionMapForPatch(home.getRegistry(), upi);
                for (Map.Entry<ComponentInfo, SessionInfo> entry : componentInfosForPatch.entrySet()) {
                    ComponentInfo componentInfo = entry.getKey();
                    ComponentReference reference = new ComponentReference(componentInfo.getName(), componentInfo.getVersion());
                    if (entry.getValue().getAction() == SessionAction.upgrade) {
                        reference.setPatchLevel(componentInfo.getPatchLevel());
                        Integer refCount = (Integer)referenceCountMap.get((Object)reference);
                        refCount = refCount == null ? 1 : refCount + 1;
                        referenceCountMap.put(reference, refCount);
                        continue;
                    }
                    referenceCountMap.put(reference, 1);
                }
                ArrayList<oracle.glcm.opatch.common.api.install.ComponentInfo> componentInfos = new ArrayList<oracle.glcm.opatch.common.api.install.ComponentInfo>();
                for (Map.Entry entry : referenceCountMap.entrySet()) {
                    ComponentReference componentReference = (ComponentReference)((Object)entry.getKey());
                    componentInfos.add(this._homeOperationsFactory.getComponentInfo(componentReference.getName(), componentReference.getVersion(), componentReference.getPatchLevel(), ((Integer)entry.getValue()).intValue()));
                }
                homeComponentInfos.put(upi, componentInfos);
            }
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "getPatchComponentsInOHForRollback");
        return homeComponentInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, List<InventoryComponentInfo>> getRollbackInventoryComponents(List<String> uniquePatchIds) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "getRollbackInventoryComponents");
        Home home = this.getHome();
        HashMap<String, List<InventoryComponentInfo>> inventoryComponentInfos = new HashMap<String, List<InventoryComponentInfo>>();
        if (uniquePatchIds != null && !uniquePatchIds.isEmpty()) {
            for (String upi : new HashSet<String>(uniquePatchIds)) {
                ComponentCheckResult result;
                InventoryComponentInfo inventoryCompInfo;
                HashMap<ComponentReference, Integer> referenceCountMap = new HashMap<ComponentReference, Integer>();
                HashMap<ComponentReference, SessionAction> actionMap = new HashMap<ComponentReference, SessionAction>();
                Map<ComponentInfo, SessionInfo> componentInfosForPatch = home.getRegistryHelper().getAllComponentInfosSessionMapForPatch(home.getRegistry(), upi);
                for (Map.Entry<ComponentInfo, SessionInfo> entry : componentInfosForPatch.entrySet()) {
                    ComponentInfo componentInfo = entry.getKey();
                    ComponentReference reference = new ComponentReference(componentInfo.getName(), componentInfo.getVersion());
                    reference.setPatchLevel(componentInfo.getPatchLevel());
                    Integer refCount = (Integer)referenceCountMap.get((Object)reference);
                    refCount = refCount == null ? 1 : refCount + 1;
                    referenceCountMap.put(reference, refCount);
                    actionMap.put(reference, entry.getValue().getAction());
                }
                ArrayList<InventoryComponentInfo> componentInfos = new ArrayList<InventoryComponentInfo>();
                for (Map.Entry entry : referenceCountMap.entrySet()) {
                    InventoryComponentInfo.Action action;
                    ComponentReference componentReference = (ComponentReference)((Object)entry.getKey());
                    SessionAction sessionAction = (SessionAction)((Object)actionMap.get(entry.getKey()));
                    if (sessionAction == null) {
                        _log.severe("A failure occurred while rolling back patch: " + upi + ". Session action for component " + componentReference + " was null");
                        throw new HomeOperationsException("A failure occurred while rolling back patch: " + upi + ". Session action for component " + componentReference + " was null");
                    }
                    if (sessionAction == SessionAction.upgrade || sessionAction == SessionAction.patch) {
                        action = InventoryComponentInfo.Action.PATCH;
                    } else if (sessionAction == SessionAction.install) {
                        action = InventoryComponentInfo.Action.ADD;
                    } else {
                        if (sessionAction != SessionAction.deinstall) {
                            _log.severe("A failure occurred while rolling back patch: " + upi + ". Session action " + (Object)((Object)sessionAction) + " for component " + componentReference + " is not recognized.");
                            throw new HomeOperationsException("A failure occurred while rolling back patch: " + upi + ". Session action " + (Object)((Object)sessionAction) + " for component " + componentReference + " is not recognized.");
                        }
                        action = InventoryComponentInfo.Action.REMOVE;
                    }
                    inventoryCompInfo = this._homeOperationsFactory.getInventoryComponentInfo(componentReference.getName(), componentReference.getVersion(), componentReference.getPatchLevel(), action, ((Integer)entry.getValue()).intValue());
                    result = PatchFactoryImpl.instance().createComponentCheckResult((PatchInventory.Component)new ComponentWrapper((oracle.glcm.opatch.common.api.install.ComponentInfo)inventoryCompInfo));
                    result.setResult(Result.PROCESS_COMPONENT);
                    inventoryCompInfo.setComponentCheckResult(result);
                    componentInfos.add(inventoryCompInfo);
                }
                if (componentInfosForPatch.isEmpty()) {
                    _log.info("UPI " + upi + " not found in the registry, searching for patch-id");
                    try {
                        List<ComponentInfo> compInfos;
                        List list = oracle.glcm.opatch.common.helpers.PatchHelper.getPatchesInOH((String)this._home.toString());
                        String patchId = null;
                        if (list != null && !list.isEmpty()) {
                            for (Patch patch : list) {
                                if (!patch.getPatchUpi().equals(upi)) continue;
                                patchId = patch.getPatchId();
                                _log.info("Patch-id " + patchId + " found for UPI " + upi);
                                break;
                            }
                        }
                        if (!StringUtil.isNullOrEmpty(patchId, (boolean)true) && (compInfos = home.getRegistryHelper().getComponentInfosForPatchId(this._home.getRegistry(), patchId)) != null && !compInfos.isEmpty()) {
                            for (ComponentInfo compInfo : compInfos) {
                                inventoryCompInfo = this._homeOperationsFactory.getInventoryComponentInfo(compInfo.getName(), compInfo.getVersion(), compInfo.getPatchLevel(), InventoryComponentInfo.Action.PATCH, 1);
                                result = PatchFactoryImpl.instance().createComponentCheckResult((PatchInventory.Component)new ComponentWrapper((oracle.glcm.opatch.common.api.install.ComponentInfo)inventoryCompInfo));
                                result.setResult(Result.PROCESS_COMPONENT);
                                inventoryCompInfo.setComponentCheckResult(result);
                                componentInfos.add(inventoryCompInfo);
                            }
                        }
                    }
                    catch (InvalidPatchMetadataException | PatchMetadataLoadingException | PatchNotFoundException throwable) {
                        throw new HomeOperationsException("A failure occured while loading patches from Oracle Home: " + this._home, throwable);
                    }
                }
                inventoryComponentInfos.put(upi, componentInfos);
            }
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "getRollbackInventoryComponents");
        return inventoryComponentInfos;
    }

    public void processPatch(PatchInfo patchInfo) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "processPatch");
        ArrayList<PatchInfo> patchInfos = new ArrayList<PatchInfo>();
        patchInfos.add(patchInfo);
        this.processPatches(patchInfos);
        _log.exiting(((Object)((Object)this)).getClass().getName(), "processPatch");
    }

    public void processPatches(List<PatchInfo> patchInfos) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "processPatches");
        HashSet affectedLibraryPaths = new HashSet();
        for (PatchInfo patchInfo : patchInfos) {
            try {
                List inventoryComps;
                InternalPatchHandler patchHandler = this._patchHandlerCache.get(new PatchHandlerKey(patchInfo.getPatchUpi(), this.getHome()));
                if (patchHandler == null) {
                    patchHandler = PatchHandlerFactory.getInternalPatchHandler(this.getHome());
                    if (patchInfo.getInventoryComponents() != null) {
                        for (InventoryComponentInfo componentInfo : patchInfo.getInventoryComponents()) {
                            if (!"oracle.nextgen.metadata".equals(componentInfo.getName())) continue;
                            this.loadMetaData(patchInfo.getPatchUpi(), (List)componentInfo.getAffectedFilePaths().get(FileState.ADDED), patchHandler);
                            break;
                        }
                    }
                }
                PatchInfoWrapper patch = new PatchInfoWrapper(patchInfo);
                PatchCheckResults results = BasePatchFactory.instance().getPatchCheckResults((Patch)patch);
                Map patchComponents = patchInfo.getPatchComponents();
                for (Map.Entry entry : patchComponents.entrySet()) {
                    results.setResult((PatchInventory.Component)new ComponentWrapper((oracle.glcm.opatch.common.api.install.ComponentInfo)entry.getKey()), ((ComponentCheckResult)entry.getValue()).getResult(), ((ComponentCheckResult)entry.getValue()).getDetails());
                }
                HashMap<FileState, List<Path>> affectedFilePaths = new HashMap<FileState, List<Path>>();
                Map affectedFiles = patchInfo.getAffectedPaths();
                if (affectedFiles != null) {
                    for (Map.Entry entry : affectedFiles.entrySet()) {
                        List paths = (List)entry.getValue();
                        if (paths == null) continue;
                        affectedFilePaths.put((FileState)entry.getKey(), paths);
                        affectedLibraryPaths.addAll(paths);
                    }
                }
                HashMap<ComponentReference, Map<Path, Path>> overwrittenFiles = new HashMap<ComponentReference, Map<Path, Path>>();
                if (patchInfo.isRollBack() && (inventoryComps = patchInfo.getInventoryComponents()) != null && !inventoryComps.isEmpty()) {
                    for (InventoryComponentInfo comp : inventoryComps) {
                        if (!comp.getAction().isAdd()) continue;
                        List modifiedFiles = (List)comp.getAffectedFilePaths().get(FileState.MODIFIED);
                        Map backupFiles = comp.getBackupFilePaths();
                        HashMap<Path, Path> modifiedFilesMap = new HashMap<Path, Path>();
                        if (modifiedFiles == null || modifiedFiles.isEmpty() || backupFiles == null || backupFiles.isEmpty()) continue;
                        ComponentReference compRef = new ComponentReference(comp.getName(), comp.getVersion());
                        compRef.setPatchLevel(comp.getPatchLevel());
                        for (Path modifiedFile : modifiedFiles) {
                            Path backupFile = (Path)backupFiles.get(modifiedFile);
                            if (backupFile != null) {
                                modifiedFilesMap.put(modifiedFile, backupFile);
                                continue;
                            }
                            _log.warning("No backup found for file " + modifiedFile);
                        }
                        overwrittenFiles.put(compRef, modifiedFilesMap);
                    }
                }
                patchHandler.setStringSubsEnvHandler(new StringSubsEnvHandlerImpl(this._home.getHome().getAbsolutePath(), null));
                patchHandler.processPatchUsingPaths(patch, patchInfo.isRollBack(), affectedFilePaths, overwrittenFiles, results, patchInfo.isMetaDataPatch(), true);
            }
            catch (Exception e) {
                throw new HomeOperationsException("A failure occurred while processing patch: " + patchInfo.getPatchId(), (Throwable)e);
            }
        }
        try {
            PatchHandlerImpl patchHandler = new PatchHandlerImpl(this.getHome());
            patchHandler.regenerateLibraries(null, new ArrayList<Path>(affectedLibraryPaths));
        }
        catch (GdrException e) {
            throw new HomeOperationsException("A failure occurred while regenerating libraries.", (Throwable)e);
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "processPatches");
    }

    private void loadMetaData(String uniquePatchID, List<Path> metaDataPaths, InternalPatchHandler patchHandler) throws HomeOperationsException {
        try {
            for (Path metaDataPath : metaDataPaths) {
                String absolutePath = FileUtils.formatPath(metaDataPath.toAbsolutePath().toString(), "/");
                if (this.matchesComponentInstall(uniquePatchID, absolutePath)) {
                    this.processInventoryComponentInfoForInstall(metaDataPath, null, patchHandler);
                    continue;
                }
                if (this.matchesComponentDeinstall(uniquePatchID, absolutePath)) {
                    this.processInventoryComponentInfoForDeinstall(metaDataPath, null, patchHandler);
                    continue;
                }
                if (this.matchesFeatureSetInstall(uniquePatchID, absolutePath)) {
                    patchHandler.getFeatureSetMetaDataPatchHandler().getPatchMetaDataFeatureSet(metaDataPath);
                    continue;
                }
                if (this.matchesFeatureSetDeinstall(uniquePatchID, absolutePath)) {
                    patchHandler.getFeatureSetMetaDataPatchHandler().getPatchMetaDataFeatureSet(metaDataPath);
                    continue;
                }
                if (this.matchesFeatureSetUpgrade(uniquePatchID, absolutePath)) {
                    patchHandler.getFeatureSetMetaDataPatchHandler().getPatchMetaDataFeatureSet(metaDataPath);
                    continue;
                }
                if (!this.matchesDistributionUpgrade(uniquePatchID, absolutePath)) continue;
                patchHandler.getDistributionMetaDataPatchHandler().getPatchMetaDataDistribution(metaDataPath);
            }
            patchHandler.getDistributionMetaDataPatchHandler().analyzeUpgradePatches();
            patchHandler.getFeatureSetMetaDataPatchHandler().analyzeUpgradePatches();
            patchHandler.getComponentMetaDataPatchHandler().analyzeUpgradePatches();
        }
        catch (DataHandlerException | GdrException | IOException e) {
            _log.log(Level.SEVERE, "A failure occurred while loading metadata for patch: " + uniquePatchID, e);
            throw new HomeOperationsException("A failure occurred while loading metadata for patch: " + uniquePatchID, e);
        }
    }

    public VersionInfo getVersionInfo() throws HomeOperationsException {
        return HomeOperationsFactory.getInstance().getVersionInfo(Version.getReleaseVersion(), true, true);
    }

    public void addPatchToInventory(PatchInfo patchInfo) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "addPatchToInventory");
        if (patchInfo != null) {
            String patchId = patchInfo.getPatchId();
            if (this._removedPatchInfos != null) {
                this._removedPatchInfos.remove(patchId);
            }
            if (this._addedPatchInfos == null) {
                this._addedPatchInfos = new LinkedHashMap<String, PatchInfo>();
            }
            this._addedPatchInfos.put(patchId, patchInfo);
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "addPatchToInventory");
    }

    public Map<String, PatchInfo> getAddedPatchInfos() {
        return this._addedPatchInfos;
    }

    public void removePatchFromInventory(PatchInfo patchInfo) throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "removePatchFromInventory");
        if (patchInfo != null) {
            String patchId = patchInfo.getPatchId();
            if (this._addedPatchInfos != null) {
                this._addedPatchInfos.remove(patchId);
            }
            if (this._removedPatchInfos == null) {
                this._removedPatchInfos = new LinkedHashMap<String, PatchInfo>();
            }
            this._removedPatchInfos.put(patchId, patchInfo);
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "removePatchFromInventory");
    }

    public Map<String, PatchInfo> getRemovedPatchInfos() {
        return this._removedPatchInfos;
    }

    private void resetAddRemovePatchInfos() {
        this._addedPatchInfos = null;
        this._removedPatchInfos = null;
    }

    public void saveInventory() throws HomeOperationsException {
        _log.entering(((Object)((Object)this)).getClass().getName(), "saveInventory");
        Path patchesDir = null;
        Map<String, PatchInfo> addedPatchInfos = this.getAddedPatchInfos();
        Map<String, PatchInfo> removedPatchInfos = this.getRemovedPatchInfos();
        if (addedPatchInfos != null || removedPatchInfos != null) {
            PatchLockedRegistryHandler patchLockedRegistryHandler;
            block23: {
                patchLockedRegistryHandler = new PatchLockedRegistryHandler(this.getHome());
                try {
                    Collection<ComponentInfo> installedComponentInfos;
                    RegistryHelper registryHelper = RegistryHelper.getInstance(this.getHome().getClassLoader());
                    try {
                        installedComponentInfos = registryHelper.getInstalledComponentInfos(patchLockedRegistryHandler.getLockedRegistry());
                    }
                    catch (GdrException e) {
                        throw new HomeOperationsException("Failed to get locked registry for home: " + this.getHomeDir(), (Throwable)e);
                    }
                    if (addedPatchInfos != null) {
                        for (PatchInfo patchInfo : addedPatchInfos.values()) {
                            if (patchesDir == null) {
                                patchesDir = this.getHome().getInventoryDirectoryPath().resolve("patches");
                            }
                            com.oracle.cie.gdr.dao.pch.Patch patch = this.getPatch(patchInfo);
                            Path patchFile = patchesDir.resolve(PatchHelper.getInstance().getPatchFileName(patchInfo.getPatchId()));
                            try {
                                PatchHelper.getInstance().save(patch, patchFile);
                            }
                            catch (DataHandlerException e) {
                                throw new HomeOperationsException("Failed to save patch to inventory: " + patchFile, (Throwable)e);
                            }
                            Map patchComponents = patchInfo.getPatchComponents();
                            if (patchComponents == null || patchComponents.isEmpty()) continue;
                            for (oracle.glcm.opatch.common.api.install.ComponentInfo componentInfo : patchComponents.keySet()) {
                                List<ComponentInfo> regCompInfos = registryHelper.getComponentInfos(installedComponentInfos, componentInfo.getName(), componentInfo.getVersion(), false);
                                for (ComponentInfo regCompInfo : regCompInfos) {
                                    regCompInfo.removePatches(Collections.singletonList(patch));
                                    regCompInfo.addPatch(patch);
                                }
                            }
                        }
                    }
                    if (removedPatchInfos == null) break block23;
                    for (PatchInfo patchInfo : removedPatchInfos.values()) {
                        Map patchComponents;
                        Path patchFile;
                        if (patchesDir == null) {
                            patchesDir = this.getHome().getInventoryDirectoryPath().resolve("patches");
                        }
                        if (Files.exists(patchFile = patchesDir.resolve(PatchHelper.getInstance().getPatchFileName(patchInfo.getPatchId())), new LinkOption[0])) {
                            try {
                                Files.delete(patchFile);
                            }
                            catch (IOException e) {
                                throw new HomeOperationsException("Failed remove patch from inventory: " + patchFile, (Throwable)e);
                            }
                        }
                        if ((patchComponents = patchInfo.getPatchComponents()) == null || patchComponents.isEmpty()) continue;
                        for (oracle.glcm.opatch.common.api.install.ComponentInfo componentInfo : patchComponents.keySet()) {
                            List<ComponentInfo> regCompInfos = registryHelper.getComponentInfos(installedComponentInfos, componentInfo.getName(), componentInfo.getVersion(), false);
                            for (ComponentInfo regCompInfo : regCompInfos) {
                                regCompInfo.removePatches(Collections.singletonList(new com.oracle.cie.gdr.dao.pch.Patch(patchInfo.getPatchId(), this.getHome().getClassLoader())));
                            }
                        }
                    }
                }
                catch (HomeOperationsException e) {
                    try {
                        patchLockedRegistryHandler.unlockRegistry(false);
                    }
                    catch (GdrException ex) {
                        _log.log(Level.SEVERE, "Failed to unlock registry for home: " + this.getHomeDir(), e);
                    }
                    throw e;
                }
            }
            this.resetAddRemovePatchInfos();
            try {
                patchLockedRegistryHandler.unlockRegistry(true);
            }
            catch (GdrException e) {
                throw new HomeOperationsException("Failed to unlock, persist and reload registry for home: " + this.getHomeDir(), (Throwable)e);
            }
        }
        _log.exiting(((Object)((Object)this)).getClass().getName(), "saveInventory");
    }

    public Set<PatchInfo> getInstalledPatchesFromInventory() {
        return new HashSet<PatchInfo>(this.getInstalledPatches(null).values());
    }

    public Map<String, PatchInfo> getInstalledPatchesFromInventory(Set<String> uniquePatchIds) {
        return uniquePatchIds == null || uniquePatchIds.isEmpty() ? new HashMap<String, PatchInfo>() : this.getInstalledPatches(uniquePatchIds);
    }

    public void initialize(SessionMode mode) throws HomeOperationsException {
    }

    public void close() {
    }

    public boolean isInitialized() {
        return true;
    }

    protected Map<String, PatchInfo> getInstalledPatches(Set<String> uniquePatchIds) {
        HashMap<String, PatchInfo> installedPatches = new HashMap<String, PatchInfo>();
        Collection<com.oracle.cie.gdr.dao.pch.Patch> patches = null;
        try {
            patches = this.getHome().getInstalledPatches();
        }
        catch (GdrException e) {
            _log.log(Level.WARNING, "Failed to get installed patches from home " + this.getHome(), e);
        }
        if (patches != null) {
            for (com.oracle.cie.gdr.dao.pch.Patch patch : patches) {
                String uniquePatchId = patch.getUniquePatchId();
                if (uniquePatchIds != null && !uniquePatchIds.contains(uniquePatchId)) continue;
                installedPatches.put(uniquePatchId, this.getPatchInfo(patch));
            }
        }
        return installedPatches;
    }

    public com.oracle.cie.gdr.dao.pch.Patch getPatch(PatchInfo patchInfo) {
        List languages;
        List preReqs;
        List bugs;
        com.oracle.cie.gdr.dao.pch.Patch patch = new com.oracle.cie.gdr.dao.pch.Patch(this.getHome().getClassLoader());
        patch.setPatchId(patchInfo.getPatchId());
        patch.setUniquePatchId(patchInfo.getPatchUpi());
        patch.setDescription(patchInfo.getDescription());
        patch.setStatus(Status.installed);
        patch.setInstallDate(Calendar.getInstance());
        patch.setInstallerVersion(Version.getReleaseVersion());
        patch.setLocation("oneoffs" + File.separator + patchInfo.getPatchId());
        patch.setRollbackable(true);
        Map patchComponents = patchInfo.getPatchComponents();
        if (patchComponents != null && !patchComponents.isEmpty()) {
            ArrayList<ComponentReference> compRefs = new ArrayList<ComponentReference>();
            for (oracle.glcm.opatch.common.api.install.ComponentInfo componentInfo : patchComponents.keySet()) {
                compRefs.add(new ComponentReference(componentInfo.getName(), componentInfo.getVersion(), this.getHome().getClassLoader()));
            }
            patch.setComponents(compRefs);
        }
        if ((bugs = patchInfo.getBugList()) != null && !bugs.isEmpty()) {
            BugList bugList = new BugList(this.getHome().getClassLoader());
            bugList.setBugs(bugs.toArray(new String[bugs.size()]));
            patch.setBugList(bugList);
        }
        if ((preReqs = patchInfo.getPreReqs()) != null && !preReqs.isEmpty()) {
            patch.setPatchDependencies(new PatchDependencies(preReqs.toArray(new String[preReqs.size()]), this.getHome().getClassLoader()));
        }
        if ((languages = patchInfo.getLanguages()) != null && !languages.isEmpty()) {
            ArrayList<com.oracle.cie.gdr.dao.pch.Locale> localeDaos = new ArrayList<com.oracle.cie.gdr.dao.pch.Locale>();
            for (Locale locale : languages) {
                localeDaos.add(new com.oracle.cie.gdr.dao.pch.Locale(locale, this.getHome().getClassLoader()));
            }
            patch.setLocales(localeDaos);
        }
        return patch;
    }

    public PatchInfo getPatchInfo(com.oracle.cie.gdr.dao.pch.Patch patch) {
        String[] patchIds;
        String[] bugs;
        HashMap<oracle.glcm.opatch.common.api.install.ComponentInfo, ComponentCheckResult> patchComponents = new HashMap<oracle.glcm.opatch.common.api.install.ComponentInfo, ComponentCheckResult>();
        List<ComponentReference> componentReferences = patch.getComponents();
        if (componentReferences != null) {
            for (ComponentReference componentReference : componentReferences) {
                oracle.glcm.opatch.common.api.install.ComponentInfo componentInfo = HomeOperationsFactory.getInstance().getComponentInfo(componentReference.getName(), componentReference.getVersion());
                patchComponents.put(componentInfo, PatchFactoryImpl.instance().createComponentCheckResult((PatchInventory.Component)new ComponentWrapper(componentInfo)));
            }
        }
        ArrayList<String> bugList = new ArrayList<String>();
        BugList patchBugList = patch.getBugList();
        if (patchBugList != null && (bugs = patchBugList.getBugs()) != null && bugs.length > 0) {
            bugList.addAll(Arrays.asList(bugs));
        }
        ArrayList<String> preReqs = new ArrayList<String>();
        PatchDependencies patchDependencies = patch.getPatchDependencies();
        if (patchDependencies != null && (patchIds = patchDependencies.getPatchIds()) != null && patchIds.length > 0) {
            preReqs.addAll(Arrays.asList(patchIds));
        }
        ArrayList<Locale> languages = new ArrayList<Locale>();
        List<com.oracle.cie.gdr.dao.pch.Locale> locales = patch.getLocales();
        if (locales != null) {
            for (com.oracle.cie.gdr.dao.pch.Locale locale : locales) {
                String lang = locale.getLanguage();
                if (lang == null || lang.isEmpty()) continue;
                String country = locale.getCountry();
                languages.add(new Locale(lang, country != null ? country : ""));
            }
        }
        return HomeOperationsFactory.getInstance().getPatchInfoWithPaths(patch.getPatchId(), patch.getUniquePatchId(), null, patchComponents, null, false, bugList, patch.getDescription(), preReqs, languages, null, patch.getInstallDate());
    }

    class PatchHandlerKey {
        private String _patchId;
        private Home _home;

        public PatchHandlerKey(String patchId, Home home) {
            this._patchId = patchId;
            this._home = home;
        }

        public String getPatchId() {
            return this._patchId;
        }

        public Home getHome() {
            return this._home;
        }

        public int hashCode() {
            return this._patchId.hashCode() + 31 * this._home.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PatchHandlerKey)) {
                return false;
            }
            PatchHandlerKey that = (PatchHandlerKey)o;
            String thisPatchId = this.getPatchId();
            Home thisHome = this.getHome();
            String thatPatchId = that.getPatchId();
            Home thatHome = that.getHome();
            return !(thisPatchId == null ? thatPatchId != null : !thisPatchId.equals(thatPatchId)) && !(thisHome == null ? thatHome != null : !thisHome.equals(thatHome));
        }
    }

    public static class ComponentWrapper
    implements PatchInventory.Component {
        private oracle.glcm.opatch.common.api.install.ComponentInfo _componentInfo;

        public ComponentWrapper(oracle.glcm.opatch.common.api.install.ComponentInfo componentInfo) {
            this._componentInfo = componentInfo;
        }

        public String getName() {
            return this._componentInfo.getName();
        }

        public String getVersion() {
            return this._componentInfo.getVersion();
        }

        public String getPatchLevel() {
            return this._componentInfo.getPatchLevel();
        }

        public Boolean isRequired() {
            return false;
        }

        public String getOptString() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ComponentWrapper)) {
                return false;
            }
            ComponentWrapper that = (ComponentWrapper)o;
            return this._componentInfo.equals(that._componentInfo);
        }

        public int hashCode() {
            return this._componentInfo.hashCode();
        }

        public String toString() {
            return this._componentInfo.toString();
        }
    }

    class PatchInfoWrapper
    implements Patch {
        private PatchInfo _patchInfo;

        public PatchInfoWrapper(PatchInfo patchInfo) {
            this._patchInfo = patchInfo;
        }

        public PatchType getPatchType() {
            return PatchType.SINGLETON_PATCH;
        }

        public PatchSubType getPatchSubType() {
            return this._patchInfo.getPatchSubType();
        }

        public String getPatchId() {
            return this._patchInfo.getPatchId();
        }

        public String getPatchUpi() {
            return this._patchInfo.getPatchUpi();
        }

        public List<PatchInventory.Component> getComponents() {
            ArrayList<PatchInventory.Component> components = new ArrayList<PatchInventory.Component>();
            Map patchComponents = this._patchInfo.getPatchComponents();
            if (patchComponents != null) {
                for (oracle.glcm.opatch.common.api.install.ComponentInfo componentInfo : patchComponents.keySet()) {
                    components.add(new ComponentWrapper(componentInfo));
                }
            }
            return components;
        }

        public List<InventoryComponentInfo> getInventoryComponents() {
            return this._patchInfo.getInventoryComponents();
        }

        public List<PatchDeployArtifact> getPatchDeployArtifacts() {
            return null;
        }

        public List<PatchInventory> getPatchInventories() {
            return null;
        }

        public void cloneMetadata(String destinationPatchLoc) throws PatchMetadataWritingException {
        }

        public List<Patch> getSubPatches() {
            return null;
        }

        public String createHash() {
            return null;
        }

        public boolean verifyHash() {
            return false;
        }

        public String getPatchDescription() {
            return null;
        }

        public List<PatchActions> getActions() {
            return null;
        }

        public List<PatchChecksum> getChecksums() {
            return null;
        }

        public List<PatchAutomation> getAutomations() {
            return null;
        }

        public List<String> getOrderedSubPatchId() {
            return null;
        }

        public String getPatchLocation() {
            return null;
        }

        public SystemPatchBundle getSystemPatchBundle() {
            return null;
        }

        public List<MaintenanceAliasActionHolder> getMaintenanceAliasActionHolders() {
            return null;
        }
    }
}

