/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class ChecksumCache {
    private static final String DEFAULT_CHECKSUM_ALGORITHM = System.getProperty("ChecksumCache.default.checksum.algorithm", "SHA-1");
    private Map<Path, String> _checksumCache = new HashMap<Path, String>();
    private Map<String, Path> _dupCheckMap = new HashMap<String, Path>();
    private ByteBuffer _buffer;

    public String getChecksum(Path path) throws IOException {
        String checksum = this._checksumCache.get(path);
        if (checksum == null) {
            checksum = this.checksum(path);
            this._checksumCache.put(path, checksum);
        }
        return checksum;
    }

    public Path getDupCheckPath(Path path) throws IOException {
        String checksum = this.getChecksum(path);
        Path dupPath = this._dupCheckMap.get(checksum);
        if (dupPath == null) {
            this._dupCheckMap.put(checksum, path);
            return null;
        }
        return dupPath;
    }

    public String checksum(Path path) throws IOException {
        return this.checksum(path, DEFAULT_CHECKSUM_ALGORITHM);
    }

    public synchronized String checksum(Path path, String algorithm) throws IOException {
        String string;
        block10: {
            FileChannel fc = FileChannel.open(path, new OpenOption[0]);
            try {
                if (this._buffer == null) {
                    this._buffer = ByteBuffer.allocate(8192);
                }
                MessageDigest md = MessageDigest.getInstance(algorithm);
                while (true) {
                    this._buffer.clear();
                    int i = fc.read(this._buffer);
                    if (i < 1) break;
                    this._buffer.flip();
                    md.update(this._buffer);
                }
                this._buffer.clear();
                string = DatatypeConverter.printHexBinary((byte[])md.digest()).toLowerCase();
                if (fc == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Failed to calculate checksum for path: " + path, e);
                }
            }
            fc.close();
        }
        return string;
    }
}

