/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class RuntimeExecShutdownHook {
    public static boolean _isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
    private static boolean _hookRegistered;
    private static List<Exec> _execs;

    public static List<Exec> getExecs() {
        return _execs;
    }

    public static void addExec(List<String> commands) {
        RuntimeExecShutdownHook.addExec(commands, null, false);
    }

    public static void addExec(List<String> commands, File workingDir) {
        RuntimeExecShutdownHook.addExec(commands, workingDir, false);
    }

    public static void addExec(List<String> commands, File workingDir, boolean useShell) {
        RuntimeExecShutdownHook.addExec(commands, workingDir, null, useShell);
    }

    public static void addExec(List<String> commands, File workingDir, Map<String, String> env, boolean useShell) {
        RuntimeExecShutdownHook.addExec(new Exec(commands, workingDir, env, useShell));
    }

    public static void addExec(Exec exec) {
        if (exec != null) {
            if (!_hookRegistered) {
                RuntimeExecShutdownHook.registerShutdownHook();
            }
            _execs.add(exec);
        }
    }

    private static void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RuntimeExecShutdownHook.runHooks();
            }
        });
        _hookRegistered = true;
    }

    static void runHooks() {
        List<Exec> execs = RuntimeExecShutdownHook.getExecs();
        if (execs != null && !execs.isEmpty()) {
            for (Exec exec : execs) {
                System.out.println("Executing: " + exec);
                if (!exec.hasCommands()) continue;
                ArrayList<String> commands = new ArrayList<String>();
                if (exec.isUseShell()) {
                    if (_isWindows) {
                        commands.add("CMD");
                        commands.add("/C");
                    } else {
                        commands.add("sh");
                        commands.add("-c");
                    }
                }
                commands.addAll(exec.getCommands());
                ProcessBuilder pb = new ProcessBuilder(commands);
                pb.directory(exec.getWorkingDir());
                if (exec.hasEnv()) {
                    Map<String, String> env = pb.environment();
                    env.putAll(exec.getEnv());
                }
                try {
                    Process p = pb.start();
                    p.getInputStream();
                    p.getErrorStream();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.addAll(Arrays.asList(args));
            RuntimeExecShutdownHook.addExec(commands);
        }
    }

    static {
        _execs = new ArrayList<Exec>();
    }

    public static class Exec {
        private List<String> _commands;
        private File _workingDir;
        private Map<String, String> _env;
        private boolean _useShell;

        public Exec(List<String> commands, File workingDir, Map<String, String> env, boolean useShell) {
            this._commands = commands;
            this._workingDir = workingDir;
            this._env = env;
            this._useShell = useShell;
        }

        public List<String> getCommands() {
            return this._commands;
        }

        public boolean hasCommands() {
            return this._commands != null && !this._commands.isEmpty();
        }

        public File getWorkingDir() {
            return this._workingDir;
        }

        public Map<String, String> getEnv() {
            return this._env;
        }

        public boolean hasEnv() {
            return this._env != null && !this._env.isEmpty();
        }

        public boolean isUseShell() {
            return this._useShell;
        }
    }
}

