/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.patch.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import model.bundle_xml.SystemPatchBundleXML;
import model.patchmodel.Bundle;
import model.patchmodel.CompositePatch;
import model.patchmodel.EngineeredSystemPatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import model.patchmodel.PatchBundle;
import model.patchmodel.PatchPackage;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import model.util.BundleXmlHelper;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.core.patch.CompositePatchValidatorAndGenerator;
import oracle.oplan.core.patch.EngineeredSystemPatchGeneratorForZip;
import oracle.oplan.core.patch.OPatchBundlePatchValidatorAndGenerator;
import oracle.oplan.core.patch.OPatchSingletonPatchValidatorAndGenerator;
import oracle.oplan.core.patch.OPlanTarArchiveInputStreamMapConstructor;
import oracle.oplan.core.patch.OPlanZipStreamMapConstructor;
import oracle.oplan.core.patch.SupportedPatchTools;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.patch.PatchBundlexml;
import oracle.oplan.sdk.patch.PatchPackageFactory;
import oracle.oplan.sdk.patch.PatchPackagesBag;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.osysmodel.patchsdk.PatchFactory;
import oracle.osysmodel.patchsdk.PatchPackageException;
import oracle.osysmodel.patchsdk.PatchValidatorAndGenerator;
import oracle.osysmodel.patchsdk.TarArchiveStreamMapConstructor;
import oracle.osysmodel.patchsdk.ZipStreamMapConstructor;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchPackageFactoryImpl
extends PatchPackageFactory {
    static Logger logger = Logger.getLogger(PatchPackageFactoryImpl.class.getName());

    @Override
    public PatchPackage getPatchPackageFromDir(File patchDir) throws PatchPackageException {
        OPlan.getInstance().getLogger().setupLogs();
        logger.log(Level.INFO, "Entering getPatchPackageFromDir, getting patch object for the given patch location " + patchDir.getAbsolutePath());
        assert (patchDir != null);
        assert (patchDir.isDirectory());
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        for (PatchValidatorAndGenerator vg : SupportedPatchTools.getSupportedPatchValidatorsAndGenerators()) {
            logger.log(Level.INFO, "Adding PatchValidatorAndGenerator " + vg.getClass().toString());
            pf.addPatchValidatorAndGenerator(vg);
        }
        PatchPackage patch = pf.getInstance(patchDir.getAbsolutePath());
        if (patch == null) {
            throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
        }
        if (patch instanceof GenericPatch) {
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            applicableTarget.add(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().getDefaultApplicableTarget());
            if (patch instanceof OPatchSingleton) {
                OPatchSingletonPatchValidatorAndGenerator.addApplicabilityTargets((OPatchSingleton)patch, applicableTarget);
            }
            if (patch instanceof CompositePatch) {
                CompositePatchValidatorAndGenerator.addApplicabilityTargets((CompositePatch)patch, applicableTarget);
            }
        }
        if (patch instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)patch;
            if (esysPatch.getSubPatches() == null || esysPatch.getSubPatches().isEmpty()) {
                throw new PatchPackageException("The given engineered system patch doesn't contain any supported sub patches.");
            }
            OPlan.getInstance();
            int ver = OUIDriver.compareOPatchVersion((String)OPlan.getVersionInfo(), (String)esysPatch.getMinOPlanVersion());
            if (ver < 0) {
                logger.severe("Older version of oplan found. Recommending to upgrade.");
                Object[] objectArray = new Object[2];
                objectArray[0] = esysPatch.getMinOPlanVersion();
                OPlan.getInstance();
                objectArray[1] = OPlan.getVersionInfo();
                throw new OPlanUserException("PLEASE_UPGRADE_OPLAN", objectArray);
            }
            for (GenericPatch subPatch : esysPatch.getSubPatches()) {
                List<Object> oplanRecognizedTargets = new ArrayList();
                oplanRecognizedTargets = OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(subPatch.getApplicableTargets());
                subPatch.setApplicableTargets(oplanRecognizedTargets);
            }
        }
        OPlan.getInstance().getLogger().resetIntegrationLog();
        return patch;
    }

    @Override
    public PatchPackage getPatchPackageFromZip(ZipInputStream patchZip, String patchLocationWhilePatching, String patchId) throws PatchPackageException {
        OPlan.getInstance().getLogger().setupLogs();
        assert (patchZip != null);
        assert (patchLocationWhilePatching != null);
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new CompositePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
        pf.addZipStreamMapConstructor((ZipStreamMapConstructor)new OPlanZipStreamMapConstructor());
        PatchPackage instance = pf.getInstance((InputStream)patchZip);
        if (instance instanceof OPatchSingleton) {
            OPatchSingleton singletonPatch = (OPatchSingleton)instance;
            singletonPatch.setPatchLocation(patchLocationWhilePatching);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return singletonPatch;
        }
        if (instance instanceof CompositePatch) {
            CompositePatch compositePatch = (CompositePatch)instance;
            compositePatch.setPatchLocation(patchLocationWhilePatching);
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
            applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
            compositePatch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return compositePatch;
        }
        if (instance instanceof PatchBundle) {
            PatchBundle bundlePatch = (PatchBundle)instance;
            this.setPatchLocationForBundlePatch((Bundle)bundlePatch, patchLocationWhilePatching);
            bundlePatch.setPatchID(patchId);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return bundlePatch;
        }
        if (instance instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)instance;
            EngineeredSystemPatchGeneratorForZip esysPatchGenerator = new EngineeredSystemPatchGeneratorForZip();
            String resourceBundle = esysPatch.getResourceBundle();
            String bundleXmlLocation = esysPatch.getBundleXmlLoc();
            esysPatch = (EngineeredSystemPatch)esysPatchGenerator.generate(esysPatch.getBundleXml(), patchZip, patchLocationWhilePatching, esysPatch.getAutoXmls());
            esysPatch.setResourceBundle(resourceBundle);
            esysPatch.setBundleXmlLoc(bundleXmlLocation);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return esysPatch;
        }
        OPlan.getInstance().getLogger().resetIntegrationLog();
        throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
    }

    @Override
    @Deprecated
    public PatchPackage getPatchPackageFromZip(ZipInputStream patchZip, String patchLocationWhilePatching) throws PatchPackageException {
        OPlan.getInstance().getLogger().setupLogs();
        assert (patchZip != null);
        assert (patchLocationWhilePatching != null);
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new CompositePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
        pf.addZipStreamMapConstructor((ZipStreamMapConstructor)new OPlanZipStreamMapConstructor());
        PatchPackage instance = pf.getInstance((InputStream)patchZip);
        if (instance instanceof OPatchSingleton) {
            OPatchSingleton singletonPatch = (OPatchSingleton)instance;
            singletonPatch.setPatchLocation(patchLocationWhilePatching);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return singletonPatch;
        }
        if (instance instanceof CompositePatch) {
            CompositePatch compositePatch = (CompositePatch)instance;
            compositePatch.setPatchLocation(patchLocationWhilePatching);
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
            applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
            compositePatch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return compositePatch;
        }
        if (instance instanceof PatchBundle) {
            PatchBundle bundlePatch = (PatchBundle)instance;
            this.setPatchLocationForBundlePatch((Bundle)bundlePatch, patchLocationWhilePatching);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return bundlePatch;
        }
        if (instance instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)instance;
            EngineeredSystemPatchGeneratorForZip esysPatchGenerator = new EngineeredSystemPatchGeneratorForZip();
            String resourceBundle = esysPatch.getResourceBundle();
            String bundleXmlLocation = esysPatch.getBundleXmlLoc();
            esysPatch = (EngineeredSystemPatch)esysPatchGenerator.generate(esysPatch.getBundleXml(), patchZip, patchLocationWhilePatching, esysPatch.getAutoXmls());
            esysPatch.setResourceBundle(resourceBundle);
            esysPatch.setBundleXmlLoc(bundleXmlLocation);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return esysPatch;
        }
        OPlan.getInstance().getLogger().resetIntegrationLog();
        throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
    }

    @Override
    public PatchPackage getPatchPackageFromTGZ(TarArchiveInputStream patchTarGZ, String patchLocationWhilePatching, String patchId) throws PatchPackageException {
        OPlan.getInstance().getLogger().setupLogs();
        assert (patchTarGZ != null);
        assert (patchLocationWhilePatching != null);
        PatchFactory pf = new PatchFactory();
        logger.log(Level.FINE, "Adding to the patch factory all supported PatchValidatorsAndGenerators. ");
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new CompositePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchBundlePatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator((PatchValidatorAndGenerator)new OPatchSingletonPatchValidatorAndGenerator());
        pf.addTarArchiveStreamMapConstructor((TarArchiveStreamMapConstructor)new OPlanTarArchiveInputStreamMapConstructor());
        PatchPackage instance = pf.getInstance((InputStream)patchTarGZ);
        if (instance instanceof OPatchSingleton) {
            OPatchSingleton singletonPatch = (OPatchSingleton)instance;
            singletonPatch.setPatchLocation(patchLocationWhilePatching);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return singletonPatch;
        }
        if (instance instanceof CompositePatch) {
            CompositePatch compositePatch = (CompositePatch)instance;
            compositePatch.setPatchLocation(patchLocationWhilePatching);
            ArrayList<String> applicableTarget = new ArrayList<String>(1);
            OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
            applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
            compositePatch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return compositePatch;
        }
        if (instance instanceof PatchBundle) {
            PatchBundle bundlePatch = (PatchBundle)instance;
            this.setPatchLocationForBundlePatch((Bundle)bundlePatch, patchLocationWhilePatching);
            bundlePatch.setPatchID(patchId);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return bundlePatch;
        }
        if (instance instanceof EngineeredSystemPatch) {
            EngineeredSystemPatch esysPatch = (EngineeredSystemPatch)instance;
            EngineeredSystemPatchGeneratorForZip esysPatchGenerator = new EngineeredSystemPatchGeneratorForZip();
            String resourceBundle = esysPatch.getResourceBundle();
            String bundleXmlLocation = esysPatch.getBundleXmlLoc();
            esysPatch = (EngineeredSystemPatch)esysPatchGenerator.generate(esysPatch.getBundleXml(), (InputStream)patchTarGZ, patchLocationWhilePatching, esysPatch.getAutoXmls());
            esysPatch.setResourceBundle(resourceBundle);
            esysPatch.setBundleXmlLoc(bundleXmlLocation);
            OPlan.getInstance().getLogger().resetIntegrationLog();
            return esysPatch;
        }
        OPlan.getInstance().getLogger().resetIntegrationLog();
        throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported and could not be validated/generated by any of the PatchValidatorAndGenerator.");
    }

    private void setPatchLocationForBundlePatch(Bundle patch, String patchLocationWhilePatching) {
        String FileSeparator = OPlan.getInstance().getOPlanEnv().isTargetOnWindows() ? "\\" : "/";
        patch.setPatchLocation(patchLocationWhilePatching);
        List subPatches = patch.getSubPatches();
        for (GenericPatch subPatch : subPatches) {
            String subPatchLocation = patchLocationWhilePatching + FileSeparator + subPatch.getPatchLocation();
            subPatch.setPatchLocation(subPatchLocation);
        }
    }

    @Override
    public PatchPackagesBag getPatchPackageBagInstance() {
        return new PatchPackagesBag(){

            protected boolean shouldAddToBag(PatchPackage p) {
                return true;
            }
        };
    }

    @Override
    public PatchPackage getPatchPackage(String patchId, String patchLocationWhilePatching, List<String> applicableTargets, boolean isComposite) throws PatchPackageException {
        OPlan.getInstance().getLogger().setupLogs();
        assert (patchId != null);
        assert (patchLocationWhilePatching != null);
        assert (applicableTargets != null);
        assert (applicableTargets.size() > 0);
        OPatchSingleton patch = null;
        if (!isComposite) {
            OPatchSingletonPatchValidatorAndGenerator osvg = new OPatchSingletonPatchValidatorAndGenerator();
            patch = osvg.generate(patchId, patchLocationWhilePatching, applicableTargets);
        } else {
            CompositePatchValidatorAndGenerator cpvg = new CompositePatchValidatorAndGenerator();
            patch = cpvg.generate(patchId, patchLocationWhilePatching, applicableTargets);
        }
        OPlan.getInstance().getLogger().resetIntegrationLog();
        return patch;
    }

    @Override
    public PatchPackage getPatchBundleFromBundleStream(InputStream bundleXmlStream, String patchLocationWhilePatching) throws PatchPackageException {
        PatchPackage patch;
        String bundlexmlContent;
        OPlan.getInstance().getLogger().setupLogs();
        try {
            bundlexmlContent = IOUtils.getContent(bundleXmlStream).toString();
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the bundleXml input stream", (Throwable)e);
        }
        try {
            PatchBundlexml pbxml = new PatchBundlexml(bundlexmlContent);
            OPatchBundlePatchValidatorAndGenerator obpvg = new OPatchBundlePatchValidatorAndGenerator();
            patch = obpvg.generate(bundlexmlContent, patchLocationWhilePatching, null);
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream.", (Throwable)e);
        }
        catch (BundleXmlException e) {
            throw new PatchPackageException((Throwable)e);
        }
        catch (BundleValidationException e) {
            try {
                BundleXmlHelper bhxml = new BundleXmlHelper();
                SystemPatchBundleXML esysbundle = bhxml.readBundle(bundlexmlContent);
                EngineeredSystemPatchGeneratorForZip espgZip = new EngineeredSystemPatchGeneratorForZip();
                patch = espgZip.generate(bundlexmlContent, patchLocationWhilePatching, null);
                if (((EngineeredSystemPatch)patch).getSubPatches() == null || ((EngineeredSystemPatch)patch).getSubPatches().isEmpty()) {
                    throw new PatchPackageException("The given engineered system patch doesn't contain any supported sub patches.");
                }
                OPlan.getInstance();
                int ver = OUIDriver.compareOPatchVersion((String)OPlan.getVersionInfo(), (String)((EngineeredSystemPatch)patch).getMinOPlanVersion());
                if (ver < 0) {
                    logger.severe("Older version of oplan found. Recommending to upgrade.");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ((EngineeredSystemPatch)patch).getMinOPlanVersion();
                    OPlan.getInstance();
                    objectArray[1] = OPlan.getVersionInfo();
                    throw new OPlanUserException("PLEASE_UPGRADE_OPLAN", objectArray);
                }
            }
            catch (BundleXmlException ex) {
                throw new PatchPackageException((Throwable)ex);
            }
            catch (BundleValidationException ex) {
                throw new PatchPackageException("The patchZip given is neither a Bundle Patch nor an Engineered System Patch", (Throwable)ex);
            }
        }
        if (patch == null) {
            throw new PatchPackageException("Couldn't generate the patch object because the patch is not supported andcould not be validated/generated by any of the PatchValidatorAndGenerator.");
        }
        OPlan.getInstance().getLogger().resetIntegrationLog();
        return patch;
    }
}

